/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.ArrayList;
import java.util.StringJoiner;
import mchorse.blockbuster.utils.mclib.BBIcons;
import mchorse.blockbuster_pack.morphs.ParticleMorph;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiParticleMorph
extends GuiAbstractMorph<ParticleMorph> {
    public GuiParticleMorphGeneralPanel general;
    public GuiParticleMorphMorphPanel panel;

    public GuiParticleMorph(Minecraft mc) {
        super(mc);
        this.general = new GuiParticleMorphGeneralPanel(mc, this);
        this.defaultPanel = this.general;
        this.panel = new GuiParticleMorphMorphPanel(mc, this);
        this.registerPanel(this.general, IKey.lang((String)"blockbuster.gui.particle.tooltip"), BBIcons.PARTICLE);
        this.registerPanel(this.panel, IKey.lang((String)"blockbuster.gui.particle.morph"), Icons.POSE);
        this.renderer.setVisible(false);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof ParticleMorph;
    }

    public static class GuiParticleMorphMorphPanel
    extends GuiMorphPanel<ParticleMorph, GuiParticleMorph> {
        public GuiNestedEdit pickMorph;
        public GuiButtonElement pickType;
        public GuiStringListElement type;
        public GuiToggleElement yaw;
        public GuiToggleElement pitch;
        public GuiToggleElement sequencer;
        public GuiToggleElement random;
        public GuiTrackpadElement fade;
        public GuiTrackpadElement lifeSpan;
        public GuiTrackpadElement maximum;

        public GuiParticleMorphMorphPanel(Minecraft mc, GuiParticleMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.pickMorph = new GuiNestedEdit(mc, editing -> {
                ParticleMorph particle = (ParticleMorph)this.morph;
                ((GuiParticleMorph)this.editor).morphs.nestEdit(particle.morph, editing.booleanValue(), morph -> {
                    particle.morph = MorphUtils.copy((AbstractMorph)morph);
                });
            });
            this.pickType = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.particle.pick_type"), b -> this.type.toggleVisible());
            this.pickType.tooltip(IKey.lang((String)"blockbuster.gui.particle.pick_type_tooltip"), Direction.RIGHT);
            this.type = new GuiStringListElement(mc, value -> {
                ((ParticleMorph)this.morph).movementType = ParticleMorph.MorphParticle.MovementType.getType((String)value.get(0));
            });
            for (ParticleMorph.MorphParticle.MovementType type : ParticleMorph.MorphParticle.MovementType.values()) {
                this.type.add((Object)type.id);
            }
            this.type.sort();
            this.type.background();
            this.yaw = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.yaw"), false, b -> {
                ((ParticleMorph)this.morph).yaw = this.yaw.isToggled();
            });
            this.pitch = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.pitch"), false, b -> {
                ((ParticleMorph)this.morph).pitch = this.pitch.isToggled();
            });
            this.sequencer = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.sequencer"), false, b -> {
                ((ParticleMorph)this.morph).sequencer = this.sequencer.isToggled();
            });
            this.random = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.random"), false, b -> {
                ((ParticleMorph)this.morph).random = this.random.isToggled();
            });
            this.fade = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).fade = value.intValue();
            });
            this.fade.tooltip(IKey.lang((String)"blockbuster.gui.particle.fade"));
            this.fade.limit(0.0, 2.147483647E9, true);
            this.lifeSpan = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).lifeSpan = value.intValue();
            });
            this.lifeSpan.tooltip(IKey.lang((String)"blockbuster.gui.gun.life_span"));
            this.lifeSpan.limit(0.0, 2.147483647E9, true);
            this.maximum = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).maximum = value.intValue();
            });
            this.maximum.tooltip(IKey.lang((String)"blockbuster.gui.particle.maximum"));
            this.maximum.limit(1.0, 2.147483647E9, true);
            this.type.flex().relative((GuiElement)this.pickType).set(0.0f, 20.0f, 0.0f, 80.0f).w(1.0f);
            GuiElement element = new GuiElement(mc);
            element.flex().relative((GuiElement)this).wh(1.0f, 1.0f).column(5).width(110).padding(10).height(20);
            element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.particle.morph")), this.pickMorph, this.pickType, this.fade, this.lifeSpan, this.maximum, this.yaw, this.pitch, this.sequencer, this.random});
            this.add(new IGuiElement[]{element, this.type});
        }

        public void fillData(ParticleMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.type.setVisible(false);
            this.type.setCurrentScroll((Object)morph.movementType.id);
            this.yaw.toggled(morph.yaw);
            this.pitch.toggled(morph.pitch);
            this.sequencer.toggled(morph.sequencer);
            this.random.toggled(morph.random);
            this.fade.setValue((double)morph.fade);
            this.lifeSpan.setValue((double)morph.lifeSpan);
            this.maximum.setValue((double)morph.maximum);
        }
    }

    public static class GuiParticleMorphGeneralPanel
    extends GuiMorphPanel<ParticleMorph, GuiParticleMorph> {
        public GuiCirculateElement mode;
        public GuiTrackpadElement frequency;
        public GuiTrackpadElement duration;
        public GuiTrackpadElement delay;
        public GuiTrackpadElement cap;
        public GuiButtonElement pickParticle;
        public GuiStringListElement type;
        public GuiTrackpadElement x;
        public GuiTrackpadElement y;
        public GuiTrackpadElement z;
        public GuiTrackpadElement dx;
        public GuiTrackpadElement dy;
        public GuiTrackpadElement dz;
        public GuiTrackpadElement speed;
        public GuiTrackpadElement count;
        public GuiToggleElement localRotation;
        public GuiTextElement args;

        public GuiParticleMorphGeneralPanel(Minecraft mc, GuiParticleMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.mode = new GuiCirculateElement(mc, b -> {
                ((ParticleMorph)this.morph).mode = ParticleMorph.ParticleMode.values()[this.mode.getValue()];
            });
            this.mode.addLabel(IKey.lang((String)"blockbuster.gui.particle.types.vanilla"));
            this.mode.addLabel(IKey.lang((String)"blockbuster.gui.particle.types.morph"));
            this.mode.tooltip(IKey.lang((String)"blockbuster.gui.particle.type"));
            this.frequency = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).frequency = value.intValue();
            });
            this.frequency.tooltip(IKey.lang((String)"blockbuster.gui.particle.frequency"));
            this.frequency.limit(1.0, 2.147483647E9, true);
            this.duration = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).duration = value.intValue();
            });
            this.duration.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.duration"));
            this.duration.limit(-1.0, 2.147483647E9, true);
            this.delay = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).delay = value.intValue();
            });
            this.delay.tooltip(IKey.lang((String)"blockbuster.gui.gun.delay"));
            this.delay.limit(0.0, 2.147483647E9, true);
            this.cap = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).cap = value.intValue();
            });
            this.cap.tooltip(IKey.lang((String)"blockbuster.gui.particle.cap"));
            this.cap.limit(0.0, 2.147483647E9, true);
            this.pickParticle = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.particle.particle"), b -> this.type.toggleVisible());
            this.type = new GuiStringListElement(mc, value -> {
                ((ParticleMorph)this.morph).vanillaType = EnumParticleTypes.func_186831_a((String)((String)value.get(0)));
            });
            this.type.background();
            for (EnumParticleTypes type : EnumParticleTypes.values()) {
                this.type.add((Object)type.func_179346_b());
            }
            this.type.sort();
            this.x = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).vanillaX = value;
            });
            this.x.tooltip(IKey.lang((String)"blockbuster.gui.model_block.x"));
            this.y = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).vanillaY = value;
            });
            this.y.tooltip(IKey.lang((String)"blockbuster.gui.model_block.y"));
            this.z = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).vanillaZ = value;
            });
            this.z.tooltip(IKey.lang((String)"blockbuster.gui.model_block.z"));
            this.dx = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).vanillaDX = value;
            });
            this.dx.tooltip(IKey.lang((String)"blockbuster.gui.particle.dx"));
            this.dy = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).vanillaDY = value;
            });
            this.dy.tooltip(IKey.lang((String)"blockbuster.gui.particle.dy"));
            this.dz = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).vanillaDZ = value;
            });
            this.dz.tooltip(IKey.lang((String)"blockbuster.gui.particle.dz"));
            this.speed = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).speed = value;
            });
            this.speed.tooltip(IKey.lang((String)"blockbuster.gui.particle.speed"));
            this.localRotation = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.particle.local_rotation"), b -> {
                ((ParticleMorph)this.morph).localRotation = b.isToggled();
            });
            this.localRotation.tooltip(IKey.lang((String)"blockbuster.gui.particle.local_rotation_tooltip"));
            this.count = new GuiTrackpadElement(mc, value -> {
                ((ParticleMorph)this.morph).count = value.intValue();
            });
            this.count.tooltip(IKey.lang((String)"blockbuster.gui.particle.count"));
            this.count.limit(1.0, 2.147483647E9, true);
            this.args = new GuiTextElement(mc, value -> {
                String[] splits = value.split(",");
                ArrayList<Integer> integerList = new ArrayList<Integer>();
                for (String split : splits) {
                    try {
                        integerList.add(Integer.parseInt(split.trim()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int[] array = new int[integerList.size()];
                int i = 0;
                for (Integer integer : integerList) {
                    array[i++] = integer;
                }
                ((ParticleMorph)this.morph).arguments = array;
            });
            this.type.flex().relative((GuiElement)this.pickParticle).set(0.0f, 20.0f, 0.0f, 80.0f).w(1.0f);
            GuiElement element = new GuiElement(mc);
            element.flex().relative((GuiElement)this).wh(1.0f, 1.0f).column(5).width(110).padding(10).height(20);
            element.add(new IGuiElement[]{this.mode, this.pickParticle});
            element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.particle.emission")).marginTop(12), this.frequency, this.duration, this.delay, this.cap, this.speed, this.count});
            element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.particle.vanilla")).marginTop(12), this.x, this.y, this.z});
            element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.particle.common")).marginTop(12), this.dx, this.dy, this.dz});
            element.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.particle.args")).marginTop(12), this.args, this.localRotation});
            this.add(new IGuiElement[]{element, this.type});
        }

        public void fillData(ParticleMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.mode.setValue(morph.mode == ParticleMorph.ParticleMode.MORPH ? 1 : 0);
            this.frequency.setValue((double)morph.frequency);
            this.duration.setValue((double)morph.duration);
            this.delay.setValue((double)morph.delay);
            this.cap.setValue((double)morph.cap);
            this.type.setVisible(false);
            this.type.setCurrentScroll((Object)(morph.vanillaType == null ? "" : morph.vanillaType.func_179346_b()));
            this.x.setValue((double)((float)morph.vanillaX));
            this.y.setValue((double)((float)morph.vanillaY));
            this.z.setValue((double)((float)morph.vanillaZ));
            this.dx.setValue((double)((float)morph.vanillaDX));
            this.dy.setValue((double)((float)morph.vanillaDY));
            this.dz.setValue((double)((float)morph.vanillaDZ));
            this.speed.setValue((double)((float)morph.speed));
            this.localRotation.toggled(morph.localRotation);
            this.count.setValue((double)morph.count);
            StringJoiner joiner = new StringJoiner(", ");
            for (int value : morph.arguments) {
                joiner.add(String.valueOf(value));
            }
            this.args.setText(joiner.toString());
        }
    }
}

