/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.client.gui.GuiImmersiveMorphMenu;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster_pack.morphs.SequencerMorph;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.tooltips.LabelTooltip;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.IMorphGenerator;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsList;
import mchorse.metamorph.client.gui.creative.GuiMorphRenderer;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSequencerMorph
extends GuiAbstractMorph<SequencerMorph> {
    public GuiSequencerMorphPanel general;

    public GuiSequencerMorph(Minecraft mc) {
        super(mc);
        this.general = new GuiSequencerMorphPanel(mc, this);
        this.defaultPanel = this.general;
        this.registerPanel(this.general, IKey.lang((String)"blockbuster.morph.sequencer"), Icons.GEAR);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof SequencerMorph;
    }

    protected GuiModelRenderer createMorphRenderer(Minecraft mc) {
        return new GuiSequencerMorphRenderer(mc);
    }

    public int getCurrentTick() {
        return this.general.getCurrentTick();
    }

    public static class GuiSequencerMorphRenderer
    extends GuiMorphRenderer {
        public static final SequencerMorph PREVIEWER = new SequencerMorph();
        public boolean playing;
        public int tick;
        public float partialTicks;
        public float lastTicks;

        public GuiSequencerMorphRenderer(Minecraft mc) {
            super(mc);
        }

        protected void drawUserModel(GuiContext context) {
            this.doRender(context, this.entity, 0.0, 0.0, 0.0);
        }

        public void doRender(GuiContext context, EntityLivingBase entity, double x, double y, double z) {
            if (this.morph == null) {
                return;
            }
            float current = (float)context.tick + context.partialTicks;
            if (this.morph == PREVIEWER && this.playing) {
                float ticks = (float)this.tick + this.partialTicks;
                float delta = MathUtils.clamp((float)(current - this.lastTicks), (float)0.0f, (float)10.0f);
                ticks += delta;
                delta = (int)ticks - this.tick;
                this.tick = (int)ticks;
                this.partialTicks = ticks - (float)this.tick;
                if (delta > 0.0f) {
                    PREVIEWER.pause(null, this.tick);
                    PREVIEWER.resume();
                }
            }
            MorphUtils.render((AbstractMorph)this.morph, (EntityLivingBase)entity, (double)x, (double)y, (double)z, (float)this.yaw, (float)this.partialTicks);
            this.lastTicks = current;
        }
    }

    public static class GuiSequenceEntryList
    extends GuiListElement<SequencerMorph.SequenceEntry> {
        public static IKey ticks = IKey.lang((String)"blockbuster.gui.sequencer.ticks");

        public GuiSequenceEntryList(Minecraft mc, Consumer<List<SequencerMorph.SequenceEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 24;
        }

        protected void drawElementPart(SequencerMorph.SequenceEntry element, int i, int x, int y, boolean hover, boolean selected) {
            GuiContext context = GuiBase.getCurrent();
            if (element.morph != null) {
                GuiDraw.scissor((int)x, (int)y, (int)this.scroll.w, (int)this.scroll.scrollItemSize, (GuiContext)context);
                element.morph.renderOnScreen((EntityPlayer)this.mc.field_71439_g, x + this.scroll.w - 16, y + 30, 20.0f, 1.0f);
                GuiDraw.unscissor((GuiContext)context);
            }
            super.drawElementPart((Object)element, i, x, y, hover, selected);
        }

        protected String elementToString(SequencerMorph.SequenceEntry element) {
            int index = this.getIndexByElement(element);
            String title = String.format("%3d | ", index + 1) + element.duration + " " + ticks.get();
            if (element.morph == null) {
                title = title + " " + I18n.func_135052_a((String)"blockbuster.gui.sequencer.no_morph", (Object[])new Object[0]);
            }
            return title;
        }

        private int getIndexByElement(SequencerMorph.SequenceEntry element) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (this.list.get(i) != element) continue;
                return i;
            }
            return this.list.indexOf(element);
        }
    }

    public static class GuiSequencerMorphPanel
    extends GuiMorphPanel<SequencerMorph, GuiSequencerMorph> {
        public GuiElement elements;
        public GuiElement elementsTop;
        private GuiListElement<SequencerMorph.SequenceEntry> list;
        private GuiButtonElement addPart;
        private GuiButtonElement removePart;
        private GuiTrackpadElement loop;
        private GuiTrackpadElement offsetX;
        private GuiTrackpadElement offsetY;
        private GuiTrackpadElement offsetZ;
        private GuiTrackpadElement offsetCount;
        private GuiNestedEdit pick;
        private GuiTrackpadElement duration;
        private GuiTrackpadElement random;
        private GuiToggleElement setDuration;
        private GuiToggleElement endPoint;
        private GuiToggleElement reverse;
        private GuiToggleElement randomOrder;
        private GuiToggleElement trulyRandomOrder;
        private GuiToggleElement keepProgress;
        public SequencerMorph.SequenceEntry entry;
        public GuiTrackpadElement preview;
        public GuiIconElement plause;
        public GuiIconElement stop;
        public GuiElement previewBar;
        public GuiButtonElement generateMorph;
        public GuiTrackpadElement prevSkins;
        public GuiColorElement prevColor;
        public GuiTrackpadElement nextSkins;
        public GuiColorElement nextColor;
        public GuiColorElement loopColor;
        public GuiSequencerMorphRenderer previewRenderer;
        private boolean isFrameSkin;
        private Vec3d offsetSkinPos;
        private GuiCreativeMorphsList.OnionSkin offsetSkin;

        public GuiSequencerMorphPanel(Minecraft mc, GuiSequencerMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.elements = new GuiElement(mc);
            this.elements.flex().relative((GuiElement)this).xy(1.0f, 1.0f).w(130).anchor(1.0f, 1.0f).column(5).vertical().stretch().padding(10);
            this.elementsTop = new GuiElement(mc);
            this.elementsTop.flex().relative((GuiElement)this).xy(1.0f, 0.0f).w(130).anchor(1.0f, 0.0f).column(5).vertical().stretch().padding(10);
            this.list = new GuiSequenceEntryList(mc, entry -> {
                this.select((SequencerMorph.SequenceEntry)entry.get(0));
                this.stopPlayback();
            });
            this.list.sorting().background();
            this.addPart = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.add"), b -> {
                SequencerMorph.SequenceEntry current = (SequencerMorph.SequenceEntry)this.list.getCurrentFirst();
                SequencerMorph.SequenceEntry entry = new SequencerMorph.SequenceEntry(current == null ? null : MorphUtils.copy((AbstractMorph)current.morph));
                if (current != null) {
                    entry.duration = current.duration;
                    entry.random = current.random;
                }
                if (GuiScreen.func_146271_m()) {
                    this.list.getList().add(this.list.getIndex() + 1, entry);
                    this.list.setIndex(this.list.getIndex() + 1);
                } else {
                    this.list.getList().add(entry);
                    this.list.setIndex(this.list.getList().size() - 1);
                }
                this.select(entry);
                this.list.update();
                this.stopPlayback();
            });
            this.addPart.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.add_part_tooltip"));
            this.removePart = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.remove"), b -> {
                if (!this.list.isDeselected()) {
                    int index = this.list.getIndex();
                    this.list.getList().remove(index);
                    this.list.setIndex(index - 1);
                    this.select((SequencerMorph.SequenceEntry)this.list.getCurrentFirst());
                    this.list.update();
                    this.stopPlayback();
                }
            });
            this.loop = new GuiTrackpadElement(mc, value -> {
                ((SequencerMorph)this.morph).loop = value.intValue();
                this.stopPlayback();
            });
            this.loop.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.loop_tooltip"));
            this.loop.integer().limit(0.0);
            this.offsetX = new GuiTrackpadElement(mc, value -> {
                ((SequencerMorph)this.morph).offset[0] = value.floatValue();
                this.stopPlayback();
                this.updateOnionSkins();
            });
            this.offsetX.tooltip(IKey.lang((String)"mclib.gui.transforms.x"));
            this.offsetY = new GuiTrackpadElement(mc, value -> {
                ((SequencerMorph)this.morph).offset[1] = value.floatValue();
                this.stopPlayback();
                this.updateOnionSkins();
            });
            this.offsetY.tooltip(IKey.lang((String)"mclib.gui.transforms.y"));
            this.offsetZ = new GuiTrackpadElement(mc, value -> {
                ((SequencerMorph)this.morph).offset[2] = value.floatValue();
                this.stopPlayback();
                this.updateOnionSkins();
            });
            this.offsetZ.tooltip(IKey.lang((String)"mclib.gui.transforms.z"));
            this.offsetCount = new GuiTrackpadElement(mc, value -> {
                ((SequencerMorph)this.morph).offsetCount = value.intValue();
                this.stopPlayback();
                this.updateOnionSkins();
            });
            this.offsetCount.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.loop_offset_count"));
            this.offsetCount.integer().limit(0.0);
            this.pick = new GuiNestedEdit(mc, editing -> {
                if (this.entry == null) {
                    return;
                }
                SequencerMorph.SequenceEntry entry = this.entry;
                if (entry.morph instanceof SequencerMorph) {
                    ((GuiSequencerMorph)this.editor).morphs.onionSkins.clear();
                }
                ((GuiSequencerMorph)this.editor).morphs.nestEdit(entry.morph, editing.booleanValue(), true, morph -> {
                    entry.morph = MorphUtils.copy((AbstractMorph)morph);
                });
            });
            this.duration = new GuiTrackpadElement(mc, value -> {
                if (this.entry != null) {
                    ((SequencerMorph)this.morph).current = -1;
                    ((SequencerMorph)this.morph).timer = 0;
                    ((SequencerMorph)this.morph).duration = 0.0f;
                    ((SequencerMorph)this.morph).loopCount = 0;
                    ((SequencerMorph)this.morph).lastUpdate = 0.0f;
                    this.entry.duration = value.floatValue();
                    this.stopPlayback();
                    this.updateOnionSkins();
                }
            });
            this.duration.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.duration"));
            this.duration.limit(0.0, 3.4028234663852886E38);
            this.random = new GuiTrackpadElement(mc, value -> {
                if (this.entry != null) {
                    ((SequencerMorph)this.morph).current = -1;
                    ((SequencerMorph)this.morph).timer = 0;
                    ((SequencerMorph)this.morph).duration = 0.0f;
                    ((SequencerMorph)this.morph).loopCount = 0;
                    ((SequencerMorph)this.morph).lastUpdate = 0.0f;
                    this.entry.random = value.floatValue();
                    this.stopPlayback();
                    this.updateOnionSkins();
                }
            });
            this.random.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.random"));
            this.random.limit(0.0, 3.4028234663852886E38);
            this.setDuration = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.set_duration"), b -> {
                this.entry.setDuration = b.isToggled();
            });
            this.setDuration.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.set_duration_tooltip"), Direction.TOP);
            this.endPoint = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.end_point"), b -> {
                this.entry.endPoint = b.isToggled();
            });
            this.endPoint.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.end_point_tooltip"), Direction.TOP);
            this.reverse = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.reverse"), false, b -> {
                ((SequencerMorph)this.morph).reverse = b.isToggled();
                this.stopPlayback();
                this.updateOnionSkins();
            });
            this.randomOrder = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.random_order"), false, b -> {
                ((SequencerMorph)this.morph).isRandom = b.isToggled();
                this.stopPlayback();
                this.updatePreviewBar();
                this.updateOnionSkins();
            });
            this.trulyRandomOrder = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.truly_random_order"), false, b -> {
                ((SequencerMorph)this.morph).isTrulyRandom = b.isToggled();
                this.stopPlayback();
                this.updatePreviewBar();
            });
            this.keepProgress = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.keep_progress"), false, b -> {
                ((SequencerMorph)this.morph).keepProgress = b.isToggled();
            });
            this.addPart.flex().relative((IResizer)this.area).set(10.0f, 10.0f, 50.0f, 20.0f);
            this.removePart.flex().relative(this.addPart.resizer()).set(55.0f, 0.0f, 50.0f, 20.0f);
            this.list.flex().relative((IResizer)this.area).set(10.0f, 50.0f, 105.0f, 0.0f).hTo((IResizer)this.reverse.area, -5);
            this.keepProgress.flex().relative((GuiElement)this).x(10).y(1.0f, -24).w(105);
            this.randomOrder.flex().relative((GuiElement)this.keepProgress).y(-1.0f, -5).w(1.0f);
            this.trulyRandomOrder.flex().relative((GuiElement)this.randomOrder).y(-1.0f, -5).w(1.0f);
            this.reverse.flex().relative((GuiElement)this.trulyRandomOrder).y(-1.0f, -5).w(1.0f);
            this.preview = new GuiTrackpadElement(mc, value -> this.previewTick(value.floatValue()));
            this.preview.limit(0.0).metric().tooltip(IKey.lang((String)"blockbuster.gui.sequencer.preview_tick"));
            this.plause = new GuiIconElement(mc, Icons.PLAY, b -> this.togglePlay());
            this.plause.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.keys.toggle")).flex().wh(16, 20);
            this.stop = new GuiIconElement(mc, Icons.STOP, b -> this.stopPlayback());
            this.stop.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.keys.stop")).flex().wh(16, 20);
            this.previewBar = new GuiElement(mc);
            this.previewBar.flex().relative((GuiElement)this).x(130).y(10).wTo((IResizer)this.elementsTop.flex()).h(20).row(5).preferred(1);
            this.previewBar.add(new IGuiElement[]{this.plause, this.preview, this.stop});
            this.generateMorph = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.sequencer.generate_morph"), element -> {
                SequencerMorph previewer = GuiSequencerMorphRenderer.PREVIEWER;
                AbstractMorph morph = previewer.getMorph();
                if (morph instanceof IMorphGenerator) {
                    float partialTicks;
                    float progress = this.previewRenderer.partialTicks + (float)previewer.timer - previewer.lastDuration;
                    float duration = previewer.duration - previewer.lastDuration;
                    if (previewer.morphSetDuration) {
                        if (duration > 0.0f) {
                            partialTicks = progress * (float)Math.ceil(duration) / duration;
                            partialTicks -= (float)((int)partialTicks);
                        } else {
                            partialTicks = 1.0f;
                        }
                    } else {
                        partialTicks = progress - (float)((int)progress);
                    }
                    morph = ((IMorphGenerator)morph).genCurrentMorph(partialTicks);
                    this.setMorphDuration(morph, (int)Math.min(progress, duration));
                    SequencerMorph.SequenceEntry entry = new SequencerMorph.SequenceEntry(morph);
                    entry.duration = Math.min(progress, duration);
                    entry.setDuration = true;
                    this.list.getList().add(entry);
                    this.list.setIndex(this.list.getList().size() - 1);
                    this.select(entry);
                    this.list.update();
                    this.stopPlayback();
                }
            });
            this.generateMorph.flex().relative((GuiElement)this).x(0.5f).y(1.0f, -20).wh(100, 30).anchor(0.5f, 1.0f);
            this.generateMorph.tooltip(IKey.lang((String)"blockbuster.gui.sequencer.generate_morph_tooltip"));
            this.prevSkins = new GuiTrackpadElement(mc, Blockbuster.seqOnionSkinPrev, value -> this.updateOnionSkins()).limit(0.0, 10.0, true);
            this.prevSkins.tooltip(IKey.lang((String)Blockbuster.seqOnionSkinPrev.getLabelKey()));
            this.prevColor = new GuiColorElement(mc, Blockbuster.seqOnionSkinPrevColor, value -> this.updateOnionSkins()).noLabel();
            this.prevColor.tooltip(IKey.lang((String)Blockbuster.seqOnionSkinPrevColor.getLabelKey()));
            this.nextSkins = new GuiTrackpadElement(mc, Blockbuster.seqOnionSkinNext, value -> this.updateOnionSkins()).limit(0.0, 10.0, true);
            this.nextSkins.tooltip(IKey.lang((String)Blockbuster.seqOnionSkinNext.getLabelKey()));
            this.nextColor = new GuiColorElement(mc, Blockbuster.seqOnionSkinNextColor, value -> this.updateOnionSkins()).noLabel();
            this.nextColor.tooltip(IKey.lang((String)Blockbuster.seqOnionSkinNextColor.getLabelKey()));
            this.loopColor = new GuiColorElement(mc, Blockbuster.seqOnionSkinLoopColor, value -> this.updateOnionSkins()).noLabel();
            this.loopColor.tooltip(IKey.lang((String)Blockbuster.seqOnionSkinLoopColor.getLabelKey()));
            this.elements.add(new IGuiElement[]{this.pick, this.duration, this.random, this.setDuration, this.endPoint});
            this.elementsTop.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.config.onion_skin.title")), this.combinElements(this.prevSkins, this.prevColor), this.combinElements(this.nextSkins, this.nextColor), Elements.label((IKey)IKey.lang((String)"blockbuster.gui.sequencer.loop")), this.loop, Elements.label((IKey)IKey.lang((String)"blockbuster.gui.sequencer.loop_offset")), this.offsetX, this.offsetY, this.offsetZ, this.combinElements(this.offsetCount, this.loopColor)});
            this.add(new IGuiElement[]{this.addPart, this.removePart, this.keepProgress, this.randomOrder, this.trulyRandomOrder, this.reverse, this.list, this.elements, this.elementsTop, this.previewBar, this.generateMorph});
            this.keys().register(((LabelTooltip)this.plause.tooltip).label, 57, () -> this.plause.clickItself(GuiBase.getCurrent())).held(new int[]{42}).category(GuiAbstractMorph.KEY_CATEGORY);
            this.keys().register(((LabelTooltip)this.stop.tooltip).label, 57, () -> this.stop.clickItself(GuiBase.getCurrent())).held(new int[]{56}).category(GuiAbstractMorph.KEY_CATEGORY);
            this.previewRenderer = (GuiSequencerMorphRenderer)editor.renderer;
        }

        private void select(SequencerMorph.SequenceEntry entry) {
            this.entry = entry;
            if (entry != null) {
                this.pick.setMorph(entry.morph);
                this.duration.setValue((double)entry.duration);
                this.random.setValue((double)entry.random);
                this.setDuration.toggled(entry.setDuration);
                this.endPoint.toggled(entry.endPoint);
                ((GuiMorphRenderer)((GuiSequencerMorph)this.editor).renderer).morph = entry.morph;
                if (entry.morph instanceof IAnimationProvider) {
                    ((IAnimationProvider)entry.morph).getAnimation().reset();
                }
            } else {
                ((GuiMorphRenderer)((GuiSequencerMorph)this.editor).renderer).morph = null;
            }
            this.elements.setVisible(entry != null);
            this.updateOnionSkins();
        }

        private void previewTick(float ticks) {
            this.previewRenderer.tick = (int)ticks;
            this.previewRenderer.partialTicks = ticks - (float)this.previewRenderer.tick;
            if (this.previewRenderer.playing) {
                this.togglePlay();
            }
            this.updatePreviewMorph();
        }

        private void togglePlay() {
            this.previewRenderer.playing = !this.previewRenderer.playing;
            this.updatePlauseButton();
            this.updatePreviewMorph();
        }

        private void updatePlauseButton() {
            this.plause.both(this.previewRenderer.playing ? Icons.PAUSE : Icons.PLAY);
        }

        private void stopPlayback() {
            this.previewRenderer.tick = 0;
            this.previewRenderer.partialTicks = 0.0f;
            this.previewRenderer.playing = false;
            this.updatePlauseButton();
            this.preview.setValue(0.0);
            if (this.previewRenderer.morph == GuiSequencerMorphRenderer.PREVIEWER) {
                this.list.setIndex(0);
                this.select((SequencerMorph.SequenceEntry)this.list.getCurrentFirst());
            }
        }

        private void updatePreviewMorph() {
            if (this.entry != null) {
                this.list.setIndex(-1);
                this.select(null);
            }
            if (this.previewRenderer.morph != GuiSequencerMorphRenderer.PREVIEWER) {
                GuiSequencerMorphRenderer.PREVIEWER.reset();
                GuiSequencerMorphRenderer.PREVIEWER.copy(this.morph);
                this.previewRenderer.morph = GuiSequencerMorphRenderer.PREVIEWER;
            }
            GuiSequencerMorphRenderer.PREVIEWER.pause(null, this.previewRenderer.tick);
            GuiSequencerMorphRenderer.PREVIEWER.resume();
        }

        private void updatePreviewBar() {
            boolean visible = !((SequencerMorph)this.morph).isRandom || !((SequencerMorph)this.morph).isTrulyRandom;
            this.previewBar.setVisible(visible);
            this.plause.setEnabled(visible);
            this.stop.setEnabled(visible);
        }

        private void resetPlayback() {
            this.stopPlayback();
            this.updatePreviewMorph();
        }

        public void fillData(SequencerMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.resetPlayback();
            this.list.setList(morph.morphs);
            this.list.setIndex(0);
            this.select((SequencerMorph.SequenceEntry)this.list.getCurrentFirst());
            this.reverse.toggled(morph.reverse);
            this.randomOrder.toggled(morph.isRandom);
            this.trulyRandomOrder.toggled(morph.isTrulyRandom);
            this.keepProgress.toggled(morph.keepProgress);
            this.loop.setValue((double)morph.loop);
            this.offsetX.setValue((double)morph.offset[0]);
            this.offsetY.setValue((double)morph.offset[1]);
            this.offsetZ.setValue((double)morph.offset[2]);
            this.offsetCount.setValue((double)morph.offsetCount);
            this.updatePreviewBar();
        }

        public void startEditing() {
            this.updateOnionSkins();
        }

        public void draw(GuiContext context) {
            this.updateLogic(context);
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.sequencer.morphs", (Object[])new Object[0]), (float)this.list.area.x, (float)(this.list.area.y - 12), 0xFFFFFF);
            super.draw(context);
        }

        private void updateLogic(GuiContext context) {
            AbstractMorph morph;
            double tick = (float)this.previewRenderer.tick + this.previewRenderer.partialTicks;
            if (Math.abs(this.preview.value - tick) > 0.01) {
                this.preview.setValue(tick);
            }
            boolean canGenerate = false;
            if (this.previewRenderer.morph == GuiSequencerMorphRenderer.PREVIEWER && !this.previewRenderer.playing && (morph = GuiSequencerMorphRenderer.PREVIEWER.getMorph()) instanceof IMorphGenerator) {
                canGenerate = ((IMorphGenerator)morph).canGenerate();
            }
            this.generateMorph.setVisible(canGenerate);
            GuiCreativeMorphsList editor = ((GuiSequencerMorph)this.editor).morphs;
            if (editor instanceof GuiImmersiveMorphMenu && ((GuiImmersiveMorphMenu)editor).getFrame(0) != null) {
                if (!this.isFrameSkin) {
                    this.updateOnionSkins();
                }
            } else {
                for (GuiCreativeMorphsList.OnionSkin skin : editor.onionSkins) {
                    if (this.previewRenderer.customEntity) {
                        skin.pitch = this.previewRenderer.entityPitch;
                        skin.yawHead = this.previewRenderer.entityYawHead;
                        skin.yawBody = this.previewRenderer.entityYawBody;
                    } else {
                        skin.pitch = 0.0f;
                        skin.yawHead = 0.0f;
                        skin.yawBody = 0.0f;
                    }
                    if (skin != this.offsetSkin) continue;
                    Vec3d pos = this.offsetSkinPos.func_178785_b((float)(-Math.toRadians(skin.yawBody)));
                    skin.offset.set(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                }
            }
        }

        public void setMorphDuration(AbstractMorph morph, int duration) {
            if (morph instanceof IAnimationProvider) {
                Animation animation = ((IAnimationProvider)morph).getAnimation();
                animation.duration = duration;
                animation.reset();
            }
            if (morph instanceof IBodyPartProvider) {
                for (BodyPart part : ((IBodyPartProvider)morph).getBodyPart().parts) {
                    this.setMorphDuration(part.morph.get(), duration);
                }
            }
        }

        public int getCurrentTick() {
            if (this.previewRenderer.morph == GuiSequencerMorphRenderer.PREVIEWER) {
                return this.previewRenderer.tick;
            }
            return ((SequencerMorph)this.morph).getTickAt(this.list.getIndex());
        }

        private GuiElement combinElements(GuiTrackpadElement trackpad, GuiColorElement color) {
            GuiElement element = new GuiElement(this.mc);
            element.flex().relative((GuiElement)trackpad).h(1.0f);
            element.add(new IGuiElement[]{color, trackpad});
            trackpad.flex().relative(element).xy(0.0f, 0.0f).wTo((IResizer)color.area);
            color.flex().relative(element).anchorX(1.0f).xy(1.0f, 0.0f).w(() -> Float.valueOf(color.flex().getH())).h(1.0f);
            return element;
        }

        public void updateOnionSkins() {
            Vec3d pos;
            GuiCreativeMorphsList.OnionSkin skin3;
            float factor;
            SequencerMorph.SequenceEntry entry;
            int index;
            this.isFrameSkin = false;
            List skins = ((GuiSequencerMorph)this.editor).morphs.onionSkins;
            skins.clear();
            if (this.list.isDeselected() || ((SequencerMorph)this.morph).isRandom) {
                return;
            }
            HashMap<GuiCreativeMorphsList.OnionSkin, Integer> tickMap = new HashMap<GuiCreativeMorphsList.OnionSkin, Integer>();
            Color prevColor = this.prevColor.picker.color;
            Color nextColor = this.nextColor.picker.color;
            Color loopColor = this.loopColor.picker.color;
            float pitch = this.previewRenderer.customEntity ? this.previewRenderer.entityPitch : 0.0f;
            float yawHead = this.previewRenderer.customEntity ? this.previewRenderer.entityYawHead : 0.0f;
            float yawBody = this.previewRenderer.customEntity ? this.previewRenderer.entityYawBody : 0.0f;
            int sign = ((SequencerMorph)this.morph).reverse ? -1 : 1;
            int i = 1;
            while ((double)i <= this.prevSkins.value && (index = this.list.getIndex() - sign * i) >= 0 && index < this.list.getList().size()) {
                entry = (SequencerMorph.SequenceEntry)this.list.getList().get(index);
                if (entry.morph != null) {
                    factor = 1.0f - (float)(i - 1) / (float)this.prevSkins.value;
                    skin3 = new GuiCreativeMorphsList.OnionSkin().morph(entry.morph.copy()).color(prevColor.r, prevColor.g, prevColor.b, prevColor.a * factor).offset(0.0, 0.0, 0.0, pitch, yawHead, yawBody);
                    if (entry.morph instanceof IAnimationProvider) {
                        MorphUtils.pause((AbstractMorph)skin3.morph, null, (int)0);
                    } else {
                        MorphUtils.pause((AbstractMorph)skin3.morph, null, (int)((int)entry.duration));
                    }
                    skins.add(skin3);
                    tickMap.put(skin3, ((SequencerMorph)this.morph).getTickAt(index));
                }
                ++i;
            }
            i = 1;
            while ((double)i <= this.nextSkins.value && (index = this.list.getIndex() + sign * i) >= 0 && index < this.list.getList().size()) {
                entry = (SequencerMorph.SequenceEntry)this.list.getList().get(index);
                if (entry.morph != null) {
                    factor = 1.0f - (float)(i - 1) / (float)this.nextSkins.value;
                    skin3 = new GuiCreativeMorphsList.OnionSkin().morph(entry.morph.copy()).color(nextColor.r, nextColor.g, nextColor.b, nextColor.a * factor).offset(0.0, 0.0, 0.0, pitch, yawHead, yawBody);
                    if (entry.morph instanceof IAnimationProvider) {
                        MorphUtils.pause((AbstractMorph)skin3.morph, null, (int)0);
                    } else {
                        MorphUtils.pause((AbstractMorph)skin3.morph, null, (int)((int)entry.duration));
                    }
                    skins.add(skin3);
                    tickMap.put(skin3, ((SequencerMorph)this.morph).getTickAt(index));
                }
                ++i;
            }
            GuiImmersiveMorphMenu menu = null;
            Frame current = null;
            if (((GuiSequencerMorph)this.editor).morphs instanceof GuiImmersiveMorphMenu) {
                menu = (GuiImmersiveMorphMenu)((GuiSequencerMorph)this.editor).morphs;
                current = menu.getFrame(this.getCurrentTick());
                boolean bl = this.isFrameSkin = current != null;
            }
            if (this.offsetCount.value > 0.0) {
                double baseMul = 0.0625 * (double)(((SequencerMorph)this.morph).reverse ? -1 : 1);
                SequencerMorph.SequenceEntry entry2 = (SequencerMorph.SequenceEntry)this.list.getList().get(((SequencerMorph)this.morph).reverse ? this.list.getList().size() - 1 : 0);
                GuiCreativeMorphsList.OnionSkin skin2 = new GuiCreativeMorphsList.OnionSkin().morph(entry2.morph.copy()).color(loopColor.r, loopColor.g, loopColor.b, loopColor.a).offset(this.offsetX.value * baseMul, this.offsetY.value * baseMul, this.offsetZ.value * baseMul, pitch, yawHead, yawBody);
                MorphUtils.pause((AbstractMorph)skin2.morph, null, (int)0);
                skins.add(skin2);
                tickMap.put(skin2, (int)((SequencerMorph)this.morph).getDuration());
                this.offsetSkin = skin2;
                this.offsetSkinPos = new Vec3d(skin2.offset.x, skin2.offset.y, skin2.offset.z);
                if (!this.isFrameSkin) {
                    pos = this.offsetSkinPos.func_178785_b((float)(-Math.toRadians(skin2.yawBody)));
                    skin2.offset.set(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                }
            } else {
                this.offsetSkin = null;
            }
            if (current != null) {
                boolean hasBodyYaw = current.hasBodyYaw;
                for (GuiCreativeMorphsList.OnionSkin skin3 : skins) {
                    Frame skinFrame = menu.getFrame((Integer)tickMap.get(skin3));
                    pos = new Vec3d(skin3.offset.x, skin3.offset.y, skin3.offset.z);
                    pos = pos.func_178785_b((float)(-Math.toRadians(hasBodyYaw ? (double)skinFrame.bodyYaw : (double)skinFrame.yaw)));
                    pos = pos.func_178787_e(new Vec3d(skinFrame.x - current.x, skinFrame.y - current.y, skinFrame.z - current.z));
                    pos = pos.func_178785_b((float)Math.toRadians(current.yaw));
                    skin3.offset(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, skinFrame.pitch, skinFrame.yawHead - current.yawHead, hasBodyYaw ? skinFrame.bodyYaw - current.bodyYaw : skinFrame.yawHead - current.yawHead);
                }
            }
        }

        public void fromNBT(NBTTagCompound tag) {
            super.fromNBT(tag);
            this.list.setIndex(tag.func_74762_e("Index"));
            SequencerMorph.SequenceEntry entry = (SequencerMorph.SequenceEntry)this.list.getCurrentFirst();
            if (entry != null) {
                this.select(entry);
            }
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound tag = super.toNBT();
            tag.func_74768_a("Index", this.list.getIndex());
            return tag;
        }
    }
}

