/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.morphs;

import java.util.Objects;
import java.util.UUID;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.client.render.tileentity.TileEntityModelItemStackRenderer;
import mchorse.blockbuster.client.textures.GifTexture;
import mchorse.blockbuster.common.block.BlockModel;
import mchorse.blockbuster.common.entity.ExpirableDummyEntity;
import mchorse.blockbuster_pack.morphs.CustomMorph;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.render.VertexBuilder;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.OptifineHelper;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.RenderingUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.api.morphs.utils.IAnimationProvider;
import mchorse.metamorph.api.morphs.utils.IMorphGenerator;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class LightMorph
extends AbstractMorph
implements IAnimationProvider,
ISyncableMorph,
IMorphGenerator {
    private LightAnimation animation = new LightAnimation();
    private LightProperties lightProperties = new LightProperties(15);
    private int light = 15;
    private ExpirableDummyEntity dummy;
    private Vector3f position = new Vector3f();
    private Vector3f prevPosition = new Vector3f();
    private boolean renderedOnScreen;
    private boolean renderedInEditor;
    private State state = State.CANUPDATE;
    private int lastRenderAge;

    public LightMorph() {
        this.name = "light";
    }

    public void setLightValue(int light) {
        this.light = MathUtils.clamp((int)light, (int)0, (int)15);
    }

    public int getLightValue() {
        return this.light;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public boolean isPaused() {
        return this.animation.paused;
    }

    public boolean canGenerate() {
        return this.animation.isInProgress();
    }

    public void update(EntityLivingBase target) {
        if (target.field_70170_p.field_72995_K && !this.renderedOnScreen && !this.renderedInEditor) {
            if (this.position.equals((Tuple3f)new Vector3f(0.0f, 0.0f, 0.0f))) {
                this.addDummyEntityToWorld(target);
            } else {
                this.addDummyEntityToWorld();
            }
            this.state = State.NOUPDATE;
        }
        this.animation.update();
        super.update(target);
    }

    @SideOnly(value=Side.CLIENT)
    private void updateDummyEntity() {
        if (this.dummy == null || this.state != State.CANUPDATE) {
            return;
        }
        this.dummy.setLifetime(this.dummy.getAge() + Math.abs(this.dummy.getAge() - this.lastRenderAge) + 2);
        this.updateDummyEntityPosition();
        this.dummy.func_184201_a(EntityEquipmentSlot.MAINHAND, BlockModel.getItemStack(this.lightProperties.lightValue));
        this.prevPosition.set((Tuple3f)this.position);
    }

    @SideOnly(value=Side.CLIENT)
    private void addDummyEntityToWorld() {
        this.addDummyEntityToWorld(null);
    }

    @SideOnly(value=Side.CLIENT)
    private void addDummyEntityToWorld(EntityLivingBase target) {
        if ((this.dummy == null || this.dummy.field_70128_L) && this.state == State.CANUPDATE) {
            this.dummy = new ExpirableDummyEntity((World)Minecraft.func_71410_x().field_71441_e, 1);
            this.updateDummyEntityPosition();
            if (target != null) {
                this.dummy.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
            }
            if (mchorse.mclib.events.RenderingHandler.isMinecraftRendering()) {
                RenderingHandler.registerRenderLastEvent(() -> Minecraft.func_71410_x().field_71441_e.func_73027_a(this.dummy.func_145782_y(), (Entity)this.dummy));
            } else {
                Minecraft.func_71410_x().field_71441_e.func_73027_a(this.dummy.func_145782_y(), (Entity)this.dummy);
            }
        }
    }

    private void updateDummyEntityPosition() {
        this.dummy.field_70169_q = this.prevPosition.x;
        this.dummy.field_70167_r = this.prevPosition.y;
        this.dummy.field_70166_s = this.prevPosition.z;
        this.dummy.field_70142_S = this.prevPosition.x;
        this.dummy.field_70137_T = this.prevPosition.y;
        this.dummy.field_70136_U = this.prevPosition.z;
        this.dummy.func_70107_b(this.position.x, this.position.y, this.position.z);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOnScreen(EntityPlayer entityPlayer, int x, int y, float scale, float alpha) {
        float partial = Minecraft.func_71410_x().func_184121_ak();
        this.updateAnimation(partial);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)((float)y - scale / 2.0f), (float)0.0f);
        GL11.glScalef((float)1.5f, (float)-1.5f, (float)1.5f);
        this.renderPictureTexture(new ResourceLocation("blockbuster", "textures/light_bulb.png"), scale, partial);
        GL11.glPopMatrix();
        this.renderedOnScreen = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(EntityLivingBase target, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean renderedInThirdPerson;
        if (OptifineHelper.isOptifineShadowPass()) {
            return;
        }
        EntityLivingBase lastItemHolder = RenderingHandler.getLastItemHolder();
        ItemCameraTransforms.TransformType itemTransformType = RenderingHandler.itemTransformType;
        this.renderedOnScreen = false;
        boolean renderedInHands = lastItemHolder != null && (itemTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || itemTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        boolean bl = renderedInThirdPerson = lastItemHolder != null && (itemTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || itemTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        if (renderedInHands || renderedInThirdPerson || itemTransformType == ItemCameraTransforms.TransformType.GROUND || !TileEntityModelItemStackRenderer.isRendering()) {
            this.state = State.CANUPDATE;
        }
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.updateAnimation(partialTicks);
        if (renderedInThirdPerson || lastItemHolder == null && (!TileEntityModelItemStackRenderer.isRendering() || itemTransformType == ItemCameraTransforms.TransformType.GROUND)) {
            Matrix4d[] transformation = MatrixUtils.getTransformation();
            Matrix4d translation = transformation[0];
            this.position.x = (float)translation.m03;
            this.position.y = (float)translation.m13;
            this.position.z = (float)translation.m23;
        } else if (renderedInHands) {
            this.position.x = (float)Interpolations.lerp((double)lastItemHolder.field_70169_q, (double)lastItemHolder.field_70165_t, (double)partialTicks);
            this.position.y = (float)Interpolations.lerp((double)lastItemHolder.field_70167_r, (double)lastItemHolder.field_70163_u, (double)partialTicks) + lastItemHolder.func_70047_e() - 0.15f;
            this.position.z = (float)Interpolations.lerp((double)lastItemHolder.field_70166_s, (double)lastItemHolder.field_70161_v, (double)partialTicks);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P || GuiModelRenderer.isRendering()) {
            GlStateManager.func_179094_E();
            RenderingUtils.glRevertRotationScale();
            this.renderPicture(partialTicks);
            GlStateManager.func_179121_F();
        }
        if (GuiModelRenderer.isRendering()) {
            this.addDummyEntityToWorld();
            this.renderedInEditor = true;
        } else {
            this.renderedInEditor = false;
        }
        if (!CustomMorph.isRenderingOnScreen()) {
            this.updateDummyEntity();
        }
        this.lastRenderAge = this.dummy != null ? this.dummy.getAge() : 0;
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPicture(float partialTicks) {
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)Interpolation.LINEAR.interpolate(lastBrightnessX, 240.0f, (float)this.lightProperties.lightValue / 15.0f), (float)lastBrightnessY);
        GlStateManager.func_179091_B();
        GL11.glPushMatrix();
        RenderingUtils.glFacingRotation((RenderingUtils.Facing)RenderingUtils.Facing.ROTATE_XYZ, (Vector3f)this.position);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        this.renderPictureTexture(new ResourceLocation("blockbuster", "textures/light_bulb" + this.lightProperties.lightValue + ".png"), 1.0f, partialTicks);
        GL11.glPopMatrix();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        GlStateManager.func_179101_C();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPictureTexture(ResourceLocation image, float scale, float partialTicks) {
        GifTexture.bindTexture(image, 0, partialTicks);
        boolean isCulling = GL11.glIsEnabled((int)2884);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        if (ReflectionUtils.isOptifineShadowPass()) {
            GlStateManager.func_179129_p();
        } else {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, VertexBuilder.getFormat((boolean)false, (boolean)true, (boolean)false, (boolean)true));
        int perspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        float width = scale * (float)(perspective == 2 ? -1 : 1) * 0.5f;
        float height = scale * 0.5f;
        buffer.func_181662_b((double)(-width), (double)height, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)(-height), 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)(-height), 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)(-height), 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)(-height), 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)height, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (isCulling) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void pause(AbstractMorph previous, int offset) {
        this.animation.pause(offset);
        if (previous instanceof LightMorph) {
            LightMorph lightMorph = (LightMorph)previous;
            if (lightMorph.animation.isInProgress()) {
                LightProperties newLast = new LightProperties();
                newLast.from(lightMorph);
                lightMorph.animation.apply(newLast, 1.0f);
                this.animation.last = newLast;
            } else {
                this.animation.last = new LightProperties();
                this.animation.last.from(lightMorph);
            }
        }
    }

    public AbstractMorph genCurrentMorph(float partialTicks) {
        LightMorph morph = (LightMorph)this.copy();
        morph.lightProperties.from(this);
        morph.animation.last = new LightProperties(this.animation.last.lightValue);
        morph.animation.apply(morph.lightProperties, partialTicks);
        morph.animation.duration = this.animation.progress;
        return morph;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateAnimation(float partialTicks) {
        if (this.animation.isInProgress()) {
            this.lightProperties.from(this);
            this.animation.apply(this.lightProperties, partialTicks);
        } else {
            this.lightProperties.from(this);
        }
    }

    public AbstractMorph create() {
        return new LightMorph();
    }

    public void copy(AbstractMorph from) {
        super.copy(from);
        if (from instanceof LightMorph) {
            LightMorph lightMorph = (LightMorph)from;
            this.light = lightMorph.light;
            this.animation.copy(lightMorph.animation);
            this.animation.reset();
        }
    }

    public boolean canMerge(AbstractMorph morph) {
        if (morph instanceof LightMorph) {
            LightMorph lightMorph = (LightMorph)morph;
            this.mergeBasic(morph);
            if (this.dummy != null) {
                this.dummy.setLifetime(this.dummy.getAge() + 1);
            }
            if (!lightMorph.animation.ignored) {
                if (this.animation.isInProgress()) {
                    LightProperties newLast = new LightProperties();
                    newLast.from(this);
                    this.animation.apply(newLast, 0.0f);
                    this.animation.last = newLast;
                } else {
                    this.animation.last = new LightProperties();
                    this.animation.last.from(this);
                }
                this.animation.merge(this, lightMorph);
                this.light = lightMorph.light;
                this.animation.progress = 0;
            } else {
                this.animation.ignored = true;
            }
            return true;
        }
        return super.canMerge(morph);
    }

    public boolean equals(Object object) {
        boolean result = super.equals(object);
        if (object instanceof LightMorph) {
            LightMorph morph = (LightMorph)((Object)object);
            result = result && Objects.equals(this.light, morph.light);
            result = result && Objects.equals((Object)morph.animation, (Object)this.animation);
            return result;
        }
        return result;
    }

    public void reset() {
        super.reset();
        this.animation.reset();
    }

    public float getWidth(EntityLivingBase entityLivingBase) {
        return 0.0f;
    }

    public float getHeight(EntityLivingBase entityLivingBase) {
        return 0.0f;
    }

    public void fromNBT(NBTTagCompound tag) {
        super.fromNBT(tag);
        if (tag.func_74764_b("LightValue")) {
            this.light = tag.func_74762_e("LightValue");
        }
        if (tag.func_74764_b("Animation")) {
            this.animation.fromNBT(tag.func_74775_l("Animation"));
        }
    }

    public void toNBT(NBTTagCompound tag) {
        NBTTagCompound animation;
        super.toNBT(tag);
        if (this.light != 15) {
            tag.func_74768_a("LightValue", this.light);
        }
        if (!(animation = this.animation.toNBT()).func_82582_d()) {
            tag.func_74782_a("Animation", (NBTBase)animation);
        }
        tag.func_74778_a("UUID", UUID.randomUUID().toString());
    }

    private static enum State {
        CANUPDATE,
        NOUPDATE;

    }

    public static class LightProperties {
        private int lightValue;

        public LightProperties() {
        }

        public LightProperties(int lightValue) {
            this.lightValue = lightValue;
        }

        public void from(LightMorph morph) {
            this.lightValue = morph.light;
        }
    }

    public static class LightAnimation
    extends Animation {
        public LightProperties last;

        public void merge(LightMorph last, LightMorph next) {
            this.merge(next.animation);
            if (this.last == null) {
                this.last = new LightProperties();
                this.last.from(last);
            }
        }

        public void apply(LightProperties properties, float partialTicks) {
            if (this.last == null) {
                return;
            }
            float factor = this.getFactor(partialTicks);
            properties.lightValue = MathUtils.clamp((int)Math.round(this.interp.interpolate((float)this.last.lightValue, (float)properties.lightValue, factor)), (int)0, (int)15);
        }
    }
}

