/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.trackers;

import javax.vecmath.Matrix4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import mchorse.blockbuster_pack.trackers.BaseTracker;
import mchorse.mclib.utils.MatrixUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.Optional;
import org.lwjgl.opengl.GL11;

public class ApertureCamera
extends BaseTracker {
    private static final Matrix4f BUFFER = new Matrix4f();
    public static boolean enable = false;
    public static String tracking = "";
    public static final Vector3f pos = new Vector3f();
    public static final Vector3f rot = new Vector3f();
    public static final Vector3f offsetPos = new Vector3f();
    public static final Vector3f offsetRot = new Vector3f();

    @Override
    @Optional.Method(modid="aperture")
    public void track(EntityLivingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (enable && tracking != null && !tracking.isEmpty() && tracking.equals(this.name)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)ApertureCamera.offsetPos.x, (double)ApertureCamera.offsetPos.y, (double)ApertureCamera.offsetPos.z);
            GL11.glRotatef((float)(-ApertureCamera.offsetRot.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)ApertureCamera.offsetRot.x, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)ApertureCamera.offsetRot.z, (float)0.0f, (float)0.0f, (float)1.0f);
            MatrixUtils.readModelView((Matrix4f)BUFFER);
            GL11.glPopMatrix();
            enable = false;
            MatrixUtils.Transformation transform = MatrixUtils.extractTransformations(null, (Matrix4f)BUFFER);
            pos.set((Tuple3f)transform.getTranslation3f());
            try {
                transform.rotation.invert();
            }
            catch (SingularMatrixException e) {
                return;
            }
            Vector3f rotation = transform.getRotation(MatrixUtils.RotationOrder.YXZ, 1);
            if (rotation != null) {
                rot.set((Tuple3f)rotation);
                if (transform.getScale((int)1).y < 0.0f) {
                    ApertureCamera.rot.z += 180.0f;
                } else {
                    ApertureCamera.rot.x *= -1.0f;
                    ApertureCamera.rot.z *= -1.0f;
                }
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ApertureCamera && super.equals(obj);
    }
}

