/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet;

import java.util.Calendar;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.crafting.CraftingManager;
import mchorse.mappet.api.dialogues.DialogueManager;
import mchorse.mappet.api.events.EventManager;
import mchorse.mappet.api.factions.FactionManager;
import mchorse.mappet.api.huds.HUDManager;
import mchorse.mappet.api.npcs.NpcManager;
import mchorse.mappet.api.quests.QuestManager;
import mchorse.mappet.api.quests.chains.QuestChainManager;
import mchorse.mappet.api.schematics.SchematicManager;
import mchorse.mappet.api.scripts.ScriptManager;
import mchorse.mappet.blocks.BlockConditionModel;
import mchorse.mappet.blocks.BlockEmitter;
import mchorse.mappet.blocks.BlockRegion;
import mchorse.mappet.blocks.BlockTrigger;
import mchorse.mappet.client.KeyboardHandler;
import mchorse.mappet.client.RenderingHandler;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.items.ItemNpcTool;
import mchorse.mappet.tile.TileConditionModel;
import mchorse.mappet.tile.TileEmitter;
import mchorse.mappet.tile.TileRegion;
import mchorse.mappet.tile.TileTrigger;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegisterHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal()) {
            Mappet.quests = new QuestManager(null);
            Mappet.schematics = new SchematicManager(null);
            Mappet.crafting = new CraftingManager(null);
            Mappet.events = new EventManager(null);
            Mappet.dialogues = new DialogueManager(null);
            Mappet.npcs = new NpcManager(null);
            Mappet.factions = new FactionManager(null);
            Mappet.chains = new QuestChainManager(null);
            Mappet.scripts = new ScriptManager(null);
            Mappet.huds = new HUDManager(null);
        }
        KeyboardHandler.clientPlayerJournal = true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Mappet.quests = null;
        Mappet.crafting = null;
        Mappet.events = null;
        Mappet.dialogues = null;
        Mappet.npcs = null;
        Mappet.factions = null;
        Mappet.chains = null;
        Mappet.scripts = null;
        Mappet.huds = null;
        KeyboardHandler.hotkeys.clear();
        RenderingHandler.reset();
    }

    @SubscribeEvent
    public void onBlocksRegister(RegistryEvent.Register<Block> event) {
        Mappet.emitterBlock = new BlockEmitter();
        event.getRegistry().register((IForgeRegistryEntry)Mappet.emitterBlock);
        Mappet.triggerBlock = new BlockTrigger();
        event.getRegistry().register((IForgeRegistryEntry)Mappet.triggerBlock);
        Mappet.regionBlock = new BlockRegion();
        event.getRegistry().register((IForgeRegistryEntry)Mappet.regionBlock);
        Mappet.conditionModelBlock = new BlockConditionModel();
        event.getRegistry().register((IForgeRegistryEntry)Mappet.conditionModelBlock);
    }

    @SubscribeEvent
    public void onItemsRegister(RegistryEvent.Register<Item> event) {
        Mappet.npcTool = ((Item)new ItemNpcTool().setRegistryName(new ResourceLocation("mappet", "npc_tool"))).func_77655_b("mappet.npc_tool");
        event.getRegistry().register((IForgeRegistryEntry)Mappet.npcTool);
        event.getRegistry().register((IForgeRegistryEntry)((Item)new ItemBlock((Block)Mappet.emitterBlock).setRegistryName(new ResourceLocation("mappet", "emitter"))).func_77655_b("mappet.emitter"));
        event.getRegistry().register((IForgeRegistryEntry)((Item)new ItemBlock((Block)Mappet.triggerBlock).setRegistryName(new ResourceLocation("mappet", "trigger"))).func_77655_b("mappet.trigger"));
        event.getRegistry().register((IForgeRegistryEntry)((Item)new ItemBlock((Block)Mappet.regionBlock).setRegistryName(new ResourceLocation("mappet", "region"))).func_77655_b("mappet.region"));
        event.getRegistry().register((IForgeRegistryEntry)((Item)new ItemBlock((Block)Mappet.conditionModelBlock).setRegistryName(new ResourceLocation("mappet", "condition_model"))).func_77655_b("mappet.condition_model"));
    }

    @SubscribeEvent
    public void onEntityRegister(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntityNpc.class).name("mappet.npc").id(new ResourceLocation("mappet", "npc"), 0).tracker(160, 3, false).build());
        GameRegistry.registerTileEntity(TileEmitter.class, (String)"mappet:emitter");
        GameRegistry.registerTileEntity(TileTrigger.class, (String)"mappet:trigger");
        GameRegistry.registerTileEntity(TileRegion.class, (String)"mappet:region");
        GameRegistry.registerTileEntity(TileConditionModel.class, (String)"mappet:condition_model");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Mappet.npcTool, (int)0, (ModelResourceLocation)this.getNpcToolTexture());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Mappet.emitterBlock), (int)0, (ModelResourceLocation)new ModelResourceLocation("mappet:emitter", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Mappet.triggerBlock), (int)0, (ModelResourceLocation)new ModelResourceLocation("mappet:trigger", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Mappet.regionBlock), (int)0, (ModelResourceLocation)new ModelResourceLocation("mappet:region", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Mappet.conditionModelBlock), (int)0, (ModelResourceLocation)new ModelResourceLocation("mappet:condition_model", "inventory"));
    }

    public ModelResourceLocation getNpcToolTexture() {
        String postfix = "";
        Calendar calendar = Calendar.getInstance();
        if (this.isWinter(calendar)) {
            postfix = "_winter";
        }
        if (this.isChristmas(calendar)) {
            postfix = "_christmas";
        } else if (this.isEaster(calendar)) {
            postfix = "_easter";
        } else if (this.isAprilFoolsDay(calendar)) {
            postfix = "_april";
        } else if (this.isHalloween(calendar)) {
            postfix = "_halloween";
        }
        return new ModelResourceLocation("mappet:npc_tool" + postfix, "inventory");
    }

    public boolean isChristmas(Calendar calendar) {
        return calendar.get(2) == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    public boolean isAprilFoolsDay(Calendar calendar) {
        return calendar.get(2) == 3 && calendar.get(5) <= 2;
    }

    public boolean isWinter(Calendar calendar) {
        int month = calendar.get(2);
        return month == 11 || month == 0 || month == 1;
    }

    public boolean isEaster(Calendar calendar) {
        Calendar easterDate = this.getEasterDate(calendar.get(1));
        return calendar.get(2) == easterDate.get(2) && calendar.get(5) == easterDate.get(5);
    }

    public boolean isHalloween(Calendar calendar) {
        return calendar.get(2) == 9 && calendar.get(5) >= 24;
    }

    public Calendar getEasterDate(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int month = (h + l + 114) / 31;
        int day = (h + l + 114) % 31;
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day + 1);
        return calendar;
    }
}

