/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.conditions;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.conditions.Condition;
import mchorse.mappet.api.expressions.ExpressionManager;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.utils.EnumUtils;
import mchorse.mclib.math.IValue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.INBTSerializable;

public class Checker
implements INBTSerializable<NBTBase> {
    public String expression = "";
    public Condition condition;
    public Mode mode = Mode.CONDITION;
    private IValue value;
    private boolean defaultValue;

    public Checker() {
        this(false);
    }

    public Checker(boolean defaultValue) {
        this.defaultValue = defaultValue;
        this.condition = new Condition(defaultValue);
    }

    public boolean check(DataContext data) {
        if (this.isEmpty()) {
            return this.defaultValue;
        }
        if (this.mode == Mode.CONDITION) {
            return this.condition.execute(data);
        }
        if (this.value == null) {
            this.value = Mappet.expressions.parse(this.expression, this.defaultValue ? ExpressionManager.ONE : ExpressionManager.ZERO);
        }
        Mappet.expressions.set(data);
        return this.value.booleanValue();
    }

    public boolean isEmpty() {
        if (this.mode == Mode.CONDITION) {
            return this.condition.blocks.isEmpty();
        }
        return this.expression.isEmpty();
    }

    public NBTTagCompound toNBT() {
        return (NBTTagCompound)this.serializeNBT();
    }

    public NBTBase serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Mode", this.mode.ordinal());
        if (!this.expression.isEmpty()) {
            tag.func_74778_a("Expression", this.expression);
        }
        tag.func_74782_a("Condition", (NBTBase)this.condition.serializeNBT());
        return tag;
    }

    public void deserializeNBT(NBTBase base) {
        if (base instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)base;
            this.value = null;
            if (tag.func_150297_b("Mode", 99)) {
                this.mode = EnumUtils.getValue(tag.func_74762_e("Mode"), Mode.values(), Mode.CONDITION);
            }
            if (tag.func_74764_b("Expression")) {
                this.expression = tag.func_74779_i("Expression");
            }
            if (tag.func_74764_b("Condition")) {
                this.condition.deserializeNBT(tag.func_74775_l("Condition"));
            }
        } else if (base instanceof NBTTagString) {
            this.expression = ((NBTTagString)base).func_150285_a_();
            this.mode = Mode.EXPRESSION;
        }
    }

    public String toString() {
        return "Checker[mode:" + (Object)((Object)this.mode) + ",condition:" + this.condition.toString() + "]";
    }

    public static enum Mode {
        EXPRESSION,
        CONDITION;

    }
}

