/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.conditions.blocks;

import mchorse.mappet.api.conditions.blocks.TargetConditionBlock;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.Morphing;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MorphConditionBlock
extends TargetConditionBlock {
    public NBTTagCompound morph;
    public boolean onlyName;
    private AbstractMorph compiledMorph;

    @Override
    protected TargetMode getDefaultTarget() {
        return TargetMode.PLAYER;
    }

    @Override
    protected boolean evaluateBlock(DataContext context) {
        Entity entity = this.target.getEntity(context);
        AbstractMorph morph = this.getMorph(entity);
        if (morph == null && this.morph == null) {
            return true;
        }
        if (morph == null || this.morph == null) {
            return false;
        }
        if (this.onlyName) {
            return morph.name.equals(this.morph.func_74779_i("Name"));
        }
        if (this.compiledMorph == null) {
            this.compiledMorph = MorphManager.INSTANCE.morphFromNBT(this.morph);
        }
        return morph.equals((Object)this.compiledMorph);
    }

    private AbstractMorph getMorph(Entity entity) {
        AbstractMorph morph = null;
        if (entity instanceof IMorphProvider) {
            morph = ((IMorphProvider)entity).getMorph();
        } else if (entity instanceof EntityPlayer) {
            morph = Morphing.get((EntityPlayer)((EntityPlayer)entity)).getCurrentMorph();
        }
        return morph;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringify() {
        if (this.morph == null) {
            return I18n.func_135052_a((String)"mappet.gui.conditions.morph.no_morph", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"mappet.gui.conditions.morph.string", (Object[])new Object[]{this.morph.func_74779_i("Name")});
    }

    @Override
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        if (this.morph != null) {
            tag.func_74782_a("Morph", (NBTBase)this.morph);
        }
        tag.func_74757_a("OnlyName", this.onlyName);
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.morph = null;
        this.compiledMorph = null;
        if (tag.func_150297_b("Morph", 10)) {
            this.morph = tag.func_74775_l("Morph");
        }
        this.onlyName = tag.func_74767_n("OnlyName");
    }
}

