/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.expressions;

import java.util.Map;
import mchorse.mappet.api.expressions.functions.State;
import mchorse.mappet.api.expressions.functions.dialogue.DialogueRead;
import mchorse.mappet.api.expressions.functions.entity.EntityFunction;
import mchorse.mappet.api.expressions.functions.entity.PlayerIsAlive;
import mchorse.mappet.api.expressions.functions.factions.FactionFriendly;
import mchorse.mappet.api.expressions.functions.factions.FactionHas;
import mchorse.mappet.api.expressions.functions.factions.FactionHostile;
import mchorse.mappet.api.expressions.functions.factions.FactionNeutral;
import mchorse.mappet.api.expressions.functions.factions.FactionScore;
import mchorse.mappet.api.expressions.functions.inventory.InventoryArmor;
import mchorse.mappet.api.expressions.functions.inventory.InventoryHas;
import mchorse.mappet.api.expressions.functions.inventory.InventoryHolds;
import mchorse.mappet.api.expressions.functions.quests.QuestCompleted;
import mchorse.mappet.api.expressions.functions.quests.QuestPresent;
import mchorse.mappet.api.expressions.functions.quests.QuestPresentCompleted;
import mchorse.mappet.api.expressions.functions.world.WorldIsDay;
import mchorse.mappet.api.expressions.functions.world.WorldIsNight;
import mchorse.mappet.api.expressions.functions.world.WorldTime;
import mchorse.mappet.api.expressions.functions.world.WorldTotalTime;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mclib.math.Constant;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.MathBuilder;
import mchorse.mclib.math.Variable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class ExpressionManager {
    public static IValue ONE = new Constant(1.0);
    public static IValue ZERO = new Constant(0.0);
    public MathBuilder builder = new MathBuilder().lenient();
    public DataContext context;

    public ExpressionManager() {
        this.builder.functions.put("quest_present", QuestPresent.class);
        this.builder.functions.put("quest_completed", QuestCompleted.class);
        this.builder.functions.put("quest_present_or_completed", QuestPresentCompleted.class);
        this.builder.functions.put("faction_friendly", FactionFriendly.class);
        this.builder.functions.put("faction_neutral", FactionNeutral.class);
        this.builder.functions.put("faction_hostile", FactionHostile.class);
        this.builder.functions.put("faction_has", FactionHas.class);
        this.builder.functions.put("faction_score", FactionScore.class);
        this.builder.functions.put("state", State.class);
        this.builder.functions.put("inv_has", InventoryHas.class);
        this.builder.functions.put("inv_holds", InventoryHolds.class);
        this.builder.functions.put("inv_armor", InventoryArmor.class);
        this.builder.functions.put("entity", EntityFunction.class);
        this.builder.functions.put("player_is_alive", PlayerIsAlive.class);
        this.builder.functions.put("dialogue_read", DialogueRead.class);
        this.builder.functions.put("world_time", WorldTime.class);
        this.builder.functions.put("world_total_time", WorldTotalTime.class);
        this.builder.functions.put("world_is_day", WorldIsDay.class);
        this.builder.functions.put("world_is_night", WorldIsNight.class);
    }

    private void reset() {
        for (Map.Entry entry : this.builder.variables.entrySet()) {
            String key = (String)entry.getKey();
            Variable variable = (Variable)entry.getValue();
            if (key.equals("PI") || key.equals("E")) continue;
            if (variable.isNumber()) {
                variable.set(0.0);
                continue;
            }
            variable.set("");
        }
        this.context = null;
    }

    public ExpressionManager set(World world) {
        return this.set(new DataContext(world));
    }

    public ExpressionManager set(EntityLivingBase subject) {
        return this.set(new DataContext((Entity)subject));
    }

    public ExpressionManager set(DataContext context) {
        this.reset();
        this.context = context;
        for (Map.Entry<String, Object> entry : context.getValues().entrySet()) {
            String key = entry.getKey();
            Variable variable = (Variable)this.builder.variables.get(key);
            if (variable == null) {
                variable = new Variable(key, 0.0);
                this.builder.register(variable);
            }
            if (entry.getValue() instanceof Number) {
                variable.set(((Number)entry.getValue()).doubleValue());
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            variable.set((String)entry.getValue());
        }
        return this;
    }

    public IValue parse(String expression) {
        return this.parse(expression, ZERO);
    }

    public IValue parse(String expression, IValue defaultValue) {
        try {
            return this.builder.parse(expression);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public World getWorld() {
        return this.context.world;
    }

    public MinecraftServer getServer() {
        return this.context.getSender().func_184102_h();
    }
}

