/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.factions;

import java.util.HashMap;
import java.util.Map;
import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.api.factions.FactionAttitude;
import mchorse.mappet.api.factions.FactionRelation;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Faction
extends AbstractData {
    public String title = "";
    public Checker visible = new Checker(true);
    public int color = 0xFFFFFF;
    public int score = 500;
    public FactionAttitude playerAttitude = FactionAttitude.PASSIVE;
    public FactionAttitude othersAttitude = FactionAttitude.PASSIVE;
    public FactionRelation ownRelation = new FactionRelation();
    public Map<String, FactionAttitude> relations = new HashMap<String, FactionAttitude>();

    public FactionAttitude get(States states) {
        if (states.hasFaction(this.getId())) {
            return this.ownRelation.getAttitude(states.getFactionScore(this.getId()));
        }
        for (String key : this.relations.keySet()) {
            if (!states.hasFaction(key)) continue;
            return this.relations.get(key);
        }
        return this.playerAttitude;
    }

    public FactionAttitude get(String faction) {
        if (faction.equals(this.getId())) {
            return FactionAttitude.FRIENDLY;
        }
        FactionAttitude attitude = this.relations.get(faction);
        return attitude == null ? this.othersAttitude : attitude;
    }

    public boolean isVisible(EntityPlayer player) {
        return this.visible.check(new DataContext((Entity)player));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Title", this.title);
        tag.func_74782_a("Visible", this.visible.serializeNBT());
        tag.func_74768_a("Color", this.color);
        tag.func_74768_a("DefaultScore", this.score);
        tag.func_74778_a("PlayerAttitude", this.playerAttitude.name());
        tag.func_74778_a("OthersAttitude", this.othersAttitude.name());
        tag.func_74782_a("OwnRelation", (NBTBase)this.ownRelation.serializeNBT());
        NBTTagCompound relations = new NBTTagCompound();
        for (Map.Entry<String, FactionAttitude> entry : this.relations.entrySet()) {
            relations.func_74778_a(entry.getKey(), entry.getValue().name());
        }
        if (relations.func_186856_d() > 0) {
            tag.func_74782_a("Relations", (NBTBase)relations);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Title")) {
            this.title = tag.func_74779_i("Title");
        }
        if (tag.func_74764_b("Visible")) {
            this.visible.deserializeNBT(tag.func_74781_a("Visible"));
        }
        if (tag.func_74764_b("Color")) {
            this.color = tag.func_74762_e("Color");
        }
        if (tag.func_74764_b("DefaultScore")) {
            this.score = tag.func_74762_e("DefaultScore");
        }
        if (tag.func_74764_b("PlayerAttitude")) {
            this.playerAttitude = FactionAttitude.get(tag.func_74779_i("PlayerAttitude"));
        }
        if (tag.func_74764_b("OthersAttitude")) {
            this.othersAttitude = FactionAttitude.get(tag.func_74779_i("OthersAttitude"));
        }
        if (tag.func_74764_b("OwnRelation")) {
            this.ownRelation.deserializeNBT(tag.func_74775_l("OwnRelation"));
        }
        if (tag.func_74764_b("Relations")) {
            NBTTagCompound relations = tag.func_74775_l("Relations");
            for (String key : relations.func_150296_c()) {
                this.relations.put(key, FactionAttitude.get(relations.func_74779_i(key)));
            }
        }
    }
}

