/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.factions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mchorse.mappet.api.factions.FactionAttitude;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class FactionRelation
implements INBTSerializable<NBTTagCompound> {
    public List<Threshold> thresholds = new ArrayList<Threshold>();

    public FactionRelation() {
        this.thresholds.add(new Threshold(100, FactionAttitude.AGGRESSIVE, "Hostile", 0xEE2222));
        this.thresholds.add(new Threshold(200, FactionAttitude.PASSIVE, "Neutral", 0xAAAAAA));
        this.thresholds.add(new Threshold(1000, FactionAttitude.FRIENDLY, "Friendly", 0x22EE22));
    }

    public FactionAttitude getAttitude(int score) {
        Threshold threshold = this.get(score);
        return threshold == null ? FactionAttitude.PASSIVE : threshold.attitude;
    }

    public Threshold get(int score) {
        for (Threshold threshold : this.thresholds) {
            if (score >= threshold.score) continue;
            return threshold;
        }
        return this.thresholds.isEmpty() ? null : this.thresholds.get(this.thresholds.size() - 1);
    }

    public void normalize() {
        this.thresholds.sort(Comparator.comparingInt(a -> a.score));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        this.normalize();
        for (Threshold threshold : this.thresholds) {
            list.func_74742_a((NBTBase)threshold.serializeNBT());
        }
        tag.func_74782_a("Thresholds", (NBTBase)list);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.thresholds.clear();
        if (tag.func_74764_b("Thresholds")) {
            NBTTagList list = tag.func_150295_c("Thresholds", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                Threshold threshold = new Threshold();
                threshold.deserializeNBT(compound);
                this.thresholds.add(threshold);
            }
        }
        this.normalize();
    }

    public static class Threshold
    implements INBTSerializable<NBTTagCompound> {
        public int score;
        public FactionAttitude attitude = FactionAttitude.PASSIVE;
        public String title = "";
        public int color = 0xFFFFFF;

        public Threshold() {
        }

        public Threshold(int score, FactionAttitude attitude, String title, int color) {
            this.score = score;
            this.attitude = attitude;
            this.title = title;
            this.color = color;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Score", this.score);
            tag.func_74778_a("Attitude", this.attitude.name());
            tag.func_74778_a("Title", this.title);
            tag.func_74768_a("Color", this.color);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.score = tag.func_74762_e("Score");
            this.attitude = FactionAttitude.get(tag.func_74779_i("Attitude"));
            this.title = tag.func_74779_i("Title");
            this.color = tag.func_74762_e("Color");
        }
    }
}

