/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.npcs;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class NpcLexer {
    public static final List<String> PROPERTIES = ImmutableList.of((Object)"id", (Object)"unique", (Object)"path_distance", (Object)"max_health", (Object)"health", (Object)"regen_delay", (Object)"regen_frequency", (Object)"damage", (Object)"can_ranged", (Object)"can_fall_damage", (Object)"can_get_burned", (Object)"invincible", (Object[])new String[]{"killable", "speed", "can_swim", "immovable", "has_post", "post", "post_radius", "fallback", "patrol_circulate", "patrol", "steering_offset", "follow", "faction", "morph", "sight_distance", "sight_radius", "drops", "xp", "look_at_player", "look_around", "wander", "flee", "can_pick_up_loot", "can_be_steered", "trigger_died", "trigger_damaged", "trigger_interact", "trigger_tick", "trigger_target", "trigger_initialize", "damage_delay", "respawn", "respawn_delay", "respawn_on_coordinates", "respawn_pos_x", "respawn_pos_y", "respawn_pos_z", "respawn_save_uuid"});
    public String id;
    public String state;
    public List<String> properties = new ArrayList<String>();

    public static NpcLexer parse(String input, String npcId) {
        String[] splits;
        String state = input;
        HashSet<String> properties = null;
        if (input.contains("@")) {
            splits = input.split("@");
            npcId = splits[0];
            state = splits[1];
        }
        if (state.contains(":")) {
            splits = state.split(":");
            String[] props = splits[1].split(",");
            state = splits[0];
            properties = new HashSet<String>();
            for (String property : props) {
                if (!PROPERTIES.contains(property)) continue;
                properties.add(property);
            }
        }
        NpcLexer lexer = new NpcLexer(npcId, state);
        if (properties != null) {
            lexer.properties.addAll(properties);
        }
        return lexer;
    }

    public NpcLexer(String id, String state) {
        this.id = id;
        this.state = state;
    }
}

