/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.quests;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.quests.INBTPartialSerializable;
import mchorse.mappet.api.quests.objectives.AbstractObjective;
import mchorse.mappet.api.quests.objectives.KillObjective;
import mchorse.mappet.api.quests.objectives.StateObjective;
import mchorse.mappet.api.quests.rewards.IReward;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mclib.utils.TextUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Quest
extends AbstractData
implements INBTPartialSerializable {
    public String title = "";
    public String story = "";
    public boolean cancelable = true;
    public boolean visible = true;
    public boolean instant;
    public Trigger accept = new Trigger();
    public Trigger decline = new Trigger();
    public Trigger complete = new Trigger();
    public final List<AbstractObjective> objectives = new ArrayList<AbstractObjective>();
    public final List<IReward> rewards = new ArrayList<IReward>();
    private boolean initated;

    public void initiate(EntityPlayer player) {
        if (this.initated) {
            return;
        }
        for (AbstractObjective objective : this.objectives) {
            objective.initiate(player);
        }
        this.initated = true;
    }

    public String getProcessedTitle() {
        return TextUtils.processColoredText((String)this.title);
    }

    public Quest setStory(String title, String story) {
        this.title = title;
        this.story = story;
        return this;
    }

    public Quest addObjective(AbstractObjective objective) {
        this.objectives.add(objective);
        return this;
    }

    public Quest addReward(IReward reward) {
        this.rewards.add(reward);
        return this;
    }

    public void mobWasKilled(EntityPlayer player, Entity entity) {
        for (AbstractObjective objective : this.objectives) {
            if (!(objective instanceof KillObjective)) continue;
            ((KillObjective)objective).playerKilled(player, entity);
        }
    }

    public boolean stateWasUpdated(EntityPlayer player) {
        int i = 0;
        for (AbstractObjective objective : this.objectives) {
            if (!(objective instanceof StateObjective)) continue;
            i += ((StateObjective)objective).updateValue(player) ? 1 : 0;
        }
        return i > 0;
    }

    public boolean isComplete(EntityPlayer player) {
        boolean result = true;
        for (AbstractObjective objective : this.objectives) {
            result = result && objective.isComplete(player);
        }
        return result;
    }

    public void reward(EntityPlayer player) {
        for (AbstractObjective objective : this.objectives) {
            objective.complete(player);
        }
        for (IReward reward : this.rewards) {
            reward.reward(player);
        }
        this.complete.trigger((EntityLivingBase)player);
        Character character = Character.get(player);
        if (character != null) {
            character.getStates().completeQuest(this.getId());
        }
        Mappet.states.completeQuest(this.getId());
    }

    public boolean rewardIfComplete(EntityPlayer player) {
        if (!this.isComplete(player)) {
            return false;
        }
        this.reward(player);
        return true;
    }

    @Override
    public NBTTagCompound partialSerializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList objectives = new NBTTagList();
        tag.func_74782_a("Objectives", (NBTBase)objectives);
        for (AbstractObjective objective : this.objectives) {
            objectives.func_74742_a((NBTBase)objective.partialSerializeNBT());
        }
        tag.func_74757_a("Visible", this.visible);
        return tag;
    }

    @Override
    public void partialDeserializeNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("Objectives", 9)) {
            NBTTagList list = tag.func_150295_c("Objectives", 10);
            for (int i = 0; i < Math.min(list.func_74745_c(), this.objectives.size()); ++i) {
                this.objectives.get(i).partialDeserializeNBT(list.func_150305_b(i));
            }
        }
        if (tag.func_74764_b("Visible")) {
            this.visible = tag.func_74767_n("Visible");
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound item;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList objectives = new NBTTagList();
        NBTTagList rewards = new NBTTagList();
        tag.func_74778_a("Title", this.title);
        tag.func_74778_a("Story", this.story);
        tag.func_74757_a("Cancelable", this.cancelable);
        tag.func_74757_a("Instant", this.instant);
        tag.func_74757_a("Visible", this.visible);
        NBTTagCompound accept = this.accept.serializeNBT();
        NBTTagCompound decline = this.decline.serializeNBT();
        NBTTagCompound complete = this.complete.serializeNBT();
        if (accept.func_186856_d() > 0) {
            tag.func_74782_a("Accept", (NBTBase)accept);
        }
        if (decline.func_186856_d() > 0) {
            tag.func_74782_a("Decline", (NBTBase)decline);
        }
        if (complete.func_186856_d() > 0) {
            tag.func_74782_a("Complete", (NBTBase)complete);
        }
        tag.func_74782_a("Objectives", (NBTBase)objectives);
        tag.func_74782_a("Rewards", (NBTBase)rewards);
        for (AbstractObjective objective : this.objectives) {
            item = objective.serializeNBT();
            item.func_74778_a("Type", objective.getType());
            objectives.func_74742_a((NBTBase)item);
        }
        for (IReward reward : this.rewards) {
            item = (NBTTagCompound)reward.serializeNBT();
            item.func_74778_a("Type", reward.getType());
            rewards.func_74742_a((NBTBase)item);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        NBTTagCompound tagCompound;
        int i;
        NBTTagList list;
        this.title = tag.func_74779_i("Title");
        this.story = tag.func_74779_i("Story");
        if (tag.func_74764_b("Cancelable")) {
            this.cancelable = tag.func_74767_n("Cancelable");
        }
        if (tag.func_74764_b("Instant")) {
            this.instant = tag.func_74767_n("Instant");
        }
        if (tag.func_74764_b("Accept")) {
            this.accept.deserializeNBT(tag.func_74775_l("Accept"));
        }
        if (tag.func_74764_b("Decline")) {
            this.decline.deserializeNBT(tag.func_74775_l("Decline"));
        }
        if (tag.func_74764_b("Complete")) {
            this.complete.deserializeNBT(tag.func_74775_l("Complete"));
        }
        if (tag.func_74764_b("Visible")) {
            this.visible = tag.func_74767_n("Visible");
        }
        if (tag.func_74764_b("Objectives")) {
            list = tag.func_150295_c("Objectives", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                tagCompound = list.func_150305_b(i);
                AbstractObjective objective = AbstractObjective.fromType(tagCompound.func_74779_i("Type"));
                if (objective == null) continue;
                objective.deserializeNBT(tagCompound);
                this.objectives.add(objective);
            }
        }
        if (tag.func_74764_b("Rewards")) {
            list = tag.func_150295_c("Rewards", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                tagCompound = list.func_150305_b(i);
                IReward reward = IReward.fromType(tagCompound.func_74779_i("Type"));
                if (reward == null) continue;
                reward.deserializeNBT((NBTBase)tagCompound);
                this.rewards.add(reward);
            }
        }
    }
}

