/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.regions.shapes;

import mchorse.mappet.api.regions.shapes.AbstractShape;
import mchorse.mappet.api.regions.shapes.BoxShape;
import net.minecraft.nbt.NBTTagCompound;

public class SphereShape
extends AbstractShape {
    public double horizontal = 1.0;
    public double vertical = 1.0;

    public SphereShape() {
    }

    public SphereShape(double horizontal, double vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    @Override
    public void copyFrom(AbstractShape shape) {
        super.copyFrom(shape);
        if (shape instanceof BoxShape) {
            this.horizontal = ((BoxShape)shape).size.x;
            this.vertical = ((BoxShape)shape).size.y;
        } else if (shape instanceof SphereShape) {
            this.horizontal = ((SphereShape)shape).horizontal;
            this.vertical = ((SphereShape)shape).vertical;
        }
    }

    @Override
    public boolean isInside(double x, double y, double z) {
        double dx = x - this.pos.x;
        double rx = dx / this.horizontal;
        double dy = y - this.pos.y;
        double ry = dy / this.vertical;
        double dz = z - this.pos.z;
        double rz = dz / this.horizontal;
        return rx * rx + ry * ry + rz * rz <= 1.0;
    }

    @Override
    public String getType() {
        return "sphere";
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74780_a("Horizontal", this.horizontal);
        tag.func_74780_a("Vertical", this.vertical);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Horizontal")) {
            this.horizontal = tag.func_74769_h("Horizontal");
        }
        if (tag.func_74764_b("Vertical")) {
            this.vertical = tag.func_74769_h("Vertical");
        }
    }
}

