/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.scripts.ScriptManager;
import mchorse.mappet.api.scripts.ScriptRange;
import mchorse.mappet.api.scripts.code.ScriptEvent;
import mchorse.mappet.api.scripts.code.ScriptFactory;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.events.RegisterScriptVariablesEvent;
import mchorse.mappet.utils.ScriptUtils;
import mchorse.mappet.utils.Utils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Script
extends AbstractData {
    public String code = "";
    public boolean unique = true;
    public boolean globalLibrary = false;
    public List<String> libraries = new ArrayList<String>();
    private ScriptEngine engine;
    private List<ScriptRange> ranges;
    private String DEFAULT_KOTLIN_IMPORTS = "import mchorse.metamorph.api.morphs.AbstractMorph\nimport mchorse.mappet.entities.EntityNpc\nimport net.minecraft.potion.Potion\nimport net.minecraft.entity.Entity\nimport net.minecraft.inventory.IInventory\nimport net.minecraft.entity.player.EntityPlayerMP\nimport net.minecraft.item.Item\nimport net.minecraft.item.ItemStack\nimport net.minecraft.tileentity.TileEntity\nimport net.minecraft.block.state.IBlockState\nimport net.minecraft.util.EnumParticleTypes\nimport javax.vecmath.*\nimport java.lang.Math.*\nimport mchorse.mappet.api.scripts.user.*\nimport mchorse.mappet.api.scripts.user.blocks.*\nimport mchorse.mappet.api.scripts.user.data.*\nimport mchorse.mappet.api.scripts.user.entities.*\nimport mchorse.mappet.api.scripts.user.items.*\nimport mchorse.mappet.api.scripts.user.mappet.*\nimport mchorse.mappet.api.scripts.user.nbt.*\nimport mchorse.mappet.api.scripts.code.*\nimport mchorse.mappet.api.scripts.code.blocks.*\nimport mchorse.mappet.api.scripts.code.entities.*\nimport mchorse.mappet.api.scripts.code.items.*\nimport mchorse.mappet.api.scripts.code.mappet.*\nimport mchorse.mappet.api.scripts.code.nbt.*\n";

    public void start(ScriptManager manager) throws ScriptException {
        if (this.engine == null) {
            this.initializeEngine();
            this.configureEngineContext();
            this.registerScriptVariables();
            HashSet<String> uniqueImports = new HashSet<String>();
            StringBuilder finalCode = new StringBuilder();
            HashSet<String> alreadyLoaded = new HashSet<String>();
            int total = 0;
            boolean isKotlin = this.isKotlinEngine();
            ArrayList<String> allLibraries = new ArrayList<String>();
            allLibraries.addAll(manager.globalLibraries.keySet());
            allLibraries.addAll(this.libraries);
            for (String library : allLibraries) {
                if (this.shouldSkipLibrary(library, alreadyLoaded)) continue;
                total = this.processLibrary(manager, library, isKotlin, uniqueImports, finalCode, total);
                alreadyLoaded.add(library);
            }
            this.processScriptCode(isKotlin, uniqueImports, finalCode);
            if (this.ranges != null) {
                this.ranges.add(new ScriptRange(total, this.getId()));
            }
            this.engine.put("mappet", new ScriptFactory());
            this.evalEngineCode(isKotlin, uniqueImports, finalCode);
        }
    }

    private void initializeEngine() throws ScriptException {
        String extension = this.getScriptExtension();
        if (extension.equals("kts")) {
            System.setProperty("kotlin.jsr223.experimental.resolve.dependencies.from.context.classloader", "true");
        }
        this.engine = ScriptUtils.getEngineByExtension(extension);
        if (this.engine == null) {
            String message = "Looks like Mappet can't find script engine for a \"" + this.getScriptExtension() + "\" file extension.";
            throw new ScriptException(message, this.getId(), -1);
        }
        this.engine = ScriptUtils.sanitize(this.engine);
    }

    private void configureEngineContext() {
        String extension = this.getScriptExtension();
        if (extension.equals("js")) {
            NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
            this.engine = factory.getScriptEngine(new String[]{"--language=es6", "-scripting"});
        }
        this.engine.getContext().setAttribute("javax.script.filename", this.getId(), 100);
        this.engine.getContext().setAttribute("polyglot.js.allowHostAccess", true, 100);
    }

    private void registerScriptVariables() {
        Mappet.EVENT_BUS.post((Event)new RegisterScriptVariablesEvent(this.engine));
    }

    private boolean isKotlinEngine() {
        return this.engine.getFactory().getLanguageName().equals("kotlin");
    }

    private boolean shouldSkipLibrary(String library, Set<String> alreadyLoaded) {
        return library.equals(this.getId()) || alreadyLoaded.contains(library);
    }

    private int processLibrary(ScriptManager manager, String library, boolean isKotlin, Set<String> uniqueImports, StringBuilder finalCode, int total) {
        try {
            File scriptFile = manager.getScriptFile(library);
            String code = FileUtils.readFileToString((File)scriptFile, (Charset)Utils.getCharset());
            if (isKotlin) {
                code = this.processKotlinCode(code, uniqueImports);
            }
            finalCode.append(code);
            finalCode.append("\n");
            if (this.ranges == null) {
                this.ranges = new ArrayList<ScriptRange>();
            }
            this.ranges.add(new ScriptRange(total, library));
            total += StringUtils.countMatches((CharSequence)code, (CharSequence)"\n") + 1;
        }
        catch (Exception e) {
            System.err.println("[Mappet] Script library " + library + ".js failed to load...");
            e.printStackTrace();
        }
        return total;
    }

    private String processKotlinCode(String code, Set<String> uniqueImports) {
        String[] lines = code.split("\n");
        StringBuilder currentCode = new StringBuilder();
        for (String line : lines) {
            if (line.trim().startsWith("import")) {
                uniqueImports.add(line.trim());
                continue;
            }
            currentCode.append(line);
            currentCode.append("\n");
        }
        return currentCode.toString();
    }

    private void processScriptCode(boolean isKotlin, Set<String> uniqueImports, StringBuilder finalCode) {
        if (isKotlin) {
            String processedCode = this.processKotlinCode(this.code, uniqueImports);
            finalCode.insert(0, processedCode);
        } else {
            finalCode.append(this.code);
        }
    }

    private void evalEngineCode(boolean isKotlin, Set<String> uniqueImports, StringBuilder finalCode) throws ScriptException {
        if (isKotlin) {
            String allCode = this.DEFAULT_KOTLIN_IMPORTS + "\n" + String.join((CharSequence)"\n", uniqueImports) + "\n" + finalCode.toString();
            this.engine.eval(allCode);
        } else {
            this.engine.eval(finalCode.toString());
        }
    }

    public String getScriptExtension() {
        String id = this.getId();
        int index = id.lastIndexOf(46);
        return index >= 0 ? id.substring(index + 1) : "js";
    }

    public Object execute(String function, DataContext context, Object ... args) throws ScriptException, NoSuchMethodException {
        if (function.isEmpty()) {
            function = "main";
        }
        this.engine.put("context", context);
        try {
            return ((Invocable)((Object)this.engine)).invokeFunction(function, args);
        }
        catch (ScriptException e) {
            ScriptException exception = this.processScriptException(e);
            Mappet.logger.error(e.getMessage());
            throw exception == null ? e : exception;
        }
    }

    public Object execute(String function, DataContext context) throws ScriptException, NoSuchMethodException {
        return this.execute(function, context, new ScriptEvent(context, this.getId(), function));
    }

    private ScriptException processScriptException(ScriptException e) {
        if (this.ranges == null) {
            return null;
        }
        ScriptRange range = null;
        for (int i = this.ranges.size() - 1; i >= 0; --i) {
            ScriptRange possibleRange = this.ranges.get(i);
            if (possibleRange.lineOffset > e.getLineNumber() - 1) continue;
            range = possibleRange;
            break;
        }
        if (range != null) {
            String message = e.getMessage();
            int lineNumber = e.getLineNumber() - range.lineOffset;
            message = message.replaceFirst(this.getId(), range.script + " (in " + this.getId() + ")");
            message = message.replaceFirst("at line number [\\d]+", "at line number " + lineNumber);
            return new ScriptException(message, range.script, lineNumber, e.getColumnNumber());
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList libraries = new NBTTagList();
        for (String library : this.libraries) {
            libraries.func_74742_a((NBTBase)new NBTTagString(library));
        }
        tag.func_74757_a("Unique", this.unique);
        tag.func_74757_a("GlobalLibrary", this.globalLibrary);
        tag.func_74782_a("Libraries", (NBTBase)libraries);
        tag.func_74773_a("Code", this.code.getBytes(StandardCharsets.UTF_8));
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.unique = tag.func_74767_n("Unique");
        if (tag.func_150297_b("Libraries", 9)) {
            NBTTagList libraries = tag.func_150295_c("Libraries", 8);
            this.libraries.clear();
            int c = libraries.func_74745_c();
            for (int i = 0; i < c; ++i) {
                this.libraries.add(libraries.func_150307_f(i));
            }
        }
        if (tag.func_74764_b("GlobalLibrary")) {
            this.globalLibrary = tag.func_74767_n("GlobalLibrary");
        }
        this.code = new String(tag.func_74770_j("Code"), StandardCharsets.UTF_8);
    }
}

