/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.script.ScriptException;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.scripts.code.ScriptWorld;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.entities.ScriptPlayer;
import mchorse.mappet.api.scripts.code.mappet.MappetStates;
import mchorse.mappet.api.scripts.user.IScriptServer;
import mchorse.mappet.api.scripts.user.IScriptWorld;
import mchorse.mappet.api.scripts.user.entities.IScriptEntity;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.mappet.IMappetStates;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class ScriptServer
implements IScriptServer {
    private MinecraftServer server;
    private IMappetStates states;

    public ScriptServer(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public MinecraftServer getMinecraftServer() {
        return this.server;
    }

    @Override
    public IScriptWorld getWorld(int dimension) {
        return new ScriptWorld((World)this.server.func_71218_a(dimension));
    }

    @Override
    public List<IScriptEntity> getEntities(String targetSelector) {
        ArrayList<IScriptEntity> entities = new ArrayList<IScriptEntity>();
        try {
            for (Entity entity : EntitySelector.func_179656_b((ICommandSender)this.server, (String)targetSelector, Entity.class)) {
                entities.add(ScriptEntity.create(entity));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entities;
    }

    @Override
    public IScriptEntity getEntity(String uuid) {
        return ScriptEntity.create(this.server.func_175576_a(UUID.fromString(uuid)));
    }

    @Override
    public List<IScriptPlayer> getAllPlayers() {
        ArrayList<IScriptPlayer> entities = new ArrayList<IScriptPlayer>();
        for (EntityPlayerMP player : this.server.func_184103_al().func_181057_v()) {
            entities.add(new ScriptPlayer(player));
        }
        return entities;
    }

    @Override
    public IScriptPlayer getPlayer(String username) {
        EntityPlayerMP player = this.server.func_184103_al().func_152612_a(username);
        if (player != null) {
            return new ScriptPlayer(player);
        }
        return null;
    }

    @Override
    public IMappetStates getStates() {
        if (this.states == null) {
            this.states = new MappetStates(Mappet.states);
        }
        return this.states;
    }

    @Override
    public boolean entityExists(String uuid) throws IllegalArgumentException {
        try {
            UUID parsedUuid = UUID.fromString(uuid);
            return this.server.func_175576_a(parsedUuid) != null;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid UUID string: " + uuid, ex);
        }
    }

    @Override
    public void executeScript(String scriptName) {
        this.executeScript(scriptName, "main");
    }

    @Override
    public void executeScript(String scriptName, String function) {
        DataContext context = new DataContext(this.server);
        try {
            Mappet.scripts.execute(scriptName, function, context);
        }
        catch (ScriptException e) {
            String fileName = e.getFileName() == null ? scriptName : e.getFileName();
            e.printStackTrace();
            throw new RuntimeException("Script Error: " + fileName + " - Line: " + e.getLineNumber() + " - Column: " + e.getColumnNumber() + " - Message: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Script Empty: " + scriptName + " - Error: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void executeScript(String scriptName, String function, Object ... args) {
        DataContext context = new DataContext(this.server);
        try {
            Mappet.scripts.execute(scriptName, function, context, args);
        }
        catch (ScriptException e) {
            String fileName = e.getFileName() == null ? scriptName : e.getFileName();
            e.printStackTrace();
            throw new RuntimeException("Script Error: " + fileName + " - Line: " + e.getLineNumber() + " - Column: " + e.getColumnNumber() + " - Message: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Script Empty: " + scriptName + " - Error: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }
}

