/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.script.ScriptException;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.blockbuster.network.common.PacketModifyActor;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.scripts.code.ScriptRayTrace;
import mchorse.mappet.api.scripts.code.ScriptWorld;
import mchorse.mappet.api.scripts.code.entities.ScriptEntityItem;
import mchorse.mappet.api.scripts.code.entities.ScriptNpc;
import mchorse.mappet.api.scripts.code.entities.ScriptPlayer;
import mchorse.mappet.api.scripts.code.entities.ai.EntitiesAIPatrol;
import mchorse.mappet.api.scripts.code.entities.ai.EntityAILookAtTarget;
import mchorse.mappet.api.scripts.code.entities.ai.repeatingCommand.EntityAIRepeatingCommand;
import mchorse.mappet.api.scripts.code.entities.ai.repeatingCommand.RepeatingCommandDataStorage;
import mchorse.mappet.api.scripts.code.entities.ai.rotations.EntityAIRotations;
import mchorse.mappet.api.scripts.code.entities.ai.rotations.RotationDataStorage;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.scripts.code.mappet.MappetStates;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.user.IScriptRayTrace;
import mchorse.mappet.api.scripts.user.IScriptWorld;
import mchorse.mappet.api.scripts.user.data.ScriptBox;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.api.scripts.user.entities.IScriptEntity;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.mappet.IMappetStates;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.client.morphs.WorldMorph;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.scripts.PacketEntityRotations;
import mchorse.mappet.network.common.scripts.PacketWorldMorph;
import mchorse.mappet.utils.EntityUtils;
import mchorse.mappet.utils.RunnableExecutionFork;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.RayTracing;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ScriptEntity<T extends Entity>
implements IScriptEntity {
    protected T entity;
    protected IMappetStates states;

    public static IScriptEntity create(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            return new ScriptPlayer((EntityPlayerMP)entity);
        }
        if (entity instanceof EntityNpc) {
            return new ScriptNpc((EntityNpc)entity);
        }
        if (entity instanceof EntityItem) {
            return new ScriptEntityItem((EntityItem)entity);
        }
        if (entity != null) {
            return new ScriptEntity<Entity>(entity);
        }
        return null;
    }

    protected ScriptEntity(T entity) {
        this.entity = entity;
    }

    @Override
    public Entity getMinecraftEntity() {
        return this.entity;
    }

    @Override
    public IScriptWorld getWorld() {
        return new ScriptWorld(((Entity)this.entity).field_70170_p);
    }

    @Override
    public ScriptVector getPosition() {
        return new ScriptVector(((Entity)this.entity).field_70165_t, ((Entity)this.entity).field_70163_u, ((Entity)this.entity).field_70161_v);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
            throw new IllegalArgumentException();
        }
        this.entity.func_70634_a(x, y, z);
        if (this.entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.entity).field_71135_a.func_147364_a(x, y, z, ((Entity)this.entity).field_70177_z, ((Entity)this.entity).field_70125_A);
        }
    }

    @Override
    public int getDimension() {
        return ((Entity)this.entity).field_71093_bK;
    }

    @Override
    public void setDimension(int dimension) {
        if (((Entity)this.entity).field_71093_bK == dimension) {
            return;
        }
        if (dimension < -1 || dimension > 1) {
            throw new IllegalArgumentException("Dimension must be -1 (Nether), 0 (Overworld), or 1 (End).");
        }
        MinecraftServer minecraftServer = this.entity.func_184102_h();
        WorldServer worldServer = minecraftServer.func_71218_a(dimension);
        Teleporter teleporter = new Teleporter(worldServer){

            public void func_180266_a(Entity entityIn, float rotationYaw) {
            }

            public boolean func_180620_b(Entity entityIn, float rotationYaw) {
                return false;
            }
        };
        if (this.entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this.entity;
            minecraftServer.func_184103_al().transferPlayerToDimension(player, dimension, teleporter);
        } else {
            this.entity.changeDimension(dimension, (ITeleporter)teleporter);
        }
    }

    @Override
    public ScriptVector getMotion() {
        return new ScriptVector(((Entity)this.entity).field_70159_w, ((Entity)this.entity).field_70181_x, ((Entity)this.entity).field_70179_y);
    }

    @Override
    public void setMotion(double x, double y, double z) {
        ((Entity)this.entity).field_70159_w = x;
        ((Entity)this.entity).field_70181_x = y;
        ((Entity)this.entity).field_70179_y = z;
    }

    @Override
    public void addMotion(double x, double y, double z) {
        ((Entity)this.entity).field_70133_I = true;
        this.entity.func_70024_g(x, y, z);
    }

    @Override
    public ScriptVector getRotations() {
        return new ScriptVector(this.getPitch(), this.getYaw(), this.getYawHead());
    }

    @Override
    public void setRotations(float pitch, float yaw, float yawHead) {
        if (Float.isNaN(pitch) || Float.isNaN(yaw) || Float.isNaN(yawHead)) {
            throw new IllegalArgumentException();
        }
        this.entity.func_70012_b(((Entity)this.entity).field_70165_t, ((Entity)this.entity).field_70163_u, ((Entity)this.entity).field_70161_v, yaw, pitch);
        this.entity.func_70034_d(yawHead);
        this.entity.func_181013_g(yawHead);
        if (!this.isPlayer()) {
            EntityTracker tracker = ((WorldServer)((Entity)this.entity).field_70170_p).func_73039_n();
            for (EntityPlayer player : tracker.getTrackingPlayers(this.entity)) {
                Dispatcher.sendTo(new PacketEntityRotations(this.entity.func_145782_y(), yaw, yawHead, pitch), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public float getPitch() {
        return ((Entity)this.entity).field_70125_A;
    }

    @Override
    public float getYaw() {
        return ((Entity)this.entity).field_70177_z;
    }

    @Override
    public float getYawHead() {
        return this.entity.func_70079_am();
    }

    @Override
    public ScriptVector getLook() {
        float f1 = -(((Entity)this.entity).field_70125_A * ((float)Math.PI / 180));
        float f2 = this.entity.func_70079_am() * ((float)Math.PI / 180);
        float f3 = -MathHelper.func_76126_a((float)f2);
        float f4 = MathHelper.func_76134_b((float)f2);
        float f6 = MathHelper.func_76134_b((float)f1);
        return new ScriptVector(f3 * f6, this.entity.func_70040_Z().field_72448_b, f4 * f6);
    }

    @Override
    public float getEyeHeight() {
        return EntityUtils.getEyeHeight(this.entity);
    }

    @Override
    public float getWidth() {
        return ((Entity)this.entity).field_70130_N;
    }

    @Override
    public float getHeight() {
        return ((Entity)this.entity).field_70131_O;
    }

    @Override
    public float getHp() {
        if (this.isLivingBase()) {
            return ((EntityLivingBase)this.entity).func_110143_aJ();
        }
        return 0.0f;
    }

    @Override
    public void setHp(float hp) {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_70606_j(hp);
        }
    }

    @Override
    public float getMaxHp() {
        if (this.isLivingBase()) {
            return ((EntityLivingBase)this.entity).func_110138_aP();
        }
        return 0.0f;
    }

    @Override
    public void setMaxHp(float hp) {
        if (this.isLivingBase() && hp > 0.0f) {
            ((EntityLivingBase)this.entity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)hp);
        }
    }

    @Override
    public boolean isInWater() {
        return this.entity.func_70090_H();
    }

    @Override
    public boolean isInLava() {
        return this.entity.func_180799_ab();
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public void setBurning(int seconds) {
        if (seconds <= 0) {
            this.entity.func_70066_B();
        } else {
            this.entity.func_70015_d(seconds);
        }
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public boolean isOnGround() {
        return ((Entity)this.entity).field_70122_E;
    }

    @Override
    public IScriptRayTrace rayTrace(double maxDistance) {
        return new ScriptRayTrace(RayTracing.rayTraceWithEntity(this.entity, (double)maxDistance));
    }

    @Override
    public IScriptRayTrace rayTraceBlock(double maxDistance) {
        return new ScriptRayTrace(RayTracing.rayTrace(this.entity, (double)maxDistance, (float)0.0f));
    }

    @Override
    public IScriptItemStack getMainItem() {
        if (this.isLivingBase()) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184614_ca());
        }
        return ScriptItemStack.EMPTY;
    }

    @Override
    public void setMainItem(IScriptItemStack stack) {
        this.setItem(EnumHand.MAIN_HAND, stack);
    }

    @Override
    public IScriptItemStack getOffItem() {
        if (this.isLivingBase()) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184592_cb());
        }
        return ScriptItemStack.EMPTY;
    }

    @Override
    public void setOffItem(IScriptItemStack stack) {
        this.setItem(EnumHand.OFF_HAND, stack);
    }

    private void setItem(EnumHand hand, IScriptItemStack stack) {
        if (stack == null) {
            stack = ScriptItemStack.EMPTY;
        }
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_184611_a(hand, stack.getMinecraftItemStack().func_77946_l());
        }
    }

    @Override
    public void giveItem(IScriptItemStack stack) {
        this.giveItem(stack, true, true);
    }

    @Override
    public void giveItem(IScriptItemStack stack, boolean playSound, boolean dropIfInventoryFull) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (this.isPlayer()) {
            EntityPlayer player = (EntityPlayer)this.entity;
            ItemStack itemStack = stack.getMinecraftItemStack().func_77946_l();
            boolean flag = player.field_71071_by.func_70441_a(itemStack);
            if (flag) {
                if (playSound) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                player.field_71069_bz.func_75142_b();
            } else if (dropIfInventoryFull && !player.field_70170_p.field_72995_K) {
                EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, itemStack);
                entityItem.func_174868_q();
                player.func_130014_f_().func_72838_d((Entity)entityItem);
            }
        } else if (this.isLivingBase() && this.entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)this.entity;
            if (living.func_184614_ca().func_190926_b()) {
                living.func_184611_a(EnumHand.MAIN_HAND, stack.getMinecraftItemStack().func_77946_l());
            } else if (living.func_184592_cb().func_190926_b()) {
                living.func_184611_a(EnumHand.OFF_HAND, stack.getMinecraftItemStack().func_77946_l());
            } else {
                living.func_70099_a(stack.getMinecraftItemStack().func_77946_l(), this.getEyeHeight());
            }
        }
    }

    @Override
    public IScriptItemStack getHelmet() {
        if (this.entity instanceof EntityLivingBase) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184582_a(EntityEquipmentSlot.HEAD).func_77946_l());
        }
        return null;
    }

    @Override
    public IScriptItemStack getChestplate() {
        if (this.entity instanceof EntityLivingBase) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184582_a(EntityEquipmentSlot.CHEST).func_77946_l());
        }
        return null;
    }

    @Override
    public IScriptItemStack getLeggings() {
        if (this.entity instanceof EntityLivingBase) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184582_a(EntityEquipmentSlot.LEGS).func_77946_l());
        }
        return null;
    }

    @Override
    public IScriptItemStack getBoots() {
        if (this.entity instanceof EntityLivingBase) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184582_a(EntityEquipmentSlot.FEET).func_77946_l());
        }
        return null;
    }

    @Override
    public void setHelmet(IScriptItemStack itemStack) {
        this.entity.func_184201_a(EntityEquipmentSlot.HEAD, itemStack.getMinecraftItemStack());
    }

    @Override
    public void setChestplate(IScriptItemStack itemStack) {
        this.entity.func_184201_a(EntityEquipmentSlot.CHEST, itemStack.getMinecraftItemStack());
    }

    @Override
    public void setLeggings(IScriptItemStack itemStack) {
        this.entity.func_184201_a(EntityEquipmentSlot.LEGS, itemStack.getMinecraftItemStack());
    }

    @Override
    public void setBoots(IScriptItemStack itemStack) {
        this.entity.func_184201_a(EntityEquipmentSlot.FEET, itemStack.getMinecraftItemStack());
    }

    @Override
    public void setSpeed(float speed) {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)speed);
        }
    }

    @Override
    public IScriptEntity getTarget() {
        if (this.entity instanceof EntityLiving) {
            return ScriptEntity.create((Entity)((EntityLiving)this.entity).func_70638_az());
        }
        return null;
    }

    @Override
    public void setTarget(IScriptEntity entity) {
        if (this.entity instanceof EntityLiving && entity == null) {
            EntityLiving livingBase = (EntityLiving)this.entity;
            livingBase.func_70624_b(null);
            livingBase.func_70604_c(null);
            String id = "minecraft:armor_stand";
            double x = this.entity.func_180425_c().func_177958_n();
            double y = this.entity.func_180425_c().func_177956_o() - 1;
            double z = this.entity.func_180425_c().func_177952_p();
            String nbt = "{Marker:1b,NoGravity:1,Invisible:1b,CustomName:\"target_canceler\"}";
            NBTTagCompound tag = new NBTTagCompound();
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ScriptNBTCompound compound = new ScriptNBTCompound(tag);
            ScriptWorld world = new ScriptWorld(((Entity)this.entity).field_70170_p);
            IScriptEntity targetCanceller = world.spawnEntity(id, x, y, z, compound);
            livingBase.func_70624_b((EntityLivingBase)targetCanceller.getMinecraftEntity());
            livingBase.func_70604_c((EntityLivingBase)targetCanceller.getMinecraftEntity());
            targetCanceller.remove();
        } else if (this.entity instanceof EntityLiving && entity.isLivingBase()) {
            EntityLiving livingBase = (EntityLiving)this.entity;
            livingBase.func_70624_b((EntityLivingBase)entity.getMinecraftEntity());
        }
    }

    @Override
    public boolean isAIEnabled() {
        if (this.isLivingBase()) {
            return !((EntityLiving)this.entity).func_175446_cd();
        }
        return false;
    }

    @Override
    public void setAIEnabled(boolean enabled) {
        if (this.isLivingBase()) {
            ((EntityLiving)this.entity).func_94061_f(!enabled);
        }
    }

    @Override
    public String getUniqueId() {
        return this.entity.func_189512_bd();
    }

    @Override
    public String getEntityId() {
        ResourceLocation rl = EntityList.func_191301_a(this.entity);
        return rl == null ? "" : rl.toString();
    }

    @Override
    public int getTicks() {
        return ((Entity)this.entity).field_70173_aa;
    }

    @Override
    public int getCombinedLight() {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)((Entity)this.entity).field_70165_t), 0, MathHelper.func_76128_c((double)((Entity)this.entity).field_70161_v));
        if (((Entity)this.entity).field_70170_p.func_175667_e((BlockPos)pos)) {
            pos.func_185336_p(MathHelper.func_76128_c((double)(((Entity)this.entity).field_70163_u + (double)this.entity.func_70047_e())));
            return ((Entity)this.entity).field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    @Override
    public String getName() {
        return this.entity.func_70005_c_();
    }

    @Override
    public void setName(String name) {
        this.entity.func_96094_a(name);
        if (name.isEmpty()) {
            this.entity.func_174805_g(false);
        } else {
            this.entity.func_174805_g(true);
        }
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.entity.func_82142_c(invisible);
    }

    @Override
    public INBTCompound getFullData() {
        return new ScriptNBTCompound(this.entity.func_189511_e(new NBTTagCompound()));
    }

    @Override
    public void setFullData(INBTCompound data) {
        this.entity.func_70020_e(data.getNBTTagCompound());
    }

    @Override
    public INBTCompound getEntityData() {
        return new ScriptNBTCompound(this.entity.getEntityData());
    }

    @Override
    public boolean isPlayer() {
        return this.entity instanceof EntityPlayer;
    }

    @Override
    @Deprecated
    public boolean isNpc() {
        return this.isNPC();
    }

    @Override
    public boolean isNPC() {
        return this.entity instanceof EntityNpc;
    }

    @Override
    public boolean isItem() {
        return this.entity instanceof EntityItem;
    }

    @Override
    public boolean isLivingBase() {
        return this.entity instanceof EntityLivingBase;
    }

    @Override
    public boolean isSame(IScriptEntity entity) {
        return this.entity == entity.getMinecraftEntity();
    }

    @Override
    public boolean isEntityInRadius(IScriptEntity entity, double radius) {
        return this.entity.func_70068_e(entity.getMinecraftEntity()) <= radius * radius;
    }

    @Override
    public boolean isInArea(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2).func_72326_a(this.entity.func_174813_aQ());
    }

    @Override
    public void damage(float health) {
        if (this.isLivingBase()) {
            this.entity.func_70097_a(DamageSource.field_76380_i, health);
        }
    }

    @Override
    public void damageAs(IScriptEntity entity, float damage) {
        T target = this.entity;
        Entity attacker = entity.getMinecraftEntity();
        if (attacker instanceof EntityLivingBase) {
            EntityLivingBase attackerLiving = (EntityLivingBase)attacker;
            attackerLiving.func_130011_c(target);
            target.func_70097_a(DamageSource.func_188403_a((Entity)attacker, (EntityLivingBase)attackerLiving), damage);
        }
    }

    @Override
    public void damageWithItemsAs(IScriptPlayer player) {
        player.getMinecraftPlayer().func_71059_n(this.entity);
    }

    @Override
    public void mount(IScriptEntity entity) {
        this.entity.func_184205_a(entity.getMinecraftEntity(), true);
    }

    @Override
    public void dismount() {
        this.entity.func_184210_p();
    }

    @Override
    public IScriptEntity getMount() {
        return ScriptEntity.create(this.entity.func_184187_bx());
    }

    @Override
    public ScriptBox getBoundingBox() {
        AxisAlignedBB aabb = this.entity.func_174813_aQ();
        return new ScriptBox(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    private ScriptEntityItem dropItemInternal(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        EntityItem entityItem = new EntityItem(((Entity)this.entity).field_70170_p, this.getPosition().x, this.getPosition().y + (double)this.getEyeHeight(), this.getPosition().z, itemStack);
        entityItem.func_174867_a(40);
        if (this.isNpc()) {
            entityItem.func_145799_b(((EntityNpc)((Object)this.entity)).getId());
        } else {
            entityItem.func_145799_b(this.entity.func_70005_c_());
        }
        entityItem.field_70133_I = true;
        entityItem.func_70024_g(this.getLook().x / 3.0, this.getLook().y / 3.0, this.getLook().z / 3.0);
        if (((Entity)this.entity).field_70170_p.func_72838_d((Entity)entityItem)) {
            return new ScriptEntityItem(entityItem);
        }
        return null;
    }

    @Override
    public ScriptEntityItem dropItem(int amount) {
        ItemStack heldItemStack = this.getMainItem().getMinecraftItemStack();
        if (heldItemStack.func_190926_b()) {
            return null;
        }
        int count = heldItemStack.func_190916_E();
        if (amount > count) {
            amount = count;
        }
        ItemStack droppedStack = heldItemStack.func_77946_l();
        droppedStack.func_190920_e(amount);
        heldItemStack.func_190918_g(amount);
        return this.dropItemInternal(droppedStack);
    }

    @Override
    public ScriptEntityItem dropItem() {
        return this.dropItem(1);
    }

    @Override
    public ScriptEntityItem dropItem(IScriptItemStack scriptItemStack) {
        return this.dropItemInternal(scriptItemStack.getMinecraftItemStack());
    }

    @Override
    public float getFallDistance() {
        return ((Entity)this.entity).field_70143_R;
    }

    @Override
    public void setFallDistance(float distance) {
        ((Entity)this.entity).field_70143_R = distance;
    }

    @Override
    public void remove() {
        this.entity.func_70106_y();
    }

    @Override
    public void kill() {
        this.entity.func_174812_G();
    }

    @Override
    public void swingArm(int arm) {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_184609_a(arm == 1 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        }
    }

    @Override
    public List<IScriptEntity> getLeashedEntities() {
        ArrayList<IScriptEntity> entities = new ArrayList<IScriptEntity>();
        World world = ((Entity)this.entity).field_70170_p;
        for (Entity entity : world.field_72996_f) {
            EntityLiving entityLiving;
            if (!(entity instanceof EntityLiving) || !(entityLiving = (EntityLiving)entity).func_110167_bD() || entityLiving.func_110166_bE() != this.entity) continue;
            entities.add(ScriptEntity.create((Entity)entityLiving));
        }
        return entities;
    }

    @Override
    public boolean setLeashHolder(IScriptEntity leashHolder) {
        if (!(this.entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving leashedEntity = (EntityLiving)this.entity;
        boolean wasLeashed = leashedEntity.func_110167_bD();
        leashedEntity.func_110162_b(leashHolder.getMinecraftEntity(), true);
        return !wasLeashed && leashedEntity.func_110167_bD();
    }

    @Override
    public IScriptEntity getLeashHolder() {
        if (!(this.entity instanceof EntityLiving)) {
            return null;
        }
        EntityLiving leashedEntity = (EntityLiving)this.entity;
        Entity leashHolder = leashedEntity.func_110166_bE();
        if (leashHolder == null) {
            return null;
        }
        return ScriptEntity.create(leashHolder);
    }

    @Override
    public boolean clearLeashHolder(boolean dropLead) {
        if (!(this.entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving leashedEntity = (EntityLiving)this.entity;
        boolean wasLeashed = leashedEntity.func_110167_bD();
        leashedEntity.func_110160_i(true, dropLead);
        return wasLeashed && !leashedEntity.func_110167_bD();
    }

    @Override
    public void setModifier(String modifierName, double value) {
        if (this.entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)this.entity;
            UUID uuid = entityLivingBase.func_110124_au();
            IAttributeInstance attribute = entityLivingBase.func_110140_aT().func_111152_a(modifierName);
            if (attribute == null) {
                return;
            }
            AttributeModifier modifier = new AttributeModifier(uuid, "script." + modifierName, value, 0);
            if (attribute.func_180374_a(modifier)) {
                attribute.func_111124_b(modifier);
            }
            attribute.func_111121_a(modifier);
        }
    }

    @Override
    public double getModifier(String modifierName) {
        EntityLivingBase entityLivingBase;
        IAttributeInstance attribute;
        if (this.entity instanceof EntityLivingBase && (attribute = (entityLivingBase = (EntityLivingBase)this.entity).func_110140_aT().func_111152_a(modifierName)) != null) {
            AttributeModifier modifier = attribute.func_111127_a(entityLivingBase.func_110124_au());
            return modifier == null ? 0.0 : modifier.func_111164_d();
        }
        return 0.0;
    }

    @Override
    public void removeModifier(String modifierName) {
        AttributeModifier modifier;
        EntityLivingBase entityLivingBase;
        IAttributeInstance attribute;
        if (this.entity instanceof EntityLivingBase && (attribute = (entityLivingBase = (EntityLivingBase)this.entity).func_110140_aT().func_111152_a(modifierName)) != null && (modifier = attribute.func_111127_a(entityLivingBase.func_110124_au())) != null) {
            attribute.func_111124_b(modifier);
        }
    }

    @Override
    public void removeAllModifiers() {
        if (this.entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)this.entity;
            for (IAttributeInstance attribute : entityLivingBase.func_110140_aT().func_111146_a()) {
                attribute.func_188479_b(entityLivingBase.func_110124_au());
            }
        }
    }

    @Override
    public void applyPotion(Potion potion, int duration, int amplifier, boolean particles) {
        if (this.isLivingBase()) {
            PotionEffect effect = new PotionEffect(potion, duration, amplifier, false, particles);
            ((EntityLivingBase)this.entity).func_70690_d(effect);
        }
    }

    @Override
    public boolean hasPotion(Potion potion) {
        if (this.isLivingBase()) {
            return ((EntityLivingBase)this.entity).func_70644_a(potion);
        }
        return false;
    }

    @Override
    public boolean removePotion(Potion potion) {
        if (this.isLivingBase()) {
            EntityLivingBase entity = (EntityLivingBase)this.entity;
            int size = entity.func_193076_bZ().size();
            entity.func_184589_d(potion);
            return size != entity.func_193076_bZ().size();
        }
        return false;
    }

    @Override
    public void clearPotions() {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_70674_bp();
        }
    }

    @Override
    public IMappetStates getStates() {
        States states;
        if (this.states == null && (states = EntityUtils.getStates(this.entity)) != null) {
            this.states = new MappetStates(states);
        }
        return this.states;
    }

    @Override
    public AbstractMorph getMorph() {
        if (this.entity instanceof IMorphProvider) {
            return ((IMorphProvider)this.entity).getMorph();
        }
        return null;
    }

    @Override
    public boolean setMorph(AbstractMorph morph) {
        if (Loader.isModLoaded((String)"blockbuster")) {
            return this.setActorsMorph(morph);
        }
        return false;
    }

    @Optional.Method(modid="blockbuster")
    private boolean setActorsMorph(AbstractMorph morph) {
        if (this.entity instanceof EntityActor) {
            EntityActor actor = (EntityActor)this.entity;
            actor.morph.setDirect(morph);
            PacketModifyActor message = new PacketModifyActor(actor);
            mchorse.blockbuster.network.Dispatcher.sendToTracked((Entity)actor, (IMessage)message);
            return true;
        }
        return false;
    }

    @Override
    public void displayMorph(AbstractMorph morph, int expiration, double x, double y, double z, float yaw, float pitch, boolean rotate, IScriptPlayer player) {
        if (morph == null) {
            return;
        }
        WorldMorph worldMorph = new WorldMorph();
        worldMorph.morph = morph;
        worldMorph.expiration = expiration;
        worldMorph.rotate = rotate;
        worldMorph.x = x;
        worldMorph.y = y;
        worldMorph.z = z;
        worldMorph.yaw = yaw;
        worldMorph.pitch = pitch;
        worldMorph.entity = this.entity;
        PacketWorldMorph message = new PacketWorldMorph(worldMorph);
        if (player == null) {
            Dispatcher.sendToTracked(this.entity, message);
            if (this.isPlayer()) {
                Dispatcher.sendTo(message, (EntityPlayerMP)this.entity);
            }
        } else {
            Dispatcher.sendTo(message, player.getMinecraftPlayer());
        }
    }

    @Override
    public IScriptEntity shootBBGunProjectile(String gunPropsNBT) {
        if (this.entity instanceof EntityLivingBase && Loader.isModLoaded((String)"blockbuster")) {
            try {
                return this.shootBBGunProjectileMethod(gunPropsNBT);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Optional.Method(modid="blockbuster")
    private IScriptEntity shootBBGunProjectileMethod(String gunPropsNBT) throws NBTException {
        if (this.entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)this.entity;
            NBTTagCompound gunPropsNBTCompound = JsonToNBT.func_180713_a((String)gunPropsNBT).func_74775_l("Gun");
            GunProps gunProps = new GunProps(gunPropsNBTCompound.func_74775_l("Projectile"));
            gunProps.fromNBT(gunPropsNBTCompound);
            EntityGunProjectile projectile = new EntityGunProjectile(entityLivingBase.field_70170_p, gunProps, gunProps.projectileMorph);
            projectile.func_70107_b(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + 1.8, entityLivingBase.field_70161_v);
            projectile.func_184538_a((Entity)entityLivingBase, entityLivingBase.field_70125_A, entityLivingBase.func_70079_am(), 0.0f, gunProps.speed, 0.0f);
            projectile.setInitialMotion();
            entityLivingBase.field_70170_p.func_72838_d((Entity)projectile);
            return ScriptEntity.create((Entity)projectile);
        }
        return null;
    }

    @Override
    public void executeCommand(String command) {
        ((Entity)this.entity).field_70170_p.func_73046_m().func_71187_D().func_71556_a(this.entity, command);
    }

    @Override
    public void executeScript(String scriptName) {
        this.executeScript(scriptName, "main");
    }

    @Override
    public void executeScript(String scriptName, String function) {
        DataContext context = new DataContext((Entity)this.entity);
        try {
            Mappet.scripts.execute(scriptName, function, context);
        }
        catch (ScriptException e) {
            String fileName = e.getFileName() == null ? scriptName : e.getFileName();
            e.printStackTrace();
            throw new RuntimeException("Script Error: " + fileName + " - Line: " + e.getLineNumber() + " - Column: " + e.getColumnNumber() + " - Message: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Script Empty: " + scriptName + " - Error: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void executeScript(String scriptName, String function, Object ... args) {
        DataContext context = new DataContext((Entity)this.entity);
        try {
            Mappet.scripts.execute(scriptName, function, context, args);
        }
        catch (ScriptException e) {
            String fileName = e.getFileName() == null ? scriptName : e.getFileName();
            e.printStackTrace();
            throw new RuntimeException("Script Error: " + fileName + " - Line: " + e.getLineNumber() + " - Column: " + e.getColumnNumber() + " - Message: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Script Empty: " + scriptName + " - Error: " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void lockPosition(double x, double y, double z) {
        this.entity.getEntityData().func_74757_a("positionLocked", true);
        this.entity.getEntityData().func_74780_a("lockX", x);
        this.entity.getEntityData().func_74780_a("lockY", y);
        this.entity.getEntityData().func_74780_a("lockZ", z);
    }

    @Override
    public void unlockPosition() {
        this.entity.getEntityData().func_74757_a("positionLocked", false);
    }

    @Override
    public boolean isPositionLocked() {
        return this.entity.getEntityData().func_74767_n("positionLocked");
    }

    @Override
    public void lockRotation(float yaw, float pitch, float yawHead) {
        this.entity.getEntityData().func_74757_a("rotationLocked", true);
        this.entity.getEntityData().func_74776_a("lockYaw", yaw);
        this.entity.getEntityData().func_74776_a("lockPitch", pitch);
        this.entity.getEntityData().func_74776_a("lockYawHead", yawHead);
    }

    @Override
    public void unlockRotation() {
        this.entity.getEntityData().func_74757_a("rotationLocked", false);
    }

    @Override
    public boolean isRotationLocked() {
        return this.entity.getEntityData().func_74767_n("rotationLocked");
    }

    @Override
    public void moveTo(String interpolation, int durationTicks, double x, double y, double z, boolean disableAI) {
        if (disableAI) {
            this.setAIEnabled(false);
            this.moveTo(interpolation, durationTicks, x, y, z);
            CommonProxy.eventHandler.addExecutable(new RunnableExecutionFork(durationTicks, () -> this.setAIEnabled(true)));
        } else {
            this.moveTo(interpolation, durationTicks, x, y, z);
        }
    }

    private void moveTo(String interpolation, int durationTicks, double x, double y, double z) {
        Interpolation interp = Interpolation.valueOf((String)interpolation.toUpperCase());
        double startX = ((Entity)this.entity).field_70165_t;
        double startY = ((Entity)this.entity).field_70163_u;
        double startZ = ((Entity)this.entity).field_70161_v;
        for (int i = 0; i < durationTicks; ++i) {
            double progress = (double)i / (double)durationTicks;
            double interpX = interp.interpolate(startX, x, progress);
            double interpY = interp.interpolate(startY, y, progress);
            double interpZ = interp.interpolate(startZ, z, progress);
            CommonProxy.eventHandler.addExecutable(new RunnableExecutionFork(i, () -> this.setPosition(interpX, interpY, interpZ)));
        }
    }

    @Override
    public void observe(IScriptEntity entity) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            if (entity == null) {
                EntityAITasks.EntityAITaskEntry taskToRemove = null;
                for (EntityAITasks.EntityAITaskEntry task : entityLiving.field_70714_bg.field_75782_a) {
                    if (!(task.field_75733_a instanceof EntityAILookAtTarget)) continue;
                    taskToRemove = task;
                    break;
                }
                if (taskToRemove != null) {
                    entityLiving.field_70714_bg.func_85156_a(taskToRemove.field_75733_a);
                }
            } else {
                entityLiving.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookAtTarget(entityLiving, entity.getMinecraftEntity(), 1.0f));
            }
        }
    }

    public IScriptEntity getObservedEntity() {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            for (EntityAITasks.EntityAITaskEntry task : entityLiving.field_70714_bg.field_75782_a) {
                Entity target = null;
                if (task.field_75733_a instanceof EntityAILookAtTarget) {
                    EntityAILookAtTarget lookAtTask = (EntityAILookAtTarget)task.field_75733_a;
                    target = lookAtTask.getTarget();
                } else if (task.field_75733_a instanceof EntityAIWatchClosest) {
                    EntityAIWatchClosest watchClosestTask = (EntityAIWatchClosest)task.field_75733_a;
                    target = this.getEntityFromWatchClosest(watchClosestTask);
                }
                if (target == null) continue;
                return ScriptEntity.create(target);
            }
        }
        return null;
    }

    private Entity getEntityFromWatchClosest(EntityAIWatchClosest watchClosestTask) {
        Entity target = null;
        try {
            target = (Entity)ObfuscationReflectionHelper.getPrivateValue(EntityAIWatchClosest.class, (Object)watchClosestTask, (String[])new String[]{"field_75334_a", "closestEntity"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    @Override
    public void addEntityPatrol(double x, double y, double z, double speed, boolean shouldCirculate, String executeCommandOnArrival) {
        if (this.entity instanceof EntityLiving) {
            EntitiesAIPatrol patrolTask;
            EntityLiving entityLiving = (EntityLiving)this.entity;
            EntityAITasks.EntityAITaskEntry taskToRemove = this.findEntitiesAIPatrolTask(entityLiving);
            if (taskToRemove != null) {
                patrolTask = (EntitiesAIPatrol)taskToRemove.field_75733_a;
                entityLiving.field_70714_bg.func_85156_a((EntityAIBase)patrolTask);
                patrolTask.addPatrolPoint(new BlockPos(x, y, z), shouldCirculate, executeCommandOnArrival);
            } else {
                patrolTask = new EntitiesAIPatrol((EntityLiving)this.entity, speed, new BlockPos[]{new BlockPos(x, y, z)}, new boolean[]{shouldCirculate}, new String[]{executeCommandOnArrival});
            }
            entityLiving.field_70714_bg.func_75776_a(1, (EntityAIBase)patrolTask);
        }
    }

    @Override
    public void clearEntityPatrols() {
        EntityLiving entityLiving;
        EntityAITasks.EntityAITaskEntry taskToRemove;
        if (this.entity instanceof EntityLiving && (taskToRemove = this.findEntitiesAIPatrolTask(entityLiving = (EntityLiving)this.entity)) != null) {
            entityLiving.field_70714_bg.func_85156_a(taskToRemove.field_75733_a);
        }
    }

    private EntityAITasks.EntityAITaskEntry findEntitiesAIPatrolTask(EntityLiving entityLiving) {
        for (EntityAITasks.EntityAITaskEntry task : entityLiving.field_70714_bg.field_75782_a) {
            if (!(task.field_75733_a instanceof EntitiesAIPatrol)) continue;
            return task;
        }
        return null;
    }

    @Override
    public void setRotationsAI(float yaw, float pitch, float yawHead) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            EntityAITasks.EntityAITaskEntry taskToRemove = this.removeTaskIfExists(entityLiving, EntityAIRotations.class);
            entityLiving.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIRotations(entityLiving, yaw, pitch, yawHead, 1.0f));
            RotationDataStorage.getRotationDataStorage(((Entity)this.entity).field_70170_p).addRotationData(entityLiving.func_110124_au(), yaw, pitch, yawHead);
        }
    }

    @Override
    public void clearRotationsAI() {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            this.removeTaskIfExists(entityLiving, EntityAIRotations.class);
            RotationDataStorage.getRotationDataStorage(((Entity)this.entity).field_70170_p).removeRotationData(entityLiving.func_110124_au());
        }
    }

    private EntityAITasks.EntityAITaskEntry removeTaskIfExists(EntityLiving entityLiving, Class<?> taskClass) {
        EntityAITasks.EntityAITaskEntry taskToRemove = null;
        for (EntityAITasks.EntityAITaskEntry task : entityLiving.field_70714_bg.field_75782_a) {
            if (!task.field_75733_a.getClass().equals(taskClass)) continue;
            taskToRemove = task;
            break;
        }
        if (taskToRemove != null) {
            entityLiving.field_70714_bg.func_85156_a(taskToRemove.field_75733_a);
        }
        return taskToRemove;
    }

    @Override
    public void executeRepeatingCommand(String command, int frequency) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            entityLiving.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIRepeatingCommand((Entity)entityLiving, command, frequency));
            RepeatingCommandDataStorage.getRepeatingCommandDataStorage(((Entity)this.entity).field_70170_p).addRepeatingCommandData(entityLiving.func_110124_au(), command, frequency);
        }
    }

    @Override
    public void clearAllRepeatingCommands() {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            this.removeTaskIfExists(entityLiving, EntityAIRepeatingCommand.class);
            RepeatingCommandDataStorage.getRepeatingCommandDataStorage(((Entity)this.entity).field_70170_p).removeRepeatingCommandData(entityLiving.func_110124_au());
        }
    }

    @Override
    public void removeRepeatingCommand(String command) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            this.removeSpecificRepeatingCommandTaskIfExists(entityLiving, command);
            RepeatingCommandDataStorage.getRepeatingCommandDataStorage(((Entity)this.entity).field_70170_p).removeSpecificRepeatingCommandData(entityLiving.func_110124_au(), command);
        }
    }

    private void removeSpecificRepeatingCommandTaskIfExists(EntityLiving entityLiving, String command) {
        ArrayList<EntityAITasks.EntityAITaskEntry> tasksToRemove = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        for (EntityAITasks.EntityAITaskEntry task : entityLiving.field_70714_bg.field_75782_a) {
            if (!(task.field_75733_a instanceof EntityAIRepeatingCommand) || !((EntityAIRepeatingCommand)task.field_75733_a).getCommand().equals(command)) continue;
            tasksToRemove.add(task);
        }
        for (EntityAITasks.EntityAITaskEntry taskToRemove : tasksToRemove) {
            entityLiving.field_70714_bg.func_85156_a(taskToRemove.field_75733_a);
        }
    }
}

