/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities;

import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import mchorse.aperture.network.Dispatcher;
import mchorse.aperture.network.common.PacketCameraState;
import mchorse.mappet.api.scripts.code.entities.ScriptEntity;
import mchorse.mappet.api.scripts.code.items.ScriptInventory;
import mchorse.mappet.api.scripts.code.mappet.MappetQuests;
import mchorse.mappet.api.scripts.code.mappet.MappetUIBuilder;
import mchorse.mappet.api.scripts.code.mappet.MappetUIContext;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.items.IScriptInventory;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.mappet.IMappetQuests;
import mchorse.mappet.api.scripts.user.mappet.IMappetUIBuilder;
import mchorse.mappet.api.scripts.user.mappet.IMappetUIContext;
import mchorse.mappet.api.scripts.user.nbt.INBT;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.ui.UI;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.network.common.scripts.PacketEntityRotations;
import mchorse.mappet.network.common.scripts.PacketSound;
import mchorse.mappet.network.common.ui.PacketCloseUI;
import mchorse.mappet.network.common.ui.PacketUI;
import mchorse.mappet.utils.WorldUtils;
import mchorse.metamorph.api.MorphAPI;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import mchorse.metamorph.capabilities.morphing.Morphing;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ScriptPlayer
extends ScriptEntity<EntityPlayerMP>
implements IScriptPlayer {
    private IMappetQuests quests;
    private IScriptInventory inventory;
    private IScriptInventory enderChest;

    public ScriptPlayer(EntityPlayerMP entity) {
        super(entity);
    }

    @Override
    public EntityPlayerMP getMinecraftPlayer() {
        return (EntityPlayerMP)this.entity;
    }

    @Override
    public void setMotion(double x, double y, double z) {
        super.setMotion(x, y, z);
        ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(((EntityPlayerMP)this.entity).func_145782_y(), x, y, z));
    }

    @Override
    public void setRotations(float pitch, float yaw, float yawHead) {
        super.setRotations(pitch, yaw, yawHead);
        mchorse.mappet.network.Dispatcher.sendTo(new PacketEntityRotations(((EntityPlayerMP)this.entity).func_145782_y(), yaw, yawHead, pitch), (EntityPlayerMP)this.entity);
    }

    @Override
    public void swingArm(int arm) {
        super.swingArm(arm);
        ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)new SPacketAnimation(this.entity, arm == 1 ? 3 : 0));
    }

    @Override
    public int getGameMode() {
        return ((EntityPlayerMP)this.entity).field_71134_c.func_73081_b().func_77148_a();
    }

    @Override
    public void setGameMode(int gameMode) {
        GameType type = GameType.func_77146_a((int)gameMode);
        if (type.func_77148_a() >= 0) {
            ((EntityPlayerMP)this.entity).func_71033_a(type);
        }
    }

    @Override
    public IScriptInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ScriptInventory((IInventory)((EntityPlayerMP)this.entity).field_71071_by);
        }
        return this.inventory;
    }

    @Override
    public IScriptInventory getEnderChest() {
        if (this.enderChest == null) {
            this.enderChest = new ScriptInventory((IInventory)((EntityPlayerMP)this.entity).func_71005_bN());
        }
        return this.enderChest;
    }

    @Override
    public void executeCommand(String command) {
        ((EntityPlayerMP)this.entity).field_70170_p.func_73046_m().func_71187_D().func_71556_a((ICommandSender)this.entity, command);
    }

    @Override
    public void setSpawnPoint(double x, double y, double z) {
        ((EntityPlayerMP)this.entity).func_180473_a(new BlockPos(x, y, z), true);
    }

    @Override
    public ScriptVector getSpawnPoint() {
        BlockPos pos = ((EntityPlayerMP)this.entity).getBedLocation(((EntityPlayerMP)this.entity).field_71093_bK);
        if (pos == null) {
            pos = ((EntityPlayerMP)this.entity).field_70170_p.func_175694_M();
        }
        return new ScriptVector(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public boolean isFlying() {
        return ((EntityPlayerMP)this.entity).field_71075_bZ.field_75100_b;
    }

    @Override
    public float getWalkSpeed() {
        return ((EntityPlayerMP)this.entity).field_71075_bZ.func_75094_b();
    }

    @Override
    public void setFlyingEnabled(boolean enabled) {
        ((EntityPlayerMP)this.entity).field_71075_bZ.field_75101_c = enabled;
        ((EntityPlayerMP)this.entity).func_71016_p();
    }

    @Override
    public float getFlySpeed() {
        return ((EntityPlayerMP)this.entity).field_71075_bZ.func_75093_a();
    }

    @Override
    public void setFlySpeed(float speed) {
        ((EntityPlayerMP)this.entity).field_71075_bZ.func_75092_a(speed);
        ((EntityPlayerMP)this.entity).func_71016_p();
    }

    @Override
    public void resetFlySpeed() {
        this.setFlySpeed(0.05f);
    }

    @Override
    public void setWalkSpeed(float speed) {
        ((EntityPlayerMP)this.entity).field_71075_bZ.func_82877_b(speed);
        ((EntityPlayerMP)this.entity).func_71016_p();
    }

    @Override
    public void resetWalkSpeed() {
        this.setWalkSpeed(0.1f);
    }

    @Override
    public float getCooldown(IScriptItemStack item) {
        return ((EntityPlayerMP)this.entity).func_184811_cZ().func_185143_a(item.getMinecraftItemStack().func_77973_b(), 0.0f);
    }

    @Override
    public float getCooldown(int inventorySlot) {
        return this.getCooldown(this.getInventory().getStack(inventorySlot));
    }

    @Override
    public void setCooldown(IScriptItemStack item, int ticks) {
        ((EntityPlayerMP)this.entity).func_184811_cZ().func_185145_a(item.getMinecraftItemStack().func_77973_b(), ticks);
    }

    @Override
    public void setCooldown(int inventorySlot, int ticks) {
        this.setCooldown(this.getInventory().getStack(inventorySlot), ticks);
    }

    @Override
    public void resetCooldown(IScriptItemStack item) {
        ((EntityPlayerMP)this.entity).func_184811_cZ().func_185142_b(item.getMinecraftItemStack().func_77973_b());
    }

    @Override
    public void resetCooldown(int inventorySlot) {
        this.resetCooldown(this.getInventory().getStack(inventorySlot));
    }

    @Override
    public int getHotbarIndex() {
        return ((EntityPlayerMP)this.entity).field_71071_by.field_70461_c;
    }

    @Override
    public void setHotbarIndex(int slot) {
        if (slot < 0 || slot >= 9) {
            return;
        }
        ((EntityPlayerMP)this.entity).field_71071_by.field_70461_c = slot;
        ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)new SPacketHeldItemChange(slot));
    }

    @Override
    public void send(String message) {
        ((EntityPlayerMP)this.entity).func_145747_a((ITextComponent)new TextComponentString(message));
    }

    @Override
    public void sendRaw(INBT message) {
        ITextComponent component = ITextComponent.Serializer.func_186877_b((String)message.stringify());
        if (component != null) {
            ((EntityPlayerMP)this.entity).func_145747_a(component);
        }
    }

    @Override
    public String getSkin() {
        return "minecraft:skins/" + StringUtils.func_76338_a((String)this.getName().toLowerCase());
    }

    @Override
    public void sendTitleDurations(int fadeIn, int idle, int fadeOut) {
        SPacketTitle packet = new SPacketTitle(fadeIn, idle, fadeOut);
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendTitle(String title) {
        SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.TITLE, (ITextComponent)new TextComponentString(title));
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendSubtitle(String title) {
        SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.SUBTITLE, (ITextComponent)new TextComponentString(title));
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void sendActionBar(String title) {
        SPacketTitle packet = new SPacketTitle(SPacketTitle.Type.ACTIONBAR, (ITextComponent)new TextComponentString(title));
        this.getMinecraftPlayer().field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void setXp(int level, int points) {
        ((EntityPlayerMP)this.entity).func_82242_a(-this.getXpLevel() - 1);
        ((EntityPlayerMP)this.entity).func_82242_a(level);
        ((EntityPlayerMP)this.entity).func_71023_q(points);
    }

    @Override
    public void addXp(int points) {
        ((EntityPlayerMP)this.entity).func_71023_q(points);
    }

    @Override
    public int getXpLevel() {
        return ((EntityPlayerMP)this.entity).field_71068_ca;
    }

    @Override
    public int getXpPoints() {
        return (int)(((EntityPlayerMP)this.entity).field_71106_cc * (float)((EntityPlayerMP)this.entity).func_71050_bK());
    }

    @Override
    public void setHunger(int value) {
        ((EntityPlayerMP)this.entity).func_71024_bL().func_75114_a(value);
    }

    @Override
    public int getHunger() {
        return ((EntityPlayerMP)this.entity).func_71024_bL().func_75116_a();
    }

    @Override
    public void setSaturation(float value) {
        ((EntityPlayerMP)this.entity).func_71024_bL().func_75119_b(value);
    }

    @Override
    public float getSaturation() {
        return ((EntityPlayerMP)this.entity).func_71024_bL().func_75115_e();
    }

    @Override
    public void playSound(String event, double x, double y, double z, float volume, float pitch) {
        WorldUtils.playSound((EntityPlayerMP)this.entity, event, x, y, z, volume, pitch);
    }

    @Override
    public void playSound(String event, String soundCategory, double x, double y, double z, float volume, float pitch) {
        WorldUtils.playSound((EntityPlayerMP)this.entity, event, soundCategory, x, y, z, volume, pitch);
    }

    @Override
    public void playSound(String event, String soundCategory, double x, double y, double z) {
        WorldUtils.playSound((EntityPlayerMP)this.entity, event, soundCategory, x, y, z, 1.0f, 1.0f);
    }

    @Override
    public void stopSound(String event, String category) {
        PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
        packetbuffer.func_180714_a(category);
        packetbuffer.func_180714_a(event);
        ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)new SPacketCustomPayload("MC|StopSound", packetbuffer));
    }

    @Override
    public void playStaticSound(String event, float volume, float pitch) {
        this.playStaticSound(event, "master", volume, pitch);
    }

    @Override
    public void playStaticSound(String event, String soundCategory, float volume, float pitch) {
        mchorse.mappet.network.Dispatcher.sendTo(new PacketSound(event, soundCategory, volume, pitch), (EntityPlayerMP)this.entity);
    }

    @Override
    public IMappetQuests getQuests() {
        if (this.quests == null) {
            this.quests = new MappetQuests(Character.get((EntityPlayer)this.entity).getQuests(), (EntityPlayer)this.entity);
        }
        return this.quests;
    }

    @Override
    public AbstractMorph getMorph() {
        IMorphing cap = Morphing.get((EntityPlayer)((EntityPlayer)this.entity));
        if (cap != null) {
            return cap.getCurrentMorph();
        }
        return super.getMorph();
    }

    @Override
    public boolean setMorph(AbstractMorph morph) {
        if (morph == null) {
            MorphAPI.demorph((EntityPlayer)((EntityPlayer)this.entity));
        } else {
            MorphAPI.morph((EntityPlayer)((EntityPlayer)this.entity), (AbstractMorph)morph, (boolean)true);
        }
        return true;
    }

    @Override
    public boolean openUI(IMappetUIBuilder in, boolean defaultData) {
        boolean noContext;
        if (!(in instanceof MappetUIBuilder)) {
            return false;
        }
        MappetUIBuilder builder = (MappetUIBuilder)in;
        Character character = Character.get((EntityPlayer)this.entity);
        boolean bl = noContext = character.getUIContext() == null;
        if (!noContext) {
            character.getUIContext().close();
        }
        UI ui = builder.getUI();
        UIContext context = new UIContext(ui, (EntityPlayer)this.entity, builder.getScript(), builder.getFunction());
        character.setUIContext(context);
        mchorse.mappet.network.Dispatcher.sendTo(new PacketUI(ui), this.getMinecraftPlayer());
        if (defaultData) {
            context.populateDefaultData();
        }
        context.clearChanges();
        return noContext;
    }

    @Override
    public void closeUI() {
        mchorse.mappet.network.Dispatcher.sendTo(new PacketCloseUI(), this.getMinecraftPlayer());
    }

    @Override
    public IMappetUIContext getUIContext() {
        Character character = Character.get((EntityPlayer)this.entity);
        UIContext context = character.getUIContext();
        return context == null ? null : new MappetUIContext(context);
    }

    @Override
    public Set<String> getFactions() {
        Set<String> factions = new HashSet<String>();
        Character character = Character.get((EntityPlayer)this.entity);
        if (character != null) {
            factions = character.getStates().getFactionNames();
        }
        return factions;
    }

    @Override
    public boolean setupHUD(String id) {
        return Character.get((EntityPlayer)this.entity).setupHUD(id, true);
    }

    @Override
    public void changeHUDMorph(String id, int index, AbstractMorph morph) {
        if (morph == null) {
            return;
        }
        Character.get((EntityPlayer)this.entity).changeHUDMorph(id, index, MorphUtils.toNBT((AbstractMorph)morph));
    }

    @Override
    public void changeHUDMorph(String id, int index, INBTCompound morph) {
        if (morph == null) {
            return;
        }
        Character.get((EntityPlayer)this.entity).changeHUDMorph(id, index, morph.getNBTTagCompound());
    }

    @Override
    public void closeHUD(String id) {
        Character.get((EntityPlayer)this.entity).closeHUD(id);
    }

    @Override
    public void closeAllHUD() {
        Character.get((EntityPlayer)this.entity).closeAllHUD();
    }

    @Override
    public INBTCompound getDisplayedHUDs() {
        Character character = Character.get((EntityPlayer)this.entity);
        NBTTagCompound tag = character.getDisplayedHUDsTag();
        return new ScriptNBTCompound(tag);
    }

    @Override
    public INBTCompound getGlobalDisplayedHUDs() {
        Character character = Character.get((EntityPlayer)this.entity);
        NBTTagCompound tag = character.getGlobalDisplayedHUDsTag();
        return new ScriptNBTCompound(tag);
    }

    @Override
    public void playScene(String sceneName) {
        if (Loader.isModLoaded((String)"aperture")) {
            this.playApertureScene(sceneName, true);
        }
    }

    @Override
    public void stopScene() {
        if (Loader.isModLoaded((String)"aperture")) {
            this.playApertureScene("", false);
        }
    }

    @Optional.Method(modid="aperture")
    private void playApertureScene(String sceneName, boolean toPlay) {
        Dispatcher.sendTo((IMessage)new PacketCameraState(sceneName, toPlay), (EntityPlayerMP)((EntityPlayerMP)this.entity));
    }
}

