/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities.ai.rotations;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class RotationDataStorage
extends WorldSavedData {
    public static final String ROTATION_DATA_KEY = "mappet_rotation_data";
    private Map<UUID, RotationData> rotationDataMap = new HashMap<UUID, RotationData>();

    public RotationDataStorage() {
        super(ROTATION_DATA_KEY);
    }

    public RotationDataStorage(String name) {
        super(name);
    }

    public static RotationDataStorage getRotationDataStorage(World world) {
        MapStorage storage = world.func_175693_T();
        RotationDataStorage rotationDataStorage = (RotationDataStorage)storage.func_75742_a(RotationDataStorage.class, ROTATION_DATA_KEY);
        if (rotationDataStorage == null) {
            rotationDataStorage = new RotationDataStorage();
            storage.func_75745_a(ROTATION_DATA_KEY, (WorldSavedData)rotationDataStorage);
        }
        return rotationDataStorage;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.rotationDataMap.clear();
        NBTTagList rotationDataList = nbt.func_150295_c("rotationDataList", 10);
        for (int i = 0; i < rotationDataList.func_74745_c(); ++i) {
            NBTTagCompound rotationDataCompound = rotationDataList.func_150305_b(i);
            UUID entityId = UUID.fromString(rotationDataCompound.func_74779_i("entityId"));
            float yaw = rotationDataCompound.func_74760_g("yaw");
            float pitch = rotationDataCompound.func_74760_g("pitch");
            float yawHead = rotationDataCompound.func_74760_g("yawHead");
            this.rotationDataMap.put(entityId, new RotationData(yaw, pitch, yawHead));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList rotationDataList = new NBTTagList();
        for (Map.Entry<UUID, RotationData> entry : this.rotationDataMap.entrySet()) {
            NBTTagCompound rotationDataCompound = new NBTTagCompound();
            rotationDataCompound.func_74778_a("entityId", entry.getKey().toString());
            rotationDataCompound.func_74776_a("yaw", entry.getValue().yaw);
            rotationDataCompound.func_74776_a("pitch", entry.getValue().pitch);
            rotationDataCompound.func_74776_a("yawHead", entry.getValue().yawHead);
            rotationDataList.func_74742_a((NBTBase)rotationDataCompound);
        }
        nbt.func_74782_a("rotationDataList", (NBTBase)rotationDataList);
        return nbt;
    }

    public void addRotationData(UUID entityId, float yaw, float pitch, float yawHead) {
        this.rotationDataMap.put(entityId, new RotationData(yaw, pitch, yawHead));
        this.func_76185_a();
    }

    public void removeRotationData(UUID entityId) {
        this.rotationDataMap.remove(entityId);
        this.func_76185_a();
    }

    public RotationData getRotationData(UUID entityId) {
        return this.rotationDataMap.get(entityId);
    }

    public static class RotationData {
        public final float yaw;
        public final float pitch;
        public final float yawHead;

        public RotationData(float yaw, float pitch, float yawHead) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.yawHead = yawHead;
        }
    }
}

