/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.triggers.blocks;

import javax.script.ScriptException;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.triggers.blocks.DataTriggerBlock;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.utils.ScriptUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class ScriptTriggerBlock
extends DataTriggerBlock {
    public String function = "";
    public boolean inline = false;
    public String code = "";

    public ScriptTriggerBlock() {
    }

    public ScriptTriggerBlock(String string, String function) {
        super(string);
        this.function = function;
    }

    @Override
    public boolean isEmpty() {
        return this.inline ? this.code.isEmpty() : this.string.isEmpty();
    }

    @Override
    public String stringify() {
        if (!this.string.isEmpty() && !this.function.isEmpty()) {
            return this.string + " (" + TextFormatting.GRAY + this.function + TextFormatting.RESET + ")";
        }
        return super.stringify();
    }

    @Override
    public void trigger(DataContext context) {
        if (this.inline) {
            try {
                Mappet.scripts.eval(ScriptUtils.sanitize(ScriptUtils.getEngineByExtension("js")), this.code, context);
            }
            catch (ScriptException scriptException) {
                Mappet.logger.error(scriptException.getMessage());
            }
        }
        if (!this.string.isEmpty()) {
            try {
                DataContext data = this.apply(context);
                Mappet.scripts.execute(this.string, this.function.trim(), data);
                if (!context.isCanceled()) {
                    context.cancel(data.isCanceled());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected String getKey() {
        return "Script";
    }

    @Override
    protected void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74778_a("Function", this.function);
        tag.func_74757_a("Inline", this.inline);
        tag.func_74778_a("Code", this.code);
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.function = tag.func_74779_i("Function");
        if (tag.func_74764_b("Inline")) {
            this.inline = tag.func_74767_n("Inline");
        }
        if (tag.func_74764_b("Code")) {
            this.code = tag.func_74779_i("Code");
        }
    }
}

