/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.IconRegistry;
import mchorse.mclib.client.gui.utils.Icons;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UIIconButtonComponent
extends UIComponent {
    public String icon = "";

    public UIIconButtonComponent icon(String icon) {
        this.change("Icon");
        this.icon = icon;
        return this;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected boolean isDataReserved() {
        return true;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        GuiIconElement button = (GuiIconElement)element;
        if (key.equals("Icon")) {
            button.both(this.getIcon());
        }
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiIconElement button = new GuiIconElement(mc, this.getIcon(), b -> {
            if (!this.id.isEmpty()) {
                this.populateData(context.data);
                context.dirty(this.id, this.updateDelay);
            }
        });
        return this.apply((GuiElement)button, context);
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    private Icon getIcon() {
        Icon icon = (Icon)IconRegistry.icons.get(this.icon);
        if (icon == null) {
            icon = Icons.NONE;
        }
        return icon;
    }

    @Override
    @DiscardMethod
    public void populateData(NBTTagCompound tag) {
        super.populateData(tag);
        if (!this.id.isEmpty()) {
            tag.func_74768_a(this.id, tag.func_74762_e(this.id) + 1);
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74778_a("Icon", this.icon);
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Icon")) {
            this.icon = tag.func_74779_i("Icon");
        }
    }
}

