/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.utils.TextUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class UILabelBaseComponent
extends UIComponent {
    public String label = "";
    private Integer color;
    private boolean textShadow = true;
    protected boolean hasBackground = true;

    public UILabelBaseComponent color(int color) {
        return this.color(color, true);
    }

    public UILabelBaseComponent color(int color, boolean shadow) {
        this.change("Color", "TextShadow");
        this.color = color;
        this.textShadow = shadow;
        return this;
    }

    public UILabelBaseComponent label(String label) {
        this.change("Label");
        this.label = label;
        return this;
    }

    @DiscardMethod
    protected String getLabel() {
        return TextUtils.processColoredText((String)this.label);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiElement apply(GuiElement element, UIContext context) {
        if (element instanceof ITextColoring && this.color != null) {
            ((ITextColoring)element).setColor(this.color.intValue(), this.textShadow);
        }
        return super.apply(element, context);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        if (key.equals("Color") && element instanceof ITextColoring) {
            ((ITextColoring)element).setColor(this.color.intValue(), this.textShadow);
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74778_a("Label", this.label);
        if (this.color != null) {
            tag.func_74768_a("Color", this.color.intValue());
        }
        tag.func_74757_a("TextShadow", this.textShadow);
        tag.func_74757_a("HasBackground", this.hasBackground);
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Label")) {
            this.label = tag.func_74779_i("Label");
        }
        if (tag.func_74764_b("Color")) {
            this.color = tag.func_74762_e("Color");
        }
        if (tag.func_74764_b("TextShadow")) {
            this.textShadow = tag.func_74767_n("TextShadow");
        }
        if (tag.func_74764_b("HasBackground")) {
            this.hasBackground = tag.func_74767_n("HasBackground");
        }
    }
}

