/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import java.text.DecimalFormat;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.utils.GuiMorphRenderer;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UIMorphComponent
extends UIComponent {
    public NBTTagCompound morph;
    public boolean editing;
    public Vector3f pos;
    public Vector2f rot;
    public float distance = 2.0f;
    public float fov = 70.0f;

    public UIMorphComponent morph(AbstractMorph morph) {
        this.change("Morph");
        this.morph = MorphUtils.toNBT((AbstractMorph)morph);
        return this;
    }

    public UIMorphComponent editing() {
        return this.editing(true);
    }

    public UIMorphComponent editing(boolean editing) {
        this.change("Editing");
        this.editing = editing;
        return this;
    }

    public UIMorphComponent position(float x, float y, float z) {
        this.change("Position");
        this.pos = new Vector3f(x, y, z);
        return this;
    }

    public UIMorphComponent rotation(float pitch, float yaw) {
        this.change("Rotation");
        this.rot = new Vector2f(pitch, yaw);
        return this;
    }

    public UIMorphComponent distance(float distance) {
        this.change("Distance");
        this.distance = distance;
        return this;
    }

    public UIMorphComponent fov(float fov) {
        this.change("Fov");
        this.fov = fov;
        return this;
    }

    @Override
    @DiscardMethod
    protected int getDefaultUpdateDelay() {
        return 200;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        GuiMorphRenderer renderer = (GuiMorphRenderer)element;
        if (key.equals("Morph")) {
            renderer.morph.set(MorphManager.INSTANCE.morphFromNBT(this.morph));
        } else if (key.equals("Editing")) {
            ((GuiNestedEdit)renderer.getChildren(GuiNestedEdit.class).get(0)).setVisible(this.editing);
        } else if (key.equals("Position") && this.pos != null) {
            renderer.setPosition(this.pos.x, this.pos.y, this.pos.z);
        } else if (key.equals("Rotation") && this.rot != null) {
            renderer.setRotation(this.rot.y, this.rot.x);
        } else if (key.equals("Distance")) {
            renderer.scale = this.distance;
        } else if (key.equals("Fov")) {
            renderer.fov = this.fov;
        }
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiMorphRenderer renderer = new GuiMorphRenderer(mc);
        if (this.morph != null) {
            renderer.morph.set(MorphManager.INSTANCE.morphFromNBT(this.morph));
        }
        GuiNestedEdit edit = new GuiNestedEdit(mc, editing -> GuiMappetDashboard.get(mc).openMorphMenu((GuiElement)renderer.getRoot(), (boolean)editing, renderer.morph.copy(), morph -> {
            if (this.id.isEmpty()) {
                return;
            }
            AbstractMorph copy = MorphUtils.copy((AbstractMorph)morph);
            NBTTagCompound copyTag = MorphUtils.toNBT((AbstractMorph)copy);
            renderer.morph.setDirect(copy);
            context.data.func_74782_a(this.id, (NBTBase)(copyTag == null ? new NBTTagCompound() : copyTag));
            context.dirty(this.id, this.updateDelay);
        }));
        edit.flex().relative((GuiElement)renderer).x(0.5f).y(1.0f, -30).wh(100, 20).anchorX(0.5f);
        edit.setVisible(this.editing);
        renderer.add((IGuiElement)edit);
        if (this.pos != null) {
            renderer.setPosition(this.pos.x, this.pos.y, this.pos.z);
        }
        if (this.rot != null) {
            renderer.setRotation(this.rot.y, this.rot.x);
        }
        renderer.scale = this.distance;
        renderer.fov = this.fov;
        return this.apply((GuiElement)renderer, context);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void resetContext(GuiElement element, UIContext context) {
        GuiMorphRenderer renderer = (GuiMorphRenderer)element;
        renderer.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(Minecraft.func_71410_x());
            if (((Boolean)Mappet.scriptUIDebug.get()).booleanValue()) {
                menu.action(Icons.SEARCH, IKey.lang((String)"mappet.gui.context.copy_camera"), () -> this.copyCameraProperties(renderer));
            }
            return menu;
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void createContext(GuiSimpleContextMenu menu, GuiElement element, UIContext context) {
        if (((Boolean)Mappet.scriptUIDebug.get()).booleanValue()) {
            GuiMorphRenderer renderer = (GuiMorphRenderer)element;
            menu.action(Icons.SEARCH, IKey.lang((String)"mappet.gui.context.copy_camera"), () -> this.copyCameraProperties(renderer));
        }
        super.createContext(menu, element, context);
    }

    @SideOnly(value=Side.CLIENT)
    private void copyCameraProperties(GuiMorphRenderer renderer) {
        DecimalFormat formatter = GuiTrackpadElement.FORMAT;
        GuiScreen.func_146275_d((String)(".position(" + formatter.format(renderer.pos.x) + ", " + formatter.format(renderer.pos.y) + ", " + formatter.format(renderer.pos.z) + ").rotation(" + formatter.format(renderer.pitch) + ", " + formatter.format(renderer.yaw) + ").distance(" + formatter.format(renderer.scale) + ").fov(" + formatter.format(renderer.fov) + ")"));
    }

    @Override
    @DiscardMethod
    public void populateData(NBTTagCompound tag) {
        super.populateData(tag);
        if (!this.id.isEmpty()) {
            tag.func_74782_a(this.id, (NBTBase)this.morph.func_74737_b());
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        if (this.morph != null) {
            tag.func_74782_a("Morph", (NBTBase)this.morph);
        }
        tag.func_74757_a("Editing", this.editing);
        if (this.pos != null) {
            NBTTagList pos = new NBTTagList();
            NBTUtils.writeFloatList((NBTTagList)pos, (Vector3f)this.pos);
            tag.func_74782_a("Position", (NBTBase)pos);
        }
        if (this.rot != null) {
            NBTTagList rot = new NBTTagList();
            Vector3f rotation = new Vector3f(this.rot.x, this.rot.y, 0.0f);
            NBTUtils.writeFloatList((NBTTagList)rot, (Vector3f)rotation);
            tag.func_74782_a("Rotation", (NBTBase)rot);
        }
        tag.func_74776_a("Distance", this.distance);
        tag.func_74776_a("Fov", this.fov);
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Morph")) {
            this.morph = tag.func_74775_l("Morph");
        }
        if (tag.func_74764_b("Editing")) {
            this.editing = tag.func_74767_n("Editing");
        }
        if (tag.func_74764_b("Position")) {
            Vector3f position = new Vector3f();
            NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("Position", 5), (Vector3f)position);
            this.pos = position;
        }
        if (tag.func_74764_b("Rotation")) {
            Vector3f rotation = new Vector3f();
            NBTUtils.readFloatList((NBTTagList)tag.func_150295_c("Rotation", 5), (Vector3f)rotation);
            this.rot = new Vector2f(rotation.x, rotation.y);
        }
        if (tag.func_74764_b("Distance")) {
            this.distance = tag.func_74760_g("Distance");
        }
        if (tag.func_74764_b("Fov")) {
            this.fov = tag.func_74760_g("Fov");
        }
    }
}

