/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UIComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UIStringListComponent
extends UIComponent {
    public List<String> values = new ArrayList<String>();
    public Integer selected;
    public Integer background;

    public UIStringListComponent values(String ... values) {
        this.change("Values");
        this.values.clear();
        this.values.addAll(Arrays.asList(values));
        return this;
    }

    public UIStringListComponent values(List<String> values) {
        this.change("Values");
        this.values.clear();
        this.values.addAll(values);
        return this;
    }

    public UIStringListComponent setValues(List<String> values) {
        return this.values(values);
    }

    public List<String> getValues() {
        return this.values;
    }

    public UIStringListComponent selected(int selected) {
        this.change("Selected");
        this.selected = selected;
        return this;
    }

    public UIStringListComponent background() {
        return this.background(-2013265920);
    }

    public UIStringListComponent background(int background) {
        this.change("Background");
        this.background = background;
        return this;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        GuiStringListElement list = (GuiStringListElement)element;
        if (key.equals("Values")) {
            list.clear();
            list.add(this.values);
        } else if (key.equals("Selected") && this.selected != null) {
            list.setIndex(this.selected.intValue());
        } else if (key.equals("Background") && this.background != null) {
            list.background(this.background.intValue());
        }
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiStringListElement element = new GuiStringListElement(mc, null);
        element.callback = v -> {
            if (!this.id.isEmpty()) {
                context.data.func_74778_a(this.id, (String)v.get(0));
                context.data.func_74768_a(this.id + ".index", element.getIndex());
                context.dirty(this.id, this.updateDelay);
            }
        };
        element.add(this.values);
        if (this.selected != null) {
            element.setIndex(this.selected.intValue());
        }
        if (this.background != null) {
            element.background(this.background.intValue());
        }
        return this.apply((GuiElement)element, context);
    }

    @Override
    @DiscardMethod
    public void populateData(NBTTagCompound tag) {
        super.populateData(tag);
        if (!this.id.isEmpty()) {
            String value = "";
            int index = 0;
            if (this.selected != null && this.selected >= 0 && this.selected < this.values.size()) {
                value = this.values.get(this.selected);
                index = this.selected;
            }
            tag.func_74768_a(this.id + ".index", index);
            tag.func_74778_a(this.id, value);
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        NBTTagList list = new NBTTagList();
        for (String value : this.values) {
            list.func_74742_a((NBTBase)new NBTTagString(value));
        }
        if (list.func_74745_c() > 0 || this.changedProperties.contains("Values")) {
            tag.func_74782_a("Values", (NBTBase)list);
        }
        if (this.selected != null) {
            tag.func_74768_a("Selected", this.selected.intValue());
        }
        if (this.background != null) {
            tag.func_74768_a("Background", this.background.intValue());
        }
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.values.clear();
        if (tag.func_74764_b("Values")) {
            NBTTagList list = tag.func_150295_c("Values", 8);
            int c = list.func_74745_c();
            for (int i = 0; i < c; ++i) {
                this.values.add(list.func_150307_f(i));
            }
        }
        if (tag.func_74764_b("Selected")) {
            this.selected = tag.func_74762_e("Selected");
        }
        if (tag.func_74764_b("Background")) {
            this.background = tag.func_74762_e("Background");
        }
    }
}

