/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.utils.factory;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mchorse.mappet.api.utils.factory.IFactory;

public class MapFactory<T>
implements IFactory<T> {
    private BiMap<String, Class<? extends T>> factory = HashBiMap.create();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<Class<? extends T>, Integer> colors = new HashMap<Class<? extends T>, Integer>();

    public MapFactory<T> copy() {
        MapFactory<T> factory = new MapFactory<T>();
        for (Map.Entry entry : this.factory.entrySet()) {
            factory.register((String)entry.getKey(), (Class)entry.getValue(), this.colors.get(entry.getValue()));
        }
        factory.aliases.putAll(this.aliases);
        return factory;
    }

    public MapFactory<T> register(String type, Class<? extends T> clazz, int color) {
        this.factory.put((Object)type, clazz);
        this.colors.put(clazz, color);
        return this;
    }

    public MapFactory<T> alias(String type, String alias) {
        this.aliases.put(alias, type);
        return this;
    }

    public MapFactory<T> unregister(String key) {
        Class clazz = (Class)this.factory.remove((Object)key);
        this.colors.remove(clazz);
        return this;
    }

    @Override
    public String getType(T node) {
        String type = (String)this.factory.inverse().get(node.getClass());
        if (type != null) {
            return type;
        }
        throw new IllegalStateException("Node " + node.getClass() + " is not part of event node system!");
    }

    @Override
    public T create(String type) {
        Class clazz = (Class)this.factory.get((Object)type);
        if (clazz == null) {
            clazz = (Class)this.factory.get((Object)this.aliases.get(type));
        }
        if (clazz != null) {
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Node type " + type + " is not part of event node system!");
    }

    @Override
    public int getColor(T object) {
        Integer color = this.colors.get(object.getClass());
        return color == null ? 0 : color;
    }

    @Override
    public int getColor(String type) {
        Integer color = this.colors.get(this.factory.get((Object)type));
        return color == null ? 0 : color;
    }

    @Override
    public Collection<String> getKeys() {
        return this.factory.keySet();
    }
}

