/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.utils.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.factory.IFactory;
import mchorse.mappet.api.utils.nodes.Node;
import mchorse.mappet.api.utils.nodes.NodeRelation;
import mchorse.mappet.api.utils.nodes.NodeUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class NodeSystem<T extends Node>
extends AbstractData {
    private IFactory<T> factory;
    public Map<UUID, T> nodes = new HashMap<UUID, T>();
    public Map<UUID, List<NodeRelation<T>>> relations = new HashMap<UUID, List<NodeRelation<T>>>();
    public T main;

    public NodeSystem(IFactory<T> factory) {
        this.factory = factory;
    }

    public IFactory<T> getFactory() {
        return this.factory;
    }

    public void add(T node) {
        if (((Node)node).getId() == null) {
            UUID id;
            while (this.nodes.containsKey(id = UUID.randomUUID())) {
            }
            ((Node)node).setId(id);
        } else if (this.nodes.containsKey(((Node)node).getId())) {
            throw new IllegalStateException("Node by UUID " + ((Node)node).getId() + " is already present in this node system!");
        }
        this.nodes.put(((Node)node).getId(), node);
    }

    public boolean tie(T output, T input) {
        if (output == input) {
            return false;
        }
        if (this.nodes.containsKey(((Node)output).getId()) && this.nodes.containsKey(((Node)input).getId()) && !this.hasRelation(output, input)) {
            List<NodeRelation<T>> relations = this.relations.get(((Node)output).getId());
            if (relations == null) {
                relations = new ArrayList<NodeRelation<T>>();
                this.relations.put(((Node)output).getId(), relations);
            }
            relations.add(new NodeRelation<T>(output, input));
            return true;
        }
        return false;
    }

    public void untie(T output, T input) {
        List<NodeRelation<T>> relations = this.relations.get(((Node)output).getId());
        if (relations != null) {
            relations.removeIf(relation -> relation.input == input);
            if (relations.isEmpty()) {
                this.relations.remove(((Node)output).getId());
            }
        }
    }

    public void addTie(T output, T toAdd) {
        this.add(toAdd);
        this.tie(output, toAdd);
    }

    public void addMain(T node) {
        this.add(node);
        this.main = node;
    }

    public boolean remove(T node) {
        UUID key = ((Node)node).getId();
        if (!this.nodes.containsKey(key)) {
            return false;
        }
        this.nodes.remove(key);
        this.relations.remove(((Node)node).getId());
        Iterator<Map.Entry<UUID, List<NodeRelation<T>>>> it = this.relations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, List<NodeRelation<T>>> entry = it.next();
            entry.getValue().removeIf(relation -> relation.input == node);
            if (!entry.getValue().isEmpty()) continue;
            it.remove();
        }
        return true;
    }

    public boolean hasRelation(T output, T input) {
        return this.getRelation(output, input) != null;
    }

    public NodeRelation<T> getRelation(T output, T input) {
        if (!this.relations.containsKey(((Node)output).getId())) {
            return null;
        }
        for (NodeRelation<T> relation : this.relations.get(((Node)output).getId())) {
            if (!Objects.equals(((Node)relation.input).getId(), ((Node)input).getId())) continue;
            return relation;
        }
        return null;
    }

    public List<T> getChildren(T node) {
        ArrayList children = new ArrayList();
        if (this.relations.containsKey(((Node)node).getId())) {
            for (NodeRelation<T> relation : this.relations.get(((Node)node).getId())) {
                if (relation.output != node) continue;
                children.add(relation.input);
            }
        }
        return children;
    }

    public List<T> getRoots() {
        ArrayList<Node> roots = new ArrayList<Node>();
        block0: for (Node node : this.nodes.values()) {
            for (List<NodeRelation<T>> relations : this.relations.values()) {
                for (NodeRelation<T> relation : relations) {
                    if (relation.input != node) continue;
                    continue block0;
                }
            }
            roots.add(node);
        }
        return roots;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList nodes = new NBTTagList();
        for (Node node : this.nodes.values()) {
            NBTTagCompound nodeTag = NodeUtils.nodeToNBT(this, node);
            if (this.relations.containsKey(node.getId())) {
                NBTTagList relations = new NBTTagList();
                for (NodeRelation<T> relation : this.relations.get(node.getId())) {
                    relations.func_74742_a((NBTBase)new NBTTagString(((Node)relation.input).getId().toString()));
                }
                nodeTag.func_74782_a("Relations", (NBTBase)relations);
            }
            nodes.func_74742_a((NBTBase)nodeTag);
        }
        if (nodes.func_74745_c() > 0) {
            if (this.main != null && this.nodes.containsKey(((Node)this.main).getId())) {
                tag.func_74778_a("Main", ((Node)this.main).getId().toString());
            }
            tag.func_74782_a("Nodes", (NBTBase)nodes);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        HashMap map = new HashMap();
        if (tag.func_150297_b("Nodes", 9)) {
            NBTTagList nodes = tag.func_150295_c("Nodes", 10);
            for (int i = 0; i < nodes.func_74745_c(); ++i) {
                NBTTagCompound nodeTag = nodes.func_150305_b(i);
                Object node = NodeUtils.nodeFromNBT(this, nodeTag);
                if (nodeTag.func_74764_b("Relations")) {
                    ArrayList<UUID> uuids = new ArrayList<UUID>();
                    NBTTagList relations = nodeTag.func_150295_c("Relations", 8);
                    map.put(((Node)node).getId(), uuids);
                    for (int j = 0; j < relations.func_74745_c(); ++j) {
                        uuids.add(UUID.fromString(relations.func_150307_f(j)));
                    }
                }
                this.add(node);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            for (UUID input : (List)entry.getValue()) {
                Node nodeInput;
                Node nodeOutput = (Node)this.nodes.get(entry.getKey());
                if (nodeOutput == (nodeInput = (Node)this.nodes.get(input)) || nodeInput == null || nodeOutput == null) continue;
                this.tie(nodeOutput, nodeInput);
            }
        }
        if (tag.func_74764_b("Main")) {
            this.main = (Node)this.nodes.get(UUID.fromString(tag.func_74779_i("Main")));
        }
    }
}

