/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.utils.Utils;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class SoundPack
implements IResourcePack {
    private File folder;

    public SoundPack(File folder) {
        this.folder = folder;
        this.folder.mkdirs();
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (location.func_110623_a().equals("sounds.json")) {
            JsonObject object = this.generateJson(this.folder, "", new JsonObject());
            return IOUtils.toInputStream((String)object.toString(), (Charset)Utils.getCharset());
        }
        File file = this.getFile(location.func_110623_a());
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    private JsonObject generateJson(File folder, String prefix, JsonObject object) {
        if (!folder.exists()) {
            return object;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return object;
        }
        for (File file : files) {
            String name = file.getName();
            if (name.endsWith(".ogg")) {
                JsonObject sound = new JsonObject();
                JsonArray elements = new JsonArray();
                String id = name.substring(0, name.lastIndexOf(".ogg"));
                sound.add("sounds", (JsonElement)elements);
                elements.add("mp.sounds:" + prefix + id);
                object.add(prefix.replaceAll("/", ".") + id, (JsonElement)sound);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.generateJson(file, prefix + name + "/", object);
        }
        return object;
    }

    public static List<String> getCustomSoundEvents() {
        ArrayList<String> soundEvents = new ArrayList<String>();
        File soundsFolder = new File(CommonProxy.configFolder, "sounds");
        SoundPack soundPack = new SoundPack(soundsFolder);
        JsonObject soundJson = soundPack.generateJson(soundsFolder, "", new JsonObject());
        for (Map.Entry entry : soundJson.entrySet()) {
            soundEvents.add("mp.sounds:" + (String)entry.getKey());
        }
        return soundEvents;
    }

    public boolean func_110589_b(ResourceLocation location) {
        if (location.func_110623_a().equals("sounds.json")) {
            return true;
        }
        return this.getFile(location.func_110623_a()).exists();
    }

    private File getFile(String path) {
        return new File(this.folder, path.substring(7));
    }

    public Set<String> func_110587_b() {
        return ImmutableSet.of((Object)"mp.sounds");
    }

    public String func_130077_b() {
        return "Mappet's sound pack";
    }

    @Nullable
    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }
}

