/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui;

import java.util.List;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.api.dialogues.DialogueFragment;
import mchorse.mappet.api.quests.chains.QuestInfo;
import mchorse.mappet.api.quests.chains.QuestStatus;
import mchorse.mappet.client.gui.crafting.GuiCrafting;
import mchorse.mappet.client.gui.crafting.ICraftingScreen;
import mchorse.mappet.client.gui.quests.GuiQuestCard;
import mchorse.mappet.client.gui.quests.GuiQuestInfoListElement;
import mchorse.mappet.client.gui.utils.GuiMorphRenderer;
import mchorse.mappet.client.gui.utils.text.GuiClickableText;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.dialogue.PacketDialogueFragment;
import mchorse.mappet.network.common.dialogue.PacketFinishDialogue;
import mchorse.mappet.network.common.dialogue.PacketPickReply;
import mchorse.mappet.network.common.quests.PacketQuestAction;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiInteractionScreen
extends GuiBase
implements ICraftingScreen {
    public GuiElement area;
    public GuiMorphRenderer morph;
    public GuiButtonElement back;
    public GuiScrollElement reaction;
    public GuiText reactionText;
    public GuiScrollElement replies;
    private PacketDialogueFragment fragment;
    public GuiCrafting crafting;
    private CraftingTable table;
    public GuiElement quest;
    public GuiQuestInfoListElement quests;
    public GuiScrollElement questArea;
    public GuiButtonElement actionQuest;
    private List<QuestInfo> questInfos;

    public GuiInteractionScreen(PacketDialogueFragment fragment) {
        Minecraft mc = Minecraft.func_71410_x();
        this.morph = new GuiMorphRenderer(mc);
        this.morph.flex().relative((IResizer)this.viewport).x(0.4f).w(0.6f).h(1.0f);
        this.back = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.interaction.back"), b -> Dispatcher.sendToServer(new PacketPickReply(-1)));
        this.morph.fov = 40.0f;
        this.morph.setScale(2.1f);
        this.morph.setRotation(-27.0f, 5.0f);
        this.morph.setPosition(-0.1313307f, 1.3154614f, 0.0359409f);
        this.morph.setEnabled(false);
        this.area = new GuiElement(mc);
        this.area.flex().relative((IResizer)this.viewport).x(0.2f).y(20).w(0.4f).h(1.0f, -20);
        this.reaction = new GuiScrollElement(mc);
        this.reactionText = new GuiText(mc);
        this.replies = new GuiScrollElement(mc);
        this.reaction.flex().relative(this.area).w(1.0f).hTo((IResizer)this.replies.area).column(5).vertical().stretch().scroll().padding(10);
        this.replies.flex().relative(this.area).y(0.75f).w(1.0f).hTo((IResizer)this.area.area, 1.0f).column(10).vertical().stretch().scroll().padding(10);
        this.crafting = new GuiCrafting(mc);
        this.crafting.flex().relative(this.area).y(0.45f).w(1.0f).hTo((IResizer)this.area.area, 1.0f);
        this.crafting.setVisible(false);
        this.quest = new GuiElement(mc);
        this.quest.setVisible(false);
        this.quests = new GuiQuestInfoListElement(mc, l -> this.pickQuest((QuestInfo)l.get(0)));
        this.questArea = new GuiScrollElement(mc);
        this.actionQuest = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.interaction.accept"), b -> this.actionQuest());
        this.quest.flex().relative(this.area).y(0.25f).w(1.0f).hTo((IResizer)this.area.area, 1.0f);
        this.quests.background().flex().relative(this.quest).y(10).w(1.0f).h(56);
        this.questArea.flex().relative(this.quest).y(66).w(1.0f).hTo((IResizer)this.actionQuest.area, -5).column(5).vertical().stretch().scroll().padding(10);
        this.actionQuest.flex().relative(this.quest).x(1.0f, -10).y(1.0f, -10).wh(80, 20).anchor(1.0f, 1.0f);
        this.quest.add(new IGuiElement[]{this.actionQuest, this.questArea, this.quests});
        GuiDrawable drawable = new GuiDrawable(context -> {
            Gui.func_73734_a((int)0, (int)0, (int)this.area.area.x(0.65f), (int)this.area.area.ey(), (int)-1442840576);
            GuiDraw.drawHorizontalGradientRect((int)this.area.area.x(0.65f), (int)0, (int)this.area.area.x(1.125f), (int)this.area.area.ey(), (int)-1442840576, (int)0);
        });
        this.area.add(new IGuiElement[]{this.quest, this.crafting, this.replies, this.reaction});
        this.root.add(new IGuiElement[]{this.morph, drawable, this.area});
        this.reaction.add((IGuiElement)this.reactionText);
        this.pickReply(fragment);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void updateVisibility() {
        this.back.removeFromParent();
        if (this.questInfos != null) {
            this.quests.setVisible(!this.fragment.singleQuest);
            if (this.fragment.singleQuest) {
                this.questArea.flex().relative(this.quest).y(0);
            } else {
                this.questArea.flex().relative(this.quest).y(66);
            }
            this.reaction.flex().hTo((IResizer)this.quest.area);
            this.back.flex().reset().relative(this.quest).x(10).y(1.0f, -10).wh(80, 20).anchorY(1.0f);
            this.quest.add((IGuiElement)this.back);
        } else if (this.table != null) {
            this.reaction.flex().hTo((IResizer)this.crafting.area);
            this.back.flex().reset().relative((GuiElement)this.crafting).x(10).y(1.0f, -10).wh(80, 20).anchorY(1.0f);
            this.crafting.add((IGuiElement)this.back);
        } else {
            this.reaction.flex().hTo((IResizer)this.replies.area);
        }
        this.quest.setVisible(this.questInfos != null);
        this.crafting.setVisible(this.table != null);
        this.replies.setVisible(this.questInfos == null && this.table == null);
    }

    private void setFragment(PacketDialogueFragment fragment) {
        if (fragment.morph != null) {
            this.morph.morph.set(fragment.morph);
        }
        this.fragment = fragment;
        this.table = null;
        this.questInfos = null;
        this.reactionText.text(fragment.reaction.getProcessedText());
        this.reactionText.color(fragment.reaction.color, true);
        this.replies.removeAll();
        for (DialogueFragment reply : fragment.replies) {
            GuiClickableText replyElement = new GuiClickableText(Minecraft.func_71410_x());
            replyElement.callback(this::pickReply);
            replyElement.color(reply.color, true);
            replyElement.hoverColor(ColorUtils.multiplyColor((int)reply.color, (float)0.7f));
            this.replies.add((IGuiElement)replyElement.text("> " + reply.getProcessedText()));
        }
        this.updateVisibility();
        this.root.resize();
    }

    private void pickReply(GuiClickableText text) {
        Dispatcher.sendToServer(new PacketPickReply(this.replies.getChildren().indexOf((Object)text)));
    }

    public void pickReply(PacketDialogueFragment fragment) {
        this.setFragment(fragment);
        if (fragment.reaction.text.isEmpty() && fragment.isEmpty()) {
            this.closeScreen();
            return;
        }
        if (fragment.hasQuests) {
            this.setQuests(fragment.quests);
        } else if (fragment.table != null) {
            this.setCraftingTable(fragment.table);
        }
    }

    public void setCraftingTable(CraftingTable table) {
        this.table = table;
        this.crafting.set(table);
        this.updateVisibility();
        this.root.resize();
    }

    @Override
    public void refresh() {
        this.crafting.refresh();
    }

    public void setQuests(List<QuestInfo> quests) {
        this.questInfos = quests;
        this.quests.clear();
        this.quests.setList(quests);
        this.quests.sort();
        this.quests.setVisible(!quests.isEmpty());
        this.quests.setIndex(0);
        this.pickQuest((QuestInfo)this.quests.getCurrentFirst());
        this.updateVisibility();
        this.root.resize();
    }

    public void pickQuest(QuestInfo info) {
        this.questArea.removeAll();
        this.actionQuest.label.set(info != null && info.status == QuestStatus.COMPLETED ? "mappet.gui.interaction.complete" : "mappet.gui.interaction.accept");
        if (info != null) {
            GuiQuestCard.fillQuest((GuiElement)this.questArea, info.quest, true, false);
        }
        this.questArea.resize();
        this.actionQuest.setEnabled(info != null && info.status != QuestStatus.UNAVAILABLE);
    }

    public void actionQuest() {
        QuestInfo info = (QuestInfo)this.quests.getCurrentFirst();
        Dispatcher.sendToServer(new PacketQuestAction(info.quest.getId(), info.status));
        if (this.fragment.singleQuest && info.status == QuestStatus.COMPLETED) {
            this.back.clickItself(GuiBase.getCurrent());
            return;
        }
        if (info.status == QuestStatus.AVAILABLE) {
            info.status = QuestStatus.UNAVAILABLE;
            this.actionQuest.setEnabled(false);
        } else if (info.status == QuestStatus.COMPLETED) {
            this.quests.setIndex(0);
            info = (QuestInfo)this.quests.getCurrentFirst();
            this.pickQuest(info);
        }
    }

    protected void closeScreen() {
        if (this.fragment.closable || this.fragment.isEmpty()) {
            super.closeScreen();
            Dispatcher.sendToServer(new PacketFinishDialogue());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.fragment.isEmpty()) {
            int y = this.table != null ? this.crafting.area.y - 1 : (this.questInfos != null ? this.quest.area.y - 1 : this.replies.area.y - 1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.drawHorizontalGradientRect((int)(this.replies.area.x - 20), (int)y, (int)this.replies.area.mx(), (int)(y + 1), (int)0, (int)-1996488705);
            GuiDraw.drawHorizontalGradientRect((int)this.replies.area.mx(), (int)y, (int)(this.replies.area.ex() + 20), (int)(y + 1), (int)-1996488705, (int)0);
        } else {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"mappet.gui.interaction.info.no_replies", (Object[])new Object[0]), this.replies.area.mx(), this.replies.area.my(), 0x333333);
        }
        if (this.questInfos != null && this.quests.getList().isEmpty()) {
            int w = (int)((float)this.questArea.area.w / 1.5f);
            GuiDraw.drawMultiText((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"mappet.gui.interaction.info.no_quests", (Object[])new Object[0]), (int)(this.questArea.area.mx() - w / 2), (int)((this.quest.area.y + this.actionQuest.area.y - 10) / 2), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
        if (this.fragment != null) {
            this.func_73732_a(this.field_146289_q, this.fragment.title, this.reaction.area.mx(), 10, 0xFFFFFF);
        }
    }
}

