/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui;

import java.util.Map;
import mchorse.mappet.api.factions.Faction;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.Quests;
import mchorse.mappet.api.quests.chains.QuestStatus;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.client.gui.factions.GuiFactionCard;
import mchorse.mappet.client.gui.quests.GuiQuestCard;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.factions.PacketRequestFactions;
import mchorse.mappet.network.common.quests.PacketQuestAction;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiLabelListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;

public class GuiJournalScreen
extends GuiBase {
    public GuiScrollElement factions;
    public GuiElement quests;
    public GuiLabelListElement<Quest> questList;
    public GuiScrollElement questArea;
    public GuiIconElement cancel;

    public GuiJournalScreen(Minecraft mc) {
        Character character = Character.get((EntityPlayer)mc.field_71439_g);
        Quests quests = character.getQuests();
        this.factions = new GuiScrollElement(mc);
        this.quests = new GuiElement(mc);
        this.factions.flex().relative((IResizer)this.viewport).x(1.0f, -250).y(22).w(240).h(1.0f, -22).column(10).vertical().stretch().scroll().padding(10);
        this.quests.flex().relative((IResizer)this.viewport).xy(10, 22).wTo((IResizer)this.factions.area).h(1.0f, -32);
        this.questList = new GuiLabelListElement(mc, l -> this.pickQuest((Quest)((Label)l.get((int)0)).value, false));
        this.questArea = new GuiScrollElement(mc);
        for (Map.Entry<String, Quest> entry : quests.quests.entrySet()) {
            this.questList.add(IKey.str((String)entry.getValue().getProcessedTitle()), (Object)entry.getValue());
        }
        this.questList.background().sort();
        this.cancel = new GuiIconElement(mc, Icons.CLOSE, b -> this.cancelQuest());
        this.cancel.disabledColor(-1996488705);
        this.cancel.flex().relative(this.quests).x(1.0f, -14).y(14).anchor(0.5f, 0.5f);
        this.questList.flex().relative(this.quests).w(120).h(1.0f);
        this.questArea.flex().relative(this.quests).x(120).w(1.0f, -120).h(1.0f).column(5).vertical().stretch().scroll().padding(10);
        this.root.add(new IGuiElement[]{this.factions, this.quests});
        this.quests.add(new IGuiElement[]{this.questList, this.questArea, this.cancel});
        this.pickQuest(quests.quests.isEmpty() ? null : quests.quests.values().iterator().next(), true);
        Dispatcher.sendToServer(new PacketRequestFactions());
    }

    private void cancelQuest() {
        Label label = (Label)this.questList.getCurrentFirst();
        if (label != null) {
            Dispatcher.sendToServer(new PacketQuestAction(((Quest)label.value).getId(), QuestStatus.CANCELED));
            int index = this.questList.getIndex();
            this.questList.remove((Object)label);
            this.questList.setIndex(Math.max(index - 1, 0));
            label = (Label)this.questList.getCurrentFirst();
            this.pickQuest(label == null ? null : (Quest)label.value, true);
        }
    }

    public void fillFactions(Map<String, Faction> factions, Map<String, Double> states) {
        this.factions.removeAll();
        for (String key : factions.keySet()) {
            this.factions.add((IGuiElement)new GuiFactionCard(Minecraft.func_71410_x(), factions.get(key), states.get(key)));
        }
        this.root.resize();
    }

    private void pickQuest(Quest value, boolean select) {
        this.questArea.removeAll();
        this.questArea.setVisible(value != null);
        this.cancel.setVisible(value != null);
        if (value != null) {
            GuiQuestCard.fillQuest((GuiElement)this.questArea, value, false, true);
            this.cancel.setEnabled(value.cancelable);
            this.root.resize();
            this.root.resize();
        }
        if (!select) {
            return;
        }
        this.questList.setCurrentScroll(null);
        for (Label label : this.questList.getList()) {
            if (label.value != value) continue;
            this.questList.setCurrentScroll((Object)label);
            break;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"mappet.gui.panels.factions", (Object[])new Object[0]), (float)(this.factions.area.x + 10), 10.0f, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"mappet.gui.panels.quests", (Object[])new Object[0]), (float)(this.quests.area.x + 4), 10.0f, 0xFFFFFF);
        GuiDraw.drawVerticalGradientRect((int)this.questArea.area.x, (int)this.questArea.area.y(0.75f), (int)this.questArea.area.ex(), (int)this.questArea.area.ey(), (int)0, (int)0x44000000);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

