/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.conditions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.conditions.Condition;
import mchorse.mappet.api.conditions.blocks.AbstractConditionBlock;
import mchorse.mappet.api.conditions.blocks.ConditionConditionBlock;
import mchorse.mappet.api.conditions.blocks.DialogueConditionBlock;
import mchorse.mappet.api.conditions.blocks.EntityConditionBlock;
import mchorse.mappet.api.conditions.blocks.ExpressionConditionBlock;
import mchorse.mappet.api.conditions.blocks.FactionConditionBlock;
import mchorse.mappet.api.conditions.blocks.ItemConditionBlock;
import mchorse.mappet.api.conditions.blocks.MorphConditionBlock;
import mchorse.mappet.api.conditions.blocks.QuestConditionBlock;
import mchorse.mappet.api.conditions.blocks.StateConditionBlock;
import mchorse.mappet.api.conditions.blocks.WorldTimeConditionBlock;
import mchorse.mappet.client.gui.conditions.blocks.GuiAbstractConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiConditionConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiDialogueConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiEntityConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiExpressionConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiFactionConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiItemConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiMorphConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiQuestConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiStateConditionBlockPanel;
import mchorse.mappet.client.gui.conditions.blocks.GuiWorldTimeConditionBlockPanel;
import mchorse.mappet.client.gui.utils.GuiMappetUtils;
import mchorse.mappet.client.gui.utils.overlays.GuiEditorOverlayPanel;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public class GuiConditionOverlayPanel
extends GuiEditorOverlayPanel<AbstractConditionBlock> {
    public static final Map<Class<? extends AbstractConditionBlock>, Class<? extends GuiAbstractConditionBlockPanel<? extends AbstractConditionBlock>>> PANELS = new HashMap<Class<? extends AbstractConditionBlock>, Class<? extends GuiAbstractConditionBlockPanel<? extends AbstractConditionBlock>>>();
    private Condition condition;

    public GuiConditionOverlayPanel(Minecraft mc, Condition condition) {
        super(mc, IKey.lang((String)"mappet.gui.conditions.title"));
        this.condition = condition;
        this.list.sorting().setList(condition.blocks);
        this.list.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc).shadow();
            menu.action(Icons.ADD, IKey.lang((String)"mappet.gui.conditions.context.add"), () -> {
                GuiSimpleContextMenu adds = new GuiSimpleContextMenu(this.mc).shadow();
                for (String key : CommonProxy.getConditionBlocks().getKeys()) {
                    IKey label = IKey.format((String)"mappet.gui.conditions.context.add_condition", (Object[])new Object[]{IKey.lang((String)("mappet.gui.condition_types." + key))});
                    int color = CommonProxy.getConditionBlocks().getColor(key);
                    adds.action(Icons.ADD, label, () -> this.addBlock(key), color);
                }
                GuiBase.getCurrent().replaceContextMenu((GuiContextMenu)adds);
            });
            if (!this.list.isDeselected()) {
                menu.action(Icons.COPY, IKey.lang((String)"mappet.gui.conditions.context.copy"), this::copyCondition);
            }
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j());
                if (tag.func_74767_n("_ConditionCopy")) {
                    menu.action(Icons.PASTE, IKey.lang((String)"mappet.gui.conditions.context.paste"), () -> this.pasteCondition(tag));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.list.isDeselected()) {
                menu.action(Icons.REMOVE, IKey.lang((String)"mappet.gui.conditions.context.remove"), this::removeItem, 0xFF0033);
            }
            return menu;
        });
        this.pickItem(this.condition.blocks.isEmpty() ? null : this.condition.blocks.get(0), true);
    }

    @Override
    protected GuiListElement<AbstractConditionBlock> createList(Minecraft mc) {
        return new GuiAbstractBlockListElement(mc, l -> this.pickItem(l.get(0), false));
    }

    private void addBlock(String type) {
        AbstractConditionBlock block = CommonProxy.getConditionBlocks().create(type);
        this.condition.blocks.add(block);
        this.pickItem(block, true);
        this.list.update();
    }

    private void copyCondition() {
        AbstractConditionBlock block = (AbstractConditionBlock)this.list.getCurrentFirst();
        NBTTagCompound tag = block.serializeNBT();
        tag.func_74757_a("_ConditionCopy", true);
        tag.func_74778_a("Type", CommonProxy.getConditionBlocks().getType(block));
        GuiScreen.func_146275_d((String)tag.toString());
    }

    private void pasteCondition(NBTTagCompound tag) {
        AbstractConditionBlock block = CommonProxy.getConditionBlocks().create(tag.func_74779_i("Type"));
        block.deserializeNBT(tag);
        this.condition.blocks.add(block);
        this.list.update();
        this.pickItem(block, true);
    }

    @Override
    protected void fillData(AbstractConditionBlock block) {
        this.editor.removeAll();
        try {
            this.editor.add((IGuiElement)((GuiAbstractConditionBlockPanel)((Object)PANELS.get(block.getClass()).getConstructors()[0].newInstance(new Object[]{this.mc, this, block}))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void draw(GuiContext context) {
        super.draw(context);
        if (this.condition.blocks.isEmpty()) {
            GuiMappetUtils.drawRightClickHere(context, this.list.area);
        }
    }

    static {
        PANELS.put(QuestConditionBlock.class, GuiQuestConditionBlockPanel.class);
        PANELS.put(StateConditionBlock.class, GuiStateConditionBlockPanel.class);
        PANELS.put(DialogueConditionBlock.class, GuiDialogueConditionBlockPanel.class);
        PANELS.put(FactionConditionBlock.class, GuiFactionConditionBlockPanel.class);
        PANELS.put(ItemConditionBlock.class, GuiItemConditionBlockPanel.class);
        PANELS.put(WorldTimeConditionBlock.class, GuiWorldTimeConditionBlockPanel.class);
        PANELS.put(EntityConditionBlock.class, GuiEntityConditionBlockPanel.class);
        PANELS.put(ConditionConditionBlock.class, GuiConditionConditionBlockPanel.class);
        PANELS.put(MorphConditionBlock.class, GuiMorphConditionBlockPanel.class);
        PANELS.put(ExpressionConditionBlock.class, GuiExpressionConditionBlockPanel.class);
    }

    public static class GuiAbstractBlockListElement
    extends GuiListElement<AbstractConditionBlock> {
        public GuiAbstractBlockListElement(Minecraft mc, Consumer<List<AbstractConditionBlock>> callback) {
            super(mc, callback);
            this.postDraw = true;
            this.scroll.scrollItemSize = 24;
        }

        public void drawPostListElement(AbstractConditionBlock element, int i, int x, int y, boolean hover, boolean selected) {
            if (i > 0) {
                String label = I18n.func_135052_a((String)(element.or ? "mappet.gui.conditions.label_or" : "mappet.gui.conditions.label_and"), (Object[])new Object[0]);
                int w = this.font.func_78256_a(label);
                GuiDraw.drawTextBackground((FontRenderer)this.font, (String)label, (int)this.scroll.mx(w), (int)(y -= 4), (int)0xFFFFFF, (int)-2013265920, (int)2);
            }
        }

        protected void drawElementPart(AbstractConditionBlock element, int i, int x, int y, boolean hover, boolean selected) {
            int color = CommonProxy.getConditionBlocks().getColor(element);
            Gui.func_73734_a((int)x, (int)y, (int)(x + 4), (int)(y + this.scroll.scrollItemSize), (int)(-16777216 + color));
            GuiDraw.drawHorizontalGradientRect((int)(x + 4), (int)y, (int)(x + 24), (int)(y + this.scroll.scrollItemSize), (int)(0x44000000 + color), (int)color);
            if (element.not) {
                GuiDraw.drawTextBackground((FontRenderer)this.font, (String)"!", (int)(x + 6), (int)(y + this.scroll.scrollItemSize / 2 - this.font.field_78288_b / 2), (int)0xFFFFFF, (int)-2013265920, (int)2);
            }
            super.drawElementPart((Object)element, i, x + 4, y, hover, selected);
        }

        protected String elementToString(AbstractConditionBlock element) {
            return element.stringify();
        }
    }
}

