/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.npc;

import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.api.utils.ContentType;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.npc.GuiNpcPanel;
import mchorse.mappet.client.gui.npc.utils.GuiNpcDrops;
import mchorse.mappet.client.gui.utils.GuiMappetUtils;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import net.minecraft.client.Minecraft;

public class GuiNpcGeneralPanel
extends GuiNpcPanel {
    public GuiButtonElement faction;
    public GuiNestedEdit morph;
    public GuiNpcDrops drops;
    public GuiTrackpadElement xp;
    public GuiToggleElement hasNoGravity;
    public GuiTrackpadElement shadowSize;

    public GuiNpcGeneralPanel(Minecraft mc) {
        super(mc);
        this.faction = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.overlays.faction"), t -> this.openFactions());
        this.morph = new GuiNestedEdit(mc, this::openMorphMenu);
        this.drops = new GuiNpcDrops(mc);
        this.xp = new GuiTrackpadElement(mc, v -> this.state.xp.set((Number)v.intValue()));
        this.hasNoGravity = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.npcs.general.has_no_gravity"), b -> this.state.hasNoGravity.set((Object)b.isToggled()));
        this.shadowSize = new GuiTrackpadElement(mc, v -> this.state.shadowSize.set((Number)Float.valueOf(v.floatValue())));
        this.xp.limit(0.0).integer();
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.general.faction")), this.faction});
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.general.morph")).marginTop(12), this.morph});
        this.add((IGuiElement)this.drops.marginTop(12));
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.general.xp")).marginTop(12), this.xp});
        this.add((IGuiElement)this.hasNoGravity.marginTop(12));
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.general.shadow_size")).marginTop(12), this.shadowSize});
    }

    private void openFactions() {
        GuiMappetUtils.openPicker(ContentType.FACTION, (String)this.state.faction.get(), name -> this.state.faction.set(name));
    }

    private void openMorphMenu(boolean editing) {
        GuiMappetDashboard.get(this.mc).openMorphMenu(this.morph.getParentContainer(), editing, this.state.morph, this::setMorph);
    }

    private void setMorph(AbstractMorph morph) {
        this.state.morph = MorphUtils.copy((AbstractMorph)morph);
        this.morph.setMorph(morph);
    }

    @Override
    public void set(NpcState state) {
        super.set(state);
        this.morph.setMorph(state.morph);
        this.drops.set(state.drops);
        this.xp.setValue((double)((Integer)state.xp.get()).intValue());
        this.hasNoGravity.toggled(((Boolean)state.hasNoGravity.get()).booleanValue());
        this.shadowSize.setValue((double)((Float)state.shadowSize.get()).floatValue());
    }
}

