/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.npc;

import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.client.gui.npc.GuiNpcPanel;
import mchorse.mappet.client.gui.utils.GuiBlockPosAndTriggerList;
import mchorse.mappet.client.gui.utils.GuiBlockPosElement;
import mchorse.mappet.client.gui.utils.GuiBlockPosList;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiNpcMovementPanel
extends GuiNpcPanel {
    public GuiTrackpadElement speed;
    public GuiTrackpadElement flightMaxHeight;
    public GuiTrackpadElement flightMinHeight;
    public GuiTrackpadElement jumpPower;
    public GuiBlockPosList steeringOffset;
    public GuiToggleElement canSwim;
    public GuiToggleElement immovable;
    public GuiToggleElement hasPost;
    public GuiBlockPosElement postPosition;
    public GuiTrackpadElement postRadius;
    public GuiToggleElement patrolCirculate;
    public GuiBlockPosAndTriggerList patrol;
    public GuiTextElement follow;

    public GuiNpcMovementPanel(Minecraft mc) {
        super(mc);
        this.speed = new GuiTrackpadElement(mc, v -> this.state.speed.set((Number)Float.valueOf(v.floatValue())));
        this.flightMaxHeight = new GuiTrackpadElement(mc, v -> this.state.flightMaxHeight.set((Number)v));
        this.flightMinHeight = new GuiTrackpadElement(mc, v -> this.state.flightMinHeight.set((Number)v));
        this.jumpPower = new GuiTrackpadElement(mc, v -> this.state.jumpPower.set((Number)Float.valueOf(v.floatValue())));
        this.steeringOffset = new GuiBlockPosList(mc);
        GuiLabel steeringOffsetLabel = Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.movement.steering_offset")).background();
        GuiIconElement addSteeringOffset = new GuiIconElement(mc, Icons.ADD, b -> this.steeringOffset.addBlockPos());
        addSteeringOffset.flex().relative((GuiElement)steeringOffsetLabel).xy(1.0f, 0.5f).w(10).anchor(1.0f, 0.5f);
        steeringOffsetLabel.add((IGuiElement)addSteeringOffset);
        this.canSwim = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.npcs.movement.can_swim"), b -> this.state.canSwim.set((Object)b.isToggled()));
        this.immovable = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.npcs.movement.immovable"), b -> this.state.immovable.set((Object)b.isToggled()));
        this.hasPost = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.npcs.movement.post"), b -> this.state.hasPost.set((Object)b.isToggled()));
        this.postPosition = new GuiBlockPosElement(mc, pos -> {
            this.state.postPosition = pos;
        });
        this.postRadius = new GuiTrackpadElement(mc, v -> this.state.postRadius.set((Number)Float.valueOf(v.floatValue())));
        this.patrolCirculate = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.npcs.movement.patrol_circulate"), b -> this.state.patrolCirculate.set((Object)b.isToggled()));
        this.patrol = new GuiBlockPosAndTriggerList(mc);
        this.follow = new GuiTextElement(mc, 1000, t -> this.state.follow.set(t));
        GuiLabel patrolLabel = Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.movement.patrol_points")).background();
        GuiIconElement addPatrol = new GuiIconElement(mc, Icons.ADD, b -> this.patrol.addBlockPos());
        addPatrol.flex().relative((GuiElement)patrolLabel).xy(1.0f, 0.5f).w(10).anchor(1.0f, 0.5f);
        patrolLabel.add((IGuiElement)addPatrol);
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.movement.speed")), this.speed});
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.movement.flight_max_height")), this.flightMaxHeight});
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.movement.flight_min_height")), this.flightMinHeight});
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.movement.jump_power")), this.jumpPower});
        this.add(new IGuiElement[]{this.canSwim, this.immovable});
        this.add(new IGuiElement[]{this.hasPost.marginTop(12), this.postPosition, this.postRadius});
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"mappet.gui.npcs.movement.follow")).marginTop(12), this.follow});
        GuiElement patrolArea = new GuiElement(mc);
        patrolArea.add(new IGuiElement[]{patrolLabel, this.patrol, this.patrolCirculate});
        patrolArea.flex().column(5).vertical().stretch();
        this.add((IGuiElement)patrolArea.marginTop(12));
        GuiElement steeringOffsetArea = new GuiElement(mc);
        steeringOffsetArea.add(new IGuiElement[]{steeringOffsetLabel, this.steeringOffset});
        steeringOffsetArea.flex().column(5).vertical().stretch();
        this.add((IGuiElement)steeringOffsetArea.marginTop(12));
    }

    @Override
    public void set(NpcState state) {
        super.set(state);
        this.speed.setValue((double)((Float)state.speed.get()).floatValue());
        this.flightMaxHeight.setValue(((Double)state.flightMaxHeight.get()).doubleValue());
        this.flightMinHeight.setValue(((Double)state.flightMinHeight.get()).doubleValue());
        this.jumpPower.setValue((double)((Float)state.jumpPower.get()).floatValue());
        this.steeringOffset.set(state.steeringOffset);
        this.canSwim.toggled(((Boolean)state.canSwim.get()).booleanValue());
        this.immovable.toggled(((Boolean)state.immovable.get()).booleanValue());
        this.hasPost.toggled(((Boolean)state.hasPost.get()).booleanValue());
        this.postPosition.set(state.postPosition);
        this.postRadius.setValue((double)((Float)state.postRadius.get()).floatValue());
        this.patrolCirculate.toggled(((Boolean)state.patrolCirculate.get()).booleanValue());
        this.patrol.set(state.patrol, state.patrolTriggers);
        this.follow.setText((String)state.follow.get());
    }
}

