/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import mchorse.mappet.api.npcs.Npc;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.api.utils.ContentType;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.npc.GuiNpcEditor;
import mchorse.mappet.client.gui.npc.utils.GuiNpcStatesOverlayPanel;
import mchorse.mappet.client.gui.panels.GuiMappetDashboardPanel;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiNpcPanel
extends GuiMappetDashboardPanel<Npc> {
    public static final IKey EMPTY = IKey.lang((String)"mappet.gui.npcs.info.empty");
    public GuiIconElement states;
    public GuiNpcEditor npcEditor;
    private String state = "";

    public GuiNpcPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, dashboard);
        this.namesList.setFileIcon(Icons.PROCESSOR);
        this.states = new GuiIconElement(mc, Icons.MORE, b -> this.openNpcStates());
        this.states.flex().relative((GuiElement)this);
        this.npcEditor = new GuiNpcEditor(mc, false);
        this.npcEditor.flex().relative((GuiElement)this).y(10).wTo((IResizer)this.editor.area, 1.0f).h(1.0f, -10);
        this.npcEditor.setVisible(false);
        this.editor.add(new IGuiElement[]{this.npcEditor, this.states});
        this.fill(null);
    }

    private void openNpcStates() {
        GuiNpcStatesOverlayPanel overlay = new GuiNpcStatesOverlayPanel(this.mc, (Npc)this.data, this::pickState);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)overlay.set(this.state), 0.4f, 0.6f);
    }

    private void pickState(String name) {
        this.state = name;
        NpcState state = ((Npc)this.data).states.get(name);
        this.npcEditor.setVisible(state != null);
        if (state != null) {
            this.npcEditor.set(state);
        }
        this.resize();
    }

    @Override
    public void fill(Npc data, boolean allowed) {
        super.fill(data, allowed);
        this.npcEditor.setVisible(data != null);
        this.states.setVisible(data != null);
        if (data != null) {
            String key = "default";
            if (!data.states.containsKey(key) && !data.states.isEmpty()) {
                key = data.states.keySet().iterator().next();
            }
            this.pickState(key);
        }
    }

    @Override
    public ContentType getType() {
        return ContentType.NPC;
    }

    @Override
    public String getTitle() {
        return "mappet.gui.panels.npcs";
    }

    @Override
    public void draw(GuiContext context) {
        if (this.npcEditor.isVisible()) {
            GuiDraw.drawTextBackground((FontRenderer)this.font, (String)this.state, (int)(this.states.area.ex() + 3), (int)(this.states.area.my() - 4), (int)0xFFFFFF, (int)-2013265920, (int)2);
        } else {
            int w = (this.editor.area.ex() - this.area.x) / 2;
            int x = (this.area.x + this.editor.area.ex()) / 2 - w / 2;
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)EMPTY.get(), (int)x, (int)this.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
        super.draw(context);
    }
}

