/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.scripts.Script;
import mchorse.mappet.api.utils.ContentType;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.panels.GuiMappetDashboardPanel;
import mchorse.mappet.client.gui.scripts.GuiDocumentationOverlayPanel;
import mchorse.mappet.client.gui.scripts.GuiLibrariesOverlayPanel;
import mchorse.mappet.client.gui.scripts.GuiRepl;
import mchorse.mappet.client.gui.scripts.GuiTextEditor;
import mchorse.mappet.client.gui.scripts.highlights.Highlighters;
import mchorse.mappet.client.gui.scripts.utils.GuiItemStackOverlayPanel;
import mchorse.mappet.client.gui.scripts.utils.GuiMorphOverlayPanel;
import mchorse.mappet.client.gui.scripts.utils.GuiScriptSoundOverlayPanel;
import mchorse.mappet.client.gui.scripts.utils.SyntaxStyle;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocClass;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocMethod;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlay;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mappet.utils.MPIcons;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.input.color.GuiColorPicker;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.RayTracing;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.util.MMIcons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public class GuiScriptPanel
extends GuiMappetDashboardPanel<Script> {
    public GuiIconElement toggleRepl;
    public GuiIconElement docs;
    public GuiIconElement libraries;
    public GuiIconElement run;
    public GuiTextEditor code;
    public GuiRepl repl;
    public GuiToggleElement unique;
    public GuiToggleElement globalLibrary;
    private Map<String, Integer> lastScrolls = new HashMap<String, Integer>();

    public static GuiContextMenu createScriptContextMenu(Minecraft mc, GuiTextEditor editor) {
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(mc).action(Icons.POSE, IKey.lang((String)"mappet.gui.scripts.context.paste_morph"), () -> GuiScriptPanel.openMorphPicker(editor)).action(MMIcons.ITEM, IKey.lang((String)"mappet.gui.scripts.context.paste_item"), () -> GuiScriptPanel.openItemPicker(editor)).action(Icons.BLOCK, IKey.lang((String)"mappet.gui.scripts.context.paste_player_pos"), () -> GuiScriptPanel.pastePlayerPosition(editor)).action(Icons.LIMB, IKey.lang((String)"mappet.gui.scripts.context.paste_player_rot"), () -> GuiScriptPanel.pastePlayerRotation(editor)).action(Icons.VISIBLE, IKey.lang((String)"mappet.gui.scripts.context.paste_block_pos"), () -> GuiScriptPanel.pasteBlockPosition(editor)).action(Icons.SOUND, IKey.lang((String)"mappet.gui.scripts.context.paste_sound"), () -> GuiScriptPanel.openSoundPicker(editor)).action(Icons.MATERIAL, IKey.lang((String)"mappet.gui.scripts.context.paste_colorRGB"), () -> GuiScriptPanel.openColorPicker(editor, false)).action(Icons.MATERIAL, IKey.lang((String)"mappet.gui.scripts.context.paste_colorARGB"), () -> GuiScriptPanel.openColorPicker(editor, true));
        if (editor.isSelected()) {
            GuiScriptPanel.setupDocumentation(editor, menu);
        }
        return menu;
    }

    private static void setupDocumentation(GuiTextEditor editor, GuiSimpleContextMenu menu) {
        String text = editor.getSelectedText().replaceAll("[^\\w\\d_]+", "");
        List<DocClass> searched = GuiDocumentationOverlayPanel.search(text);
        if (searched.isEmpty()) {
            return;
        }
        for (DocClass docClass : searched) {
            menu.action(Icons.SEARCH, IKey.format((String)"mappet.gui.scripts.context.docs", (Object[])new Object[]{docClass.getName()}), () -> GuiScriptPanel.searchDocumentation(editor, docClass.getMethod(text)));
        }
    }

    private static void openMorphPicker(GuiTextEditor editor) {
        AbstractMorph morph = null;
        NBTTagCompound tag = GuiScriptPanel.readFromSelected(editor);
        if (editor.isSelected()) {
            morph = MorphManager.INSTANCE.morphFromNBT(tag);
        }
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)new GuiMorphOverlayPanel(Minecraft.func_71410_x(), IKey.lang((String)"mappet.gui.scripts.overlay.title_morph"), editor, morph), 240, 54);
    }

    private static void openItemPicker(GuiTextEditor editor) {
        ItemStack stack = ItemStack.field_190927_a;
        NBTTagCompound tag = GuiScriptPanel.readFromSelected(editor);
        if (tag != null) {
            stack = new ItemStack(tag);
        }
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)new GuiItemStackOverlayPanel(Minecraft.func_71410_x(), IKey.lang((String)"mappet.gui.scripts.overlay.title_item"), editor, stack), 240, 54);
    }

    private static NBTTagCompound readFromSelected(GuiTextEditor editor) {
        if (editor.isSelected()) {
            NBTTagCompound tag = null;
            try {
                tag = JsonToNBT.func_180713_a((String)("{String:" + editor.getSelectedText() + "}"));
                tag = JsonToNBT.func_180713_a((String)tag.func_74779_i("String"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tag;
        }
        return null;
    }

    private static void pastePlayerPosition(GuiTextEditor editor) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        DecimalFormat format = GuiTrackpadElement.FORMAT;
        editor.pasteText(format.format(player.field_70165_t) + ", " + format.format(player.field_70163_u) + ", " + format.format(player.field_70161_v));
    }

    private static void pastePlayerRotation(GuiTextEditor editor) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        DecimalFormat format = GuiTrackpadElement.FORMAT;
        editor.pasteText(format.format(player.field_70125_A) + ",  " + format.format(player.field_70177_z) + ", " + format.format(player.func_70079_am()));
    }

    private static void pasteBlockPosition(GuiTextEditor editor) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        DecimalFormat format = GuiTrackpadElement.FORMAT;
        RayTraceResult result = RayTracing.rayTrace((Entity)player, (double)128.0, (float)0.0f);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = result.func_178782_a();
            editor.pasteText(format.format(pos.func_177958_n()) + ", " + format.format(pos.func_177956_o()) + ", " + format.format(pos.func_177952_p()));
        }
    }

    private static void openSoundPicker(GuiTextEditor editor) {
        GuiScriptSoundOverlayPanel panel = new GuiScriptSoundOverlayPanel(Minecraft.func_71410_x(), editor);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)panel, 0.5f, 0.9f);
    }

    private static void openColorPicker(final GuiTextEditor editor, final boolean isArgb) {
        final ValueInt valueInt = isArgb ? new ValueInt("color_picker", 0).colorAlpha() : new ValueInt("color_picker", 0).color();
        GuiOverlayPanel panel = new GuiOverlayPanel(Minecraft.func_71410_x(), IKey.lang((String)("mappet.gui.scripts.context.paste_color" + (isArgb ? "A" : "") + "RGB"))){

            @Override
            public void onClose() {
                super.onClose();
                editor.pasteText(new Color(((Integer)valueInt.get()).intValue(), isArgb).stringify(isArgb).replaceAll("#", "0x"));
            }
        };
        GuiColorPicker picker = new GuiColorPicker(Minecraft.func_71410_x(), color -> valueInt.set((Number)color));
        if (isArgb) {
            picker.editAlpha();
        }
        picker.markIgnored().flex().relative(panel.content).xy(0.5f, 0.5f).anchor(0.5f, 0.5f).wh(200, 85).bounds(panel.content, 2);
        panel.content.add((IGuiElement)picker);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), panel, 200, 160);
    }

    private static void searchDocumentation(GuiTextEditor editor, DocMethod method) {
        GuiDocumentationOverlayPanel panel = new GuiDocumentationOverlayPanel(Minecraft.func_71410_x(), method);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)panel, 0.9f, 0.9f);
    }

    public GuiScriptPanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, dashboard);
        this.namesList.setFileIcon(MMIcons.PROPERTIES);
        this.toggleRepl = new GuiIconElement(mc, MPIcons.REPL, b -> this.setRepl(!this.repl.isVisible()));
        this.toggleRepl.tooltip(IKey.lang((String)"mappet.gui.scripts.repl.title"), Direction.LEFT);
        this.docs = new GuiIconElement(mc, Icons.HELP, this::openDocumentation);
        this.docs.tooltip(IKey.lang((String)"mappet.gui.scripts.documentation.title"), Direction.LEFT);
        this.libraries = new GuiIconElement(mc, Icons.MORE, this::openLibraries);
        this.libraries.tooltip(IKey.lang((String)"mappet.gui.scripts.libraries.tooltip"), Direction.LEFT);
        this.run = new GuiIconElement(mc, Icons.PLAY, this::runScript);
        this.run.tooltip(IKey.lang((String)"mappet.gui.scripts.run"), Direction.LEFT);
        this.iconBar.add(new IGuiElement[]{this.toggleRepl, this.docs, this.libraries, this.run});
        this.code = new GuiTextEditor(mc, null);
        this.code.background().context(() -> GuiScriptPanel.createScriptContextMenu(this.mc, this.code));
        this.code.keys().ignoreFocus().register(IKey.lang((String)"mappet.gui.scripts.keys.word_wrap"), 25, this::toggleWordWrap).category(GuiMappetDashboardPanel.KEYS_CATEGORY).held(new int[]{29});
        this.repl = new GuiRepl(mc);
        this.unique = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.npcs.meta.unique"), b -> {
            ((Script)this.data).unique = b.isToggled();
        });
        this.globalLibrary = new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.scripts.global_library"), b -> {
            ((Script)this.data).globalLibrary = b.isToggled();
        });
        GuiElement sideBarToggles = Elements.column((Minecraft)mc, (int)2, (GuiElement[])new GuiElement[]{this.unique, this.globalLibrary});
        sideBarToggles.flex().relative(this.sidebar).x(10).y(1.0f, -10).w(1.0f, -20).anchorY(1.0f);
        this.names.flex().hTo((IResizer)sideBarToggles.area, -5);
        this.code.flex().relative(this.editor).wh(1.0f, 1.0f);
        this.repl.flex().relative(this.editor).wh(1.0f, 1.0f);
        this.editor.add((IGuiElement)this.code);
        this.sidebar.prepend((IGuiElement)sideBarToggles);
        this.add((IGuiElement)this.repl);
        this.fill(null);
    }

    private void toggleWordWrap() {
        this.code.wrap();
        this.code.recalculate();
        this.code.horizontal.clamp();
        this.code.vertical.clamp();
    }

    private void openDocumentation(GuiIconElement element) {
        GuiDocumentationOverlayPanel panel = new GuiDocumentationOverlayPanel(this.mc);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)panel, 0.9f, 0.9f);
    }

    private void runScript(GuiIconElement element) {
        EntityPlayerSP player = this.mc.field_71439_g;
        this.save();
        this.save = false;
        player.func_71165_d("/mp script exec " + player.func_110124_au().toString() + " " + ((Script)this.data).getId());
    }

    private void openLibraries(GuiIconElement element) {
        GuiLibrariesOverlayPanel overlay = new GuiLibrariesOverlayPanel(this.mc, (Script)this.data);
        GuiOverlay.addOverlay(GuiBase.getCurrent(), (GuiOverlayPanel)overlay, 0.4f, 0.6f);
    }

    @Override
    protected void addNewData(String name, Script data) {
        if (name.lastIndexOf(".") == -1) {
            name = name + ".js";
        }
        super.addNewData(name, data);
    }

    @Override
    protected void dupeData(String name) {
        if (name.lastIndexOf(".") == -1) {
            name = name + ".js";
        }
        super.dupeData(name);
    }

    @Override
    public ContentType getType() {
        return ContentType.SCRIPTS;
    }

    @Override
    public String getTitle() {
        return "mappet.gui.panels.scripts";
    }

    @Override
    protected void fillDefaultData(Script data) {
        super.fillDefaultData(data);
        data.code = "function main(c)\n{\n    // Code...\n    var s = c.getSubject();\n}";
    }

    @Override
    public void fill(Script data, boolean allowed) {
        String last = this.data == null ? null : ((Script)this.data).getId();
        super.fill(data, allowed);
        this.editor.setVisible(data != null);
        this.unique.setVisible(data != null && allowed);
        this.globalLibrary.setVisible(data != null && allowed);
        this.updateButtons();
        if (data != null) {
            this.code.setHighlighter(Highlighters.readHighlighter(Highlighters.highlighterFile(data.getScriptExtension())));
            this.updateStyle();
            if (!this.code.getText().equals(data.code)) {
                Integer scroll;
                if (last != null) {
                    this.lastScrolls.put(last, this.code.vertical.scroll);
                }
                this.code.setText(data.code);
                this.setRepl(false);
                if (last != null && (scroll = this.lastScrolls.get(data.getId())) != null) {
                    this.code.vertical.scroll = scroll;
                }
            }
            this.unique.toggled(data.unique);
            this.globalLibrary.toggled(data.globalLibrary);
        }
    }

    private void updateButtons() {
        this.run.setVisible(this.data != null && this.allowed && this.code.isVisible());
        this.libraries.setVisible(this.data != null && this.allowed && this.code.isVisible());
    }

    private void setRepl(boolean showRepl) {
        this.repl.setVisible(showRepl);
        this.code.setVisible(!showRepl);
        this.updateButtons();
    }

    @Override
    protected void preSave() {
        ((Script)this.data).code = this.code.getText();
    }

    @Override
    public void open() {
        super.open();
        this.updateStyle();
    }

    public void updateStyle() {
        SyntaxStyle style = Mappet.scriptEditorSyntaxStyle.get();
        if (this.code.getHighlighter().getStyle() != style) {
            this.code.getHighlighter().setStyle(style);
            this.code.resetHighlight();
            this.repl.repl.getHighlighter().setStyle(style);
            this.repl.repl.resetHighlight();
        }
    }

    public Script getData() {
        return (Script)this.data;
    }
}

