/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.quests;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.dialogues.DialogueFragment;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.Quests;
import mchorse.mappet.api.quests.objectives.AbstractObjective;
import mchorse.mappet.api.quests.rewards.IReward;
import mchorse.mappet.api.quests.rewards.ItemStackReward;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.quests.PacketQuestVisibility;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestCard {
    public static void fillQuest(GuiElement element, Quest quest, boolean forceReward, boolean displayVisibility) {
        Minecraft mc = Minecraft.func_71410_x();
        Quests quests = Character.get((EntityPlayer)mc.field_71439_g).getQuests();
        Quest playerQuest = quests.getByName(quest.getId());
        Quest characterQuest = playerQuest == null ? quest : playerQuest;
        String title = characterQuest.getProcessedTitle();
        if (mc.field_71439_g.func_184812_l_()) {
            title = title + TextFormatting.GRAY + " (" + characterQuest.getId() + ")";
        }
        element.add((IGuiElement)Elements.label((IKey)IKey.str((String)title)).background().marginBottom(12));
        if (displayVisibility) {
            element.add((IGuiElement)new GuiToggleElement(mc, IKey.lang((String)"mappet.gui.quests.visible"), characterQuest.visible, b -> {
                Dispatcher.sendToServer(new PacketQuestVisibility(characterQuest.getId(), characterQuest, b.isToggled()));
                characterQuest.visible = b.isToggled();
            }));
        }
        element.add((IGuiElement)new GuiText(mc).text(DialogueFragment.process(characterQuest.story)).color(0xAAAAAA, true).marginBottom(12));
        element.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"mappet.gui.quests.objectives.title")));
        StringBuilder objectives = new StringBuilder();
        for (AbstractObjective objective : characterQuest.objectives) {
            objectives.append(IKey.str((String)("- " + objective.stringify((EntityPlayer)mc.field_71439_g))).toString() + "\n");
        }
        element.add((IGuiElement)new GuiText(mc).text(objectives.toString()).color(0xAAAAAA, true));
        if (!((Boolean)Mappet.questsPreviewRewards.get()).booleanValue() && !forceReward) {
            return;
        }
        if (characterQuest.rewards.isEmpty()) {
            return;
        }
        element.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"mappet.gui.quests.rewards.title")).marginTop(12));
        for (IReward reward : characterQuest.rewards) {
            if (!(reward instanceof ItemStackReward)) continue;
            ItemStackReward stack = (ItemStackReward)reward;
            GuiElement stacks = new GuiElement(mc);
            stacks.flex().h(24).grid(5).resizes(false).width(24);
            for (ItemStack item : stack.stacks) {
                GuiSlotElement slot = new GuiSlotElement(mc, 0, null);
                slot.setEnabled(false);
                slot.setStack(item);
                slot.drawDisabled = false;
                stacks.add((IGuiElement)slot);
            }
            element.add((IGuiElement)stacks);
        }
    }
}

