/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.highlights;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mchorse.mappet.ClientProxy;
import mchorse.mappet.client.gui.scripts.utils.SyntaxHighlighter;
import mchorse.mappet.utils.NBTToJsonLike;

public class Highlighters {
    private static File editorHighlighters;
    private static SyntaxHighlighter defaultHighlighter;

    public static List<File> highlighters() {
        ArrayList<File> highlighters = new ArrayList<File>();
        File[] files = editorHighlighters.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                highlighters.add(file);
            }
        }
        return highlighters;
    }

    public static File highlighterFile(String name) {
        if (!name.endsWith(".json")) {
            name = name + ".json";
        }
        return new File(editorHighlighters, name);
    }

    public static SyntaxHighlighter readHighlighter(File file) {
        try {
            return new SyntaxHighlighter(NBTToJsonLike.read(file));
        }
        catch (Exception exception) {
            return defaultHighlighter;
        }
    }

    public static void writeHighlighter(File file, SyntaxHighlighter highlighter) {
        try {
            NBTToJsonLike.write(file, highlighter.toNBT());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initiate() {
        if (editorHighlighters != null) {
            return;
        }
        editorHighlighters = new File(ClientProxy.configFolder, "highlights");
        editorHighlighters.mkdirs();
        File js = new File(editorHighlighters, "js.json");
        File kts = new File(editorHighlighters, "kts.json");
        if (!js.isFile()) {
            SyntaxHighlighter jsHighlighter = new SyntaxHighlighter();
            jsHighlighter.operators = ImmutableSet.of((Object)"+", (Object)"-", (Object)"=", (Object)"/", (Object)"*", (Object)"<", (Object[])new String[]{">", "~", "&", "|", "!"});
            jsHighlighter.primaryKeywords = ImmutableSet.of((Object)"break", (Object)"continue", (Object)"switch", (Object)"case", (Object)"default", (Object)"try", (Object[])new String[]{"catch", "delete", "do", "while", "else", "finally", "if", "else", "for", "each", "in", "instanceof", "new", "throw", "typeof", "with", "yield", "return"});
            jsHighlighter.secondaryKeywords = ImmutableSet.of((Object)"const", (Object)"function", (Object)"var", (Object)"let", (Object)"prototype", (Object)"Math", (Object[])new String[]{"JSON", "mappet"});
            jsHighlighter.special = ImmutableSet.of((Object)"this", (Object)"arguments");
            jsHighlighter.typeKeywords = ImmutableSet.of((Object)"true", (Object)"false", (Object)"null", (Object)"undefined");
            jsHighlighter.functionName = Pattern.compile("[\\w_][\\d\\w_]*", 2);
            Highlighters.writeHighlighter(js, jsHighlighter);
            defaultHighlighter = jsHighlighter;
        } else {
            defaultHighlighter = Highlighters.readHighlighter(Highlighters.highlighterFile("js.json"));
        }
        if (!kts.isFile()) {
            SyntaxHighlighter ktsHighlighter = new SyntaxHighlighter();
            ktsHighlighter.operators = ImmutableSet.of((Object)"+", (Object)"-", (Object)"=", (Object)"/", (Object)"*", (Object)"<", (Object[])new String[]{">", "~", "&", "|", "!", "..", "->"});
            ktsHighlighter.primaryKeywords = ImmutableSet.of((Object)"break", (Object)"continue", (Object)"switch", (Object)"case", (Object)"try", (Object)"catch", (Object[])new String[]{"delete", "do", "while", "else", "finally", "if", "else", "for", "is", "as", "in", "instanceof", "new", "throw", "typeof", "with", "yield", "when", "return", "by", "constructor", "delegate", "dynamic", "field", "get", "set", "init", "value", "where", "actual", "annotation", "companion", "field", "external", "infix", "inline", "inner", "internal", "open", "operator", "out", "override", "suspend", "vararg"});
            ktsHighlighter.secondaryKeywords = ImmutableSet.of((Object)"abstract", (Object)"extends", (Object)"final", (Object)"implements", (Object)"interface", (Object)"super", (Object[])new String[]{"throws", "data", "class", "fun", "var", "val", "import", "Java", "JSON", "mappet"});
            ktsHighlighter.special = ImmutableSet.of((Object)"this", (Object)"it");
            ktsHighlighter.typeKeywords = ImmutableSet.of((Object)"true", (Object)"false", (Object)"null", (Object)"undefined", (Object)"enum");
            ktsHighlighter.functionName = Pattern.compile("[\\w_][\\d\\w_]*", 2);
            Highlighters.writeHighlighter(kts, ktsHighlighter);
        }
    }
}

