/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.scriptedItem;

import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.client.gui.scripts.scriptedItem.GuiFormattedTextElement;
import mchorse.mappet.client.gui.triggers.GuiTriggerElement;
import mchorse.mappet.client.gui.utils.text.GuiText;
import mchorse.mappet.common.ScriptedItemProps;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.items.PacketScriptedItemInfo;
import mchorse.mappet.utils.NBTUtils;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.list.GuiLabelListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class GuiScriptedItemScreen
extends GuiBase {
    public GuiFormattedTextElement title;
    public GuiElement lore;
    public GuiIconElement addLore;
    public GuiScrollElement editor;
    public GuiLabelListElement<String> triggers;
    public GuiTriggerElement trigger;
    private String lastTrigger = "interact_with_air";
    private final ItemStack stack;
    private final ScriptedItemProps props;

    public GuiScriptedItemScreen(Minecraft mc, ItemStack stack) {
        this.stack = stack;
        this.props = NBTUtils.getScriptedItemProps(stack);
        GuiLabel triggersLabel = Elements.label((IKey)IKey.lang((String)"mappet.gui.scripted_item.title")).anchor(0.0f, 0.5f).background();
        GuiLabel titleLabel = Elements.label((IKey)IKey.lang((String)"mappet.gui.scripted_item.item_title")).anchor(0.0f, 0.5f).background();
        GuiLabel loreLabel = Elements.label((IKey)IKey.lang((String)"mappet.gui.scripted_item.item_lore")).anchor(0.0f, 0.5f).background();
        this.title = new GuiFormattedTextElement(mc, arg_0 -> ((ItemStack)stack).func_151001_c(arg_0));
        this.title.flex().relative((IResizer)this.viewport).x(10).w(0.5f, -20).y(35).h(32);
        this.lore = Elements.column((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[0]);
        this.lore.flex().relative((GuiElement)loreLabel).y(1.0f, 8).w(1.0f).hTo((IResizer)this.viewport, 1.0f, -10);
        this.addLore = new GuiIconElement(mc, Icons.ADD, b -> this.addLore(mc, ""));
        this.addLore.flex().relative((GuiElement)loreLabel).x(1.0f, 3).y(-3).anchorX(1.0f);
        this.addLore.tooltip(IKey.lang((String)"mappet.gui.scripted_item.item_lore_add"));
        this.editor = new GuiScrollElement(mc);
        this.editor.flex().relative((IResizer)this.viewport).x(0.5f).y(281).w(0.5f).h(1.0f, -311).column(5).scroll().stretch().padding(10);
        this.triggers = new GuiLabelListElement(mc, l -> this.fillTrigger(mc, (Label<String>)((Label)l.get(0)), false));
        this.triggers.background().flex().relative((IResizer)this.viewport).x(0.5f, 10).y(35).w(0.5f, -20).h(246);
        this.trigger = new GuiTriggerElement(mc).onClose(this::updateCurrentTrigger);
        this.trigger.flex().relative((IResizer)this.viewport).x(1.0f, -10).y(1.0f, -10).wh(120, 20).anchor(1.0f, 1.0f);
        triggersLabel.flex().relative((IResizer)this.viewport).x(0.5f, 10).y(10).wh(120, 20);
        titleLabel.flex().relative((IResizer)this.viewport).x(10).y(10).wh(120, 20);
        loreLabel.flex().relative((GuiElement)this.title).y(1.0f, 25).w(1.0f).h(20);
        this.fill(mc);
        this.root.add((IGuiElement)this.title);
        this.root.add(new IGuiElement[]{this.triggers, this.editor, this.trigger, triggersLabel, titleLabel, loreLabel, this.lore, this.addLore});
    }

    private void addLore(Minecraft mc, String lore) {
        GuiFormattedTextElement textElement = new GuiFormattedTextElement(mc, null);
        textElement.text.setText(lore);
        textElement.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.field_146297_k);
            menu.action(Icons.REMOVE, IKey.lang((String)"mappet.gui.scripted_item.item_lore_remove"), () -> {
                textElement.removeFromParent();
                this.lore.resize();
            });
            return menu;
        });
        textElement.flex().h(32);
        this.lore.add((IGuiElement)textElement);
        this.lore.resize();
    }

    private void fillTrigger(Minecraft mc, Label<String> trigger, boolean select) {
        this.editor.removeAll();
        this.editor.add((IGuiElement)new GuiText(mc).text(IKey.lang((String)("mappet.gui.scripted_item." + (String)trigger.value))));
        this.editor.add((IGuiElement)new GuiText(mc).text(IKey.lang((String)("mappet.gui.scripted_item.descriptions." + (String)trigger.value))));
        this.trigger.set(this.props.registered.get(trigger.value));
        if (select) {
            this.triggers.setCurrentScroll(trigger);
        }
        this.lastTrigger = (String)trigger.value;
        this.editor.resize();
    }

    private void updateCurrentTrigger() {
        Trigger trigger = this.props.registered.get(this.lastTrigger);
        ((Label)this.triggers.getCurrentFirst()).title = this.createTooltip(this.lastTrigger, trigger);
    }

    public IKey createTooltip(String key, Trigger trigger) {
        IKey title = IKey.lang((String)("mappet.gui.scripted_item." + key));
        if (trigger.blocks.isEmpty()) {
            return title;
        }
        IKey count = IKey.str((String)(" \u00a77(\u00a76" + trigger.blocks.size() + "\u00a77)\u00a7r"));
        return IKey.comp((IKey[])new IKey[]{title, count});
    }

    public void fill(Minecraft mc) {
        this.triggers.clear();
        for (String key : this.props.registered.keySet()) {
            this.triggers.add(this.createTooltip(key, this.props.registered.get(key)), (Object)key);
        }
        this.triggers.sort();
        this.triggers.setCurrentValue((Object)this.lastTrigger);
        this.fillTrigger(mc, (Label<String>)((Label)this.triggers.getCurrentFirst()), true);
        this.triggers.resize();
        this.title.text.setText(this.stack.func_82833_r());
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null && tag.func_150297_b("display", 10) && tag.func_74775_l("display").func_150297_b("Lore", 9)) {
            NBTTagList lore = tag.func_74775_l("display").func_150295_c("Lore", 8);
            for (int i = 0; i < lore.func_74745_c(); ++i) {
                this.addLore(mc, lore.func_150307_f(i));
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void closeScreen() {
        super.closeScreen();
        this.props.pickedUp = false;
        NBTTagList lore = new NBTTagList();
        for (GuiFormattedTextElement element : this.lore.getChildren(GuiFormattedTextElement.class)) {
            String text = element.text.getText();
            if (text.isEmpty()) continue;
            lore.func_74742_a((NBTBase)new NBTTagString(text));
        }
        this.stack.func_190925_c("display").func_74782_a("Lore", (NBTBase)lore);
        if (this.title.text.getText().trim().isEmpty()) {
            this.stack.func_190925_c("display").func_82580_o("Name");
        }
        Dispatcher.sendToServer(new PacketScriptedItemInfo(this.props.toNBT(), this.stack.func_77978_p(), 0));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

