/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.themes;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.ClientProxy;
import mchorse.mappet.client.gui.scripts.utils.SyntaxStyle;
import mchorse.mappet.utils.NBTToJsonLike;
import mchorse.mclib.client.gui.utils.GuiUtils;

public class Themes {
    private static File editorThemes;

    public static void open() {
        GuiUtils.openWebLink((URI)editorThemes.toURI());
    }

    public static List<File> themes() {
        ArrayList<File> themes = new ArrayList<File>();
        File[] files = editorThemes.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                themes.add(file);
            }
        }
        return themes;
    }

    public static File themeFile(String name) {
        if (!name.endsWith(".json")) {
            name = name + ".json";
        }
        return new File(editorThemes, name);
    }

    public static SyntaxStyle readTheme(File file) {
        try {
            return new SyntaxStyle(NBTToJsonLike.read(file));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void writeTheme(File file, SyntaxStyle style) {
        try {
            NBTToJsonLike.write(file, style.toNBT());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initiate() {
        if (editorThemes != null) {
            return;
        }
        editorThemes = new File(ClientProxy.configFolder, "themes");
        editorThemes.mkdirs();
        File monokai = new File(editorThemes, "monokai.json");
        File dracula = new File(editorThemes, "dracula.json");
        if (!monokai.isFile()) {
            Themes.writeTheme(monokai, new SyntaxStyle());
        }
        if (!dracula.isFile()) {
            SyntaxStyle draculaStyle = new SyntaxStyle();
            draculaStyle.title = "Dracula";
            draculaStyle.shadow = true;
            draculaStyle.primary = 13400114;
            draculaStyle.secondary = 9991850;
            draculaStyle.identifier = 16762477;
            draculaStyle.special = 13400114;
            draculaStyle.strings = 6395220;
            draculaStyle.comments = 0x808080;
            draculaStyle.numbers = 6722744;
            draculaStyle.other = 11122630;
            draculaStyle.lineNumbers = 6185315;
            draculaStyle.background = 0x2B2B2B;
            Themes.writeTheme(dracula, draculaStyle);
        }
    }
}

