/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.utils;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.client.gui.scripts.utils.TextSegment;
import mchorse.mappet.client.gui.utils.text.TextLine;
import net.minecraft.client.gui.FontRenderer;

public class HighlightedTextLine
extends TextLine {
    public List<TextSegment> segments;
    public List<List<TextSegment>> wrappedSegments;

    public HighlightedTextLine(String text) {
        super(text);
    }

    public void resetSegments() {
        this.segments = null;
        this.wrappedSegments = null;
    }

    public void setSegments(List<TextSegment> segments) {
        this.segments = segments;
    }

    @Override
    public void resetWrapping() {
        super.resetWrapping();
        this.wrappedSegments = null;
    }

    @Override
    public void calculateWrappedLines(FontRenderer font, int w) {
        List wrappedLines = this.wrappedLines;
        super.calculateWrappedLines(font, w);
        if (wrappedLines != this.wrappedLines) {
            this.resetSegments();
        }
    }

    public void calculateWrappedSegments(FontRenderer font) {
        if (this.wrappedLines == null) {
            this.wrappedSegments = null;
            return;
        }
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        int w = 0;
        int i = 0;
        String line = (String)this.wrappedLines.get(i);
        this.wrappedSegments = new ArrayList<List<TextSegment>>();
        for (TextSegment segment : this.segments) {
            int sw = segment.text.length();
            int total = w + sw;
            while (total > line.length()) {
                int endIndex = line.length() - w;
                TextSegment cutOff = new TextSegment(segment.text.substring(0, endIndex), segment.color, segment.width);
                TextSegment remainder = new TextSegment(segment.text.substring(endIndex), segment.color, segment.width);
                if (!cutOff.text.isEmpty()) {
                    cutOff.width = font.func_78256_a(cutOff.text);
                    segments.add(cutOff);
                }
                this.wrappedSegments.add(segments);
                segments = new ArrayList();
                segment = remainder;
                segment.width = font.func_78256_a(segment.text);
                sw = segment.text.length();
                w = 0;
                if (++i >= this.wrappedLines.size()) break;
                line = (String)this.wrappedLines.get(i);
                if (remainder.text.isEmpty()) break;
                total = w + sw;
            }
            w += sw;
            segments.add(segment);
        }
        if (!segments.isEmpty()) {
            this.wrappedSegments.add(segments);
        }
    }
}

