/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.utils;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.mappet.client.gui.scripts.utils.HighlightedTextLine;
import mchorse.mappet.client.gui.scripts.utils.SyntaxStyle;
import mchorse.mappet.client.gui.scripts.utils.TextSegment;
import mchorse.mappet.utils.NBTUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SyntaxHighlighter {
    private SyntaxStyle style;
    public Set<String> operators;
    public Set<String> primaryKeywords;
    public Set<String> secondaryKeywords;
    public Set<String> special;
    public Set<String> typeKeywords;
    public Pattern functionName;
    private String buffer;
    private char string;
    private int last;

    public SyntaxHighlighter() {
        this.style = new SyntaxStyle();
    }

    public SyntaxHighlighter(NBTTagCompound tag) {
        this.operators = ImmutableSet.copyOf((Object[])NBTUtils.getStringArray(tag.func_150295_c("operators", 8)));
        this.primaryKeywords = ImmutableSet.copyOf((Object[])NBTUtils.getStringArray(tag.func_150295_c("primaryKeywords", 8)));
        this.secondaryKeywords = ImmutableSet.copyOf((Object[])NBTUtils.getStringArray(tag.func_150295_c("secondaryKeywords", 8)));
        this.special = ImmutableSet.copyOf((Object[])NBTUtils.getStringArray(tag.func_150295_c("special", 8)));
        this.typeKeywords = ImmutableSet.copyOf((Object[])NBTUtils.getStringArray(tag.func_150295_c("typeKeywords", 8)));
        this.functionName = Pattern.compile(tag.func_74779_i("functionName"), 2);
        this.style = new SyntaxStyle();
    }

    public SyntaxStyle getStyle() {
        return this.style;
    }

    public void setStyle(SyntaxStyle style) {
        this.style = style == null ? this.style : style;
    }

    public List<TextSegment> parse(FontRenderer font, List<HighlightedTextLine> textLines, String line, int lineIndex) {
        List<TextSegment> prevLine;
        ArrayList<TextSegment> list = new ArrayList<TextSegment>();
        List<TextSegment> list2 = prevLine = lineIndex > 0 ? textLines.get((int)(lineIndex - 1)).segments : null;
        if (prevLine != null && !prevLine.isEmpty()) {
            TextSegment last = prevLine.get(prevLine.size() - 1);
            if (last.color == this.style.comments && !last.text.startsWith("//") && !last.text.trim().endsWith("*/")) {
                list.add(new TextSegment(line, this.style.comments, 0));
                return list;
            }
        }
        this.buffer = "";
        this.string = '\u0000';
        this.last = 0;
        int c = line.length();
        block0: for (int i = 0; i < c; ++i) {
            boolean isString;
            char next;
            char character = line.charAt(i);
            char c2 = next = i < c - 1 ? line.charAt(i + 1) : (char)'\u0000';
            if (character == '\'' || character == '\"') {
                if (this.string == '\u0000') {
                    list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                    this.buffer = "";
                    this.string = character;
                } else if (this.string == character) {
                    char prev;
                    char c3 = prev = i > 0 ? line.charAt(i - 1) : (char)'\u0000';
                    if (prev != '\\') {
                        this.string = '\u0000';
                        this.buffer = this.buffer + character;
                        list.add(new TextSegment(this.buffer, this.style.strings, font.func_78256_a(this.buffer)));
                        this.buffer = "";
                        continue;
                    }
                }
            }
            boolean bl = isString = this.string != '\u0000';
            if (!isString && character == '/' && i < c - 1 && line.charAt(i + 1) == '*') {
                int lastI = i;
                i += 2;
                while (i < c) {
                    character = line.charAt(i);
                    if (character == '*' && i < c - 1 && line.charAt(i + 1) == '/') {
                        String comment = line.substring(lastI, i + 2);
                        list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                        list.add(new TextSegment(comment, this.style.comments, font.func_78256_a(comment)));
                        ++i;
                        this.buffer = "";
                        continue block0;
                    }
                    ++i;
                }
                String comment = line.substring(lastI);
                list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                list.add(new TextSegment(comment, this.style.comments, 0));
                return list;
            }
            if (!isString && character == '/' && i < c - 1 && line.charAt(i + 1) == '/') {
                String comment = line.substring(i);
                list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                list.add(new TextSegment(comment, this.style.comments, 0));
                return list;
            }
            if (!isString && this.operators.contains(String.valueOf(character))) {
                boolean isNumericalMinus;
                boolean bl2 = isNumericalMinus = character == '-' && Character.isDigit(next);
                if (!isNumericalMinus) {
                    String sign = String.valueOf(character);
                    list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                    list.add(new TextSegment(sign, this.style.primary, font.func_78256_a(sign)));
                    this.buffer = "";
                    this.last = i;
                    continue;
                }
            }
            this.buffer = this.buffer + character;
            if (!isString && (next != '\u0000' && !this.isLegalName(next) || i == c - 1)) {
                String keyword;
                if (this.last < i) {
                    boolean predicateForNumbers;
                    char last = line.charAt(this.last);
                    boolean bl3 = predicateForNumbers = (last == '-' || last == '.') && Character.isDigit(line.charAt(this.last + 1));
                    if (!this.isLegalName(last) && !predicateForNumbers) {
                        ++this.last;
                    }
                }
                if (this.primaryKeywords.contains(keyword = line.substring(this.last, i + 1))) {
                    this.pushKeyword(list, keyword, this.style.primary, i, font);
                } else if (this.special.contains(keyword)) {
                    this.pushKeyword(list, keyword, this.style.special, i, font);
                } else if (this.secondaryKeywords.contains(keyword) || this.isFunctionCall(list, keyword, next)) {
                    this.pushKeyword(list, keyword, this.style.secondary, i, font);
                } else if (this.isNumberOrConstant(keyword)) {
                    this.pushKeyword(list, keyword, this.style.numbers, i, font);
                } else if (this.isIdentifier(list)) {
                    this.pushKeyword(list, keyword, this.style.identifier, i, font);
                }
            }
            if (this.isLegalName(character)) continue;
            this.last = i;
        }
        if (!this.buffer.trim().isEmpty()) {
            list.add(new TextSegment(this.buffer, this.style.other, 0));
        }
        return list;
    }

    private boolean isLegalName(char character) {
        return Character.isLetterOrDigit(character) || character == '_';
    }

    private void pushKeyword(List<TextSegment> list, String keyword, int color, int i, FontRenderer font) {
        if (this.buffer.length() > keyword.length()) {
            String other = this.buffer.substring(0, this.buffer.length() - keyword.length());
            list.add(new TextSegment(other, this.style.other, font.func_78256_a(other)));
        }
        list.add(new TextSegment(keyword, color, font.func_78256_a(keyword)));
        this.buffer = "";
        this.last = i + 1;
    }

    private boolean isFunctionCall(List<TextSegment> list, String keyword, char next) {
        if (!list.isEmpty()) {
            TextSegment previous = list.get(list.size() - 1);
            boolean bufferIsKeyword = this.buffer.trim().equals(keyword);
            if (previous.color == this.style.strings) {
                return false;
            }
            if (bufferIsKeyword && previous.text.equals("function")) {
                return false;
            }
            if (bufferIsKeyword && previous.color != this.style.other) {
                return false;
            }
            if (previous.text.trim().equals(keyword.trim())) {
                return false;
            }
        }
        Matcher matcher = this.functionName.matcher(keyword);
        boolean matches = matcher.matches();
        return next == '(' && matches;
    }

    private boolean isNumberOrConstant(String keyword) {
        if (this.typeKeywords.contains(keyword)) {
            return true;
        }
        try {
            Double.parseDouble(keyword);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            int length = keyword.trim().length();
            if (keyword.startsWith("0x") && length >= 3 && length <= 10) {
                try {
                    Long.parseLong(keyword.substring(2), 16);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private boolean isIdentifier(List<TextSegment> list) {
        if (!list.isEmpty()) {
            TextSegment previous = list.get(list.size() - 1);
            if (previous.text.trim().equals("function") && previous.color == this.getStyle().secondary) {
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound toNBT() {
        return this.toNBT(new NBTTagCompound());
    }

    public NBTTagCompound toNBT(NBTTagCompound tag) {
        NBTTagList tagListOperators = new NBTTagList();
        NBTUtils.writeStringList(tagListOperators, this.operators);
        tag.func_74782_a("operators", (NBTBase)tagListOperators);
        NBTTagList tagListPrimaryKeywords = new NBTTagList();
        NBTUtils.writeStringList(tagListPrimaryKeywords, this.primaryKeywords);
        tag.func_74782_a("primaryKeywords", (NBTBase)tagListPrimaryKeywords);
        NBTTagList tagListSecondaryKeywords = new NBTTagList();
        NBTUtils.writeStringList(tagListSecondaryKeywords, this.secondaryKeywords);
        tag.func_74782_a("secondaryKeywords", (NBTBase)tagListSecondaryKeywords);
        NBTTagList tagListSpecial = new NBTTagList();
        NBTUtils.writeStringList(tagListSpecial, this.special);
        tag.func_74782_a("special", (NBTBase)tagListSpecial);
        NBTTagList tagListTypeKeywords = new NBTTagList();
        NBTUtils.writeStringList(tagListTypeKeywords, this.typeKeywords);
        tag.func_74782_a("typeKeywords", (NBTBase)tagListTypeKeywords);
        tag.func_74778_a("functionName", this.functionName.toString());
        return tag;
    }
}

