/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class GuiStringFolderList
extends GuiStringListElement {
    private List<String> hierarchy = new ArrayList<String>();
    private String path = "";
    private Icon fileIcon = Icons.FILE;

    public GuiStringFolderList(Minecraft mc, Consumer<List<String>> callback) {
        super(mc, callback);
        this.callback = l -> this.fileCallback(callback, (List<String>)l);
    }

    private void fileCallback(Consumer<List<String>> callback, List<String> strings) {
        String path = strings.get(0);
        if (path.endsWith("/")) {
            String newPath;
            if (path.equals("../")) {
                int index = this.path.lastIndexOf(47);
                newPath = index == -1 ? "" : this.path.substring(0, index);
            } else {
                path = path.substring(0, path.length() - 1);
                newPath = this.getPath(path);
            }
            this.goTo(newPath);
        } else {
            strings.clear();
            strings.add(this.getPath(path));
            callback.accept(strings);
        }
    }

    public void setFileIcon(Icon icon) {
        this.fileIcon = icon;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(String name) {
        if (this.path.isEmpty()) {
            return name;
        }
        return this.path + "/" + name;
    }

    public void fill(Collection<String> hierarchy) {
        this.hierarchy.clear();
        this.hierarchy.addAll(hierarchy);
        this.goTo("");
    }

    private void goTo(String path) {
        this.path = path;
        this.filter("");
        this.setIndex(-1);
        this.updateStrings();
    }

    private void updateStrings() {
        HashSet<String> files = new HashSet<String>();
        if (!this.path.isEmpty()) {
            files.add("../");
        }
        for (String path : this.hierarchy) {
            if (this.path.isEmpty()) {
                int i = path.indexOf(47);
                if (i < 0) {
                    files.add(path);
                    continue;
                }
                files.add(path.substring(0, i + 1));
                continue;
            }
            if (!path.startsWith(this.path + '/') || path.indexOf(47) <= 0) continue;
            String newPath = path.substring(this.path.length() + 1);
            int index = newPath.indexOf(47);
            if (index >= 0) {
                newPath = newPath.substring(0, index + 1);
            }
            if (newPath.equals("")) continue;
            files.add(newPath);
        }
        this.list.clear();
        this.list.addAll(files);
        this.sort();
        this.update();
    }

    public boolean hasInHierarchy(String path) {
        return this.hierarchy.contains(path);
    }

    public void addFile(String path) {
        String filename = this.getFilename(path);
        if (filename != null) {
            this.hierarchy.add(path);
            this.add(filename);
            this.sort();
            this.setCurrentFile(path);
        }
    }

    public void removeFile(String path) {
        String filename = this.getFilename(path);
        if (filename != null && this.hasInHierarchy(path)) {
            this.hierarchy.remove(path);
            this.remove(filename);
            this.setIndex(-1);
        }
    }

    private String getFilename(String path) {
        String filename;
        int lastIndex = path.lastIndexOf(47);
        if (this.path.isEmpty() && lastIndex < 0) {
            return path;
        }
        if (path.startsWith(this.path) && (filename = path.substring(this.path.length() + 1)).indexOf(47) < 0) {
            return filename;
        }
        return null;
    }

    public void setCurrentFile(String path) {
        if (path == null) {
            return;
        }
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex < 0) {
            this.goTo("");
            this.setCurrentScroll(path);
        } else {
            this.goTo(path.substring(0, lastIndex));
            this.setCurrentScroll(path.substring(lastIndex + 1));
        }
    }

    protected void drawElementPart(String element, int i, int x, int y, boolean hover, boolean selected) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        (element.endsWith("/") ? Icons.FOLDER : this.fileIcon).render(x, y);
        super.drawElementPart((Object)element, i, x + 12, y, hover, selected);
    }

    protected boolean sortElements() {
        this.list.sort((p1, p2) -> {
            int isP2Folder;
            int isP1Folder;
            int n = p1.equals("../") ? Integer.MAX_VALUE : (isP1Folder = p1.endsWith("/") ? 1 : 0);
            int n2 = p2.equals("../") ? Integer.MAX_VALUE : (isP2Folder = p2.endsWith("/") ? 1 : 0);
            if (isP1Folder == isP2Folder) {
                return p1.compareTo((String)p2);
            }
            return isP2Folder - isP1Folder;
        });
        return true;
    }
}

