/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils.overlays;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mchorse.mappet.client.gui.utils.overlays.GuiResourceLocationOverlayPanel;
import mchorse.mappet.utils.Utils;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.keys.LangKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class GuiSoundOverlayPanel
extends GuiResourceLocationOverlayPanel {
    private static Set<ResourceLocation> extraSounds = new HashSet<ResourceLocation>();
    private static long lastUpdate;

    private static Set<ResourceLocation> getSoundEvents() {
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        if (lastUpdate < LangKey.lastTime) {
            extraSounds.clear();
            GuiSoundOverlayPanel.updateSounds("b.a");
            GuiSoundOverlayPanel.updateSounds("mp.sounds");
            lastUpdate = LangKey.lastTime;
        }
        locations.addAll(ForgeRegistries.SOUND_EVENTS.getKeys());
        locations.addAll(extraSounds);
        return locations;
    }

    private static void updateSounds(String rp) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(rp, "sounds.json"));
            JsonElement element = new JsonParser().parse(IOUtils.toString((InputStream)resource.func_110527_b(), (Charset)Utils.getCharset()));
            if (element.isJsonObject()) {
                for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                    extraSounds.add(new ResourceLocation(rp, (String)entry.getKey()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GuiSoundOverlayPanel(Minecraft mc, Consumer<ResourceLocation> callback) {
        super(mc, IKey.lang((String)"mappet.gui.overlays.sounds.main"), GuiSoundOverlayPanel.getSoundEvents(), callback);
        GuiIconElement edit = new GuiIconElement(mc, Icons.SOUND, b -> this.playSound());
        edit.flex().wh(16, 16);
        this.icons.add((IGuiElement)edit);
    }

    private void playSound() {
        if (this.rls.list.getIndex() <= 0) {
            return;
        }
        ResourceLocation location = new ResourceLocation((String)this.rls.list.getCurrentFirst());
        float x = (float)this.mc.field_71439_g.field_70165_t;
        float y = (float)this.mc.field_71439_g.field_70163_u;
        float z = (float)this.mc.field_71439_g.field_70161_v;
        this.mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(location, SoundCategory.MASTER, 1.0f, 1.0f, false, 0, ISound.AttenuationType.LINEAR, x, y, z));
    }
}

