/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.utils.text;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;

public class TextLine {
    public String text;
    public List<String> wrappedLines;

    public TextLine(String text) {
        this.text = text;
    }

    public void set(String text) {
        this.text = text;
    }

    public int getLines() {
        return this.wrappedLines == null ? 1 : this.wrappedLines.size();
    }

    public void resetWrapping() {
        this.wrappedLines = null;
    }

    public void calculateWrappedLines(FontRenderer font, int w) {
        List<String> wrappedLines = this.splitIntoLines(font, w);
        this.wrappedLines = wrappedLines.size() < 2 ? null : wrappedLines;
    }

    private List<String> splitIntoLines(FontRenderer font, int w) {
        int right;
        int increment;
        ArrayList<String> lines = new ArrayList<String>();
        if (font.func_78256_a(this.text) < w) {
            lines.add(this.text);
            return lines;
        }
        int left = 0;
        int c = this.text.length();
        int n = increment = c > 5 ? 3 : 1;
        for (right = 0; right < c; right += increment) {
            String string = this.text.substring(left, right);
            int sw = font.func_78256_a(string);
            if (sw <= w) continue;
            int space = string.lastIndexOf(32, right);
            int diff = right - left - space;
            if (space != -1 && diff < 12) {
                string = this.text.substring(left, right -= diff - 1);
            }
            lines.add(string);
            left = right;
        }
        if (left != right) {
            lines.add(this.text.substring(left, MathHelper.func_76125_a((int)right, (int)0, (int)c)));
        }
        return lines;
    }
}

