/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.renders.tile;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import mchorse.mappet.api.regions.shapes.AbstractShape;
import mchorse.mappet.api.regions.shapes.BoxShape;
import mchorse.mappet.api.regions.shapes.CylinderShape;
import mchorse.mappet.api.regions.shapes.SphereShape;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.renders.tile.TileBaseBlockRenderer;
import mchorse.mappet.tile.TileRegion;
import mchorse.mclib.utils.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileRegionRenderer
extends TileBaseBlockRenderer<TileRegion> {
    public static final float SEGMENTS = 16.0f;
    private static final Color SELECTED = new Color(0.0f, 0.5f, 1.0f, 0.5f);
    private static final Color NOT_SELECTED = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Matrix3d a1 = new Matrix3d();
    private Matrix3d a2 = new Matrix3d();
    private Matrix3d a3 = new Matrix3d();
    private Vector3d vec = new Vector3d();
    private TileRegion selected;

    public TileRegionRenderer() {
        super(new Color(1.0f, 0.098f, 0.72f, 0.5f));
        this.a1.rotY(1.5707963267948966);
        this.a2.rotY(0.7853981633974483);
        this.a3.rotY(-0.7853981633974483);
    }

    private Vector3d rotate(Matrix3d mat, double x, double y, double z) {
        this.vec.set(x, y, z);
        mat.transform((Tuple3d)this.vec);
        return this.vec;
    }

    @Override
    protected Color getBoxColor(TileRegion te) {
        if (te == this.selected) {
            return SELECTED;
        }
        return super.getBoxColor(te);
    }

    @Override
    protected boolean canRender(Minecraft mc, TileRegion te) {
        GuiScreen screen = mc.field_71462_r;
        if (screen instanceof GuiMappetDashboard) {
            GuiMappetDashboard dashboard = (GuiMappetDashboard)screen;
            if (dashboard.panels.view.delegate == dashboard.region) {
                this.selected = dashboard.region.getTile();
                return true;
            }
        }
        this.selected = null;
        return super.canRender(mc, te);
    }

    @Override
    protected void renderMoreDebug(TileRegion te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Color color = te == this.selected ? SELECTED : NOT_SELECTED;
        for (AbstractShape shape : te.region.shapes) {
            this.renderShape(shape, x, y, z, color);
        }
    }

    public void renderShape(AbstractShape shape, double x, double y, double z, Color color) {
        Vector3d diff = new Vector3d(shape.pos.x + 0.5, shape.pos.y + 0.5, shape.pos.z + 0.5);
        diff.x += x;
        diff.y += y;
        diff.z += z;
        if (shape instanceof BoxShape) {
            this.renderBoxShape((BoxShape)shape, diff, color);
        } else if (shape instanceof CylinderShape) {
            this.renderCylinderShape((CylinderShape)shape, diff, color);
        } else if (shape instanceof SphereShape) {
            this.renderSphereShape((SphereShape)shape, diff, color);
        }
    }

    private void renderBoxShape(BoxShape shape, Vector3d diff, Color color) {
        RenderGlobal.func_189694_a((double)(diff.x - shape.size.x), (double)(diff.y - shape.size.y), (double)(diff.z - shape.size.z), (double)(diff.x + shape.size.x), (double)(diff.y + shape.size.y), (double)(diff.z + shape.size.z), (float)color.r, (float)color.g, (float)color.b, (float)1.0f);
    }

    private void renderCylinderShape(CylinderShape shape, Vector3d diff, Color color) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)1.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        int i = 0;
        while ((float)i < 16.0f) {
            double a1 = (double)((float)i / 16.0f) * Math.PI * 2.0;
            double a2 = (double)((float)(i + 1) / 16.0f) * Math.PI * 2.0;
            buffer.func_181662_b(diff.x + Math.cos(a1) * shape.horizontal, diff.y + shape.vertical, diff.z + Math.sin(a1) * shape.horizontal).func_181675_d();
            buffer.func_181662_b(diff.x + Math.cos(a2) * shape.horizontal, diff.y + shape.vertical, diff.z + Math.sin(a2) * shape.horizontal).func_181675_d();
            buffer.func_181662_b(diff.x + Math.cos(a1) * shape.horizontal, diff.y + shape.vertical, diff.z + Math.sin(a1) * shape.horizontal).func_181675_d();
            buffer.func_181662_b(diff.x + Math.cos(a1) * shape.horizontal, diff.y - shape.vertical, diff.z + Math.sin(a1) * shape.horizontal).func_181675_d();
            if ((float)i == 15.0f) {
                buffer.func_181662_b(diff.x + Math.cos(a2) * shape.horizontal, diff.y + shape.vertical, diff.z + Math.sin(a2) * shape.horizontal).func_181675_d();
                buffer.func_181662_b(diff.x + Math.cos(a2) * shape.horizontal, diff.y - shape.vertical, diff.z + Math.sin(a2) * shape.horizontal).func_181675_d();
            }
            buffer.func_181662_b(diff.x + Math.cos(a1) * shape.horizontal, diff.y - shape.vertical, diff.z + Math.sin(a1) * shape.horizontal).func_181675_d();
            buffer.func_181662_b(diff.x + Math.cos(a2) * shape.horizontal, diff.y - shape.vertical, diff.z + Math.sin(a2) * shape.horizontal).func_181675_d();
            ++i;
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderSphereShape(SphereShape shape, Vector3d diff, Color color) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)1.0f);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        Matrix3f matA = new Matrix3f();
        matA.rotY(1.5707964f);
        int i = 0;
        while ((float)i < 16.0f) {
            double a1 = (double)((float)i / 16.0f) * Math.PI * 2.0;
            double a2 = (double)((float)(i + 1) / 16.0f) * Math.PI * 2.0;
            buffer.func_181662_b(diff.x + Math.cos(a1) * shape.horizontal, diff.y, diff.z + Math.sin(a1) * shape.horizontal).func_181675_d();
            buffer.func_181662_b(diff.x + Math.cos(a2) * shape.horizontal, diff.y, diff.z + Math.sin(a2) * shape.horizontal).func_181675_d();
            buffer.func_181662_b(diff.x + Math.cos(a1) * shape.horizontal, diff.y + Math.sin(a1) * shape.vertical, diff.z).func_181675_d();
            buffer.func_181662_b(diff.x + Math.cos(a2) * shape.horizontal, diff.y + Math.sin(a2) * shape.vertical, diff.z).func_181675_d();
            Vector3d vector = this.rotate(this.a1, Math.cos(a1) * shape.horizontal, Math.sin(a1) * shape.vertical, 0.0);
            buffer.func_181662_b(diff.x + vector.x, diff.y + vector.y, diff.z + vector.z).func_181675_d();
            vector = this.rotate(this.a1, Math.cos(a2) * shape.horizontal, Math.sin(a2) * shape.vertical, 0.0);
            buffer.func_181662_b(diff.x + vector.x, diff.y + vector.y, diff.z + vector.z).func_181675_d();
            vector = this.rotate(this.a2, Math.cos(a1) * shape.horizontal, Math.sin(a1) * shape.vertical, 0.0);
            buffer.func_181662_b(diff.x + vector.x, diff.y + vector.y, diff.z + vector.z).func_181675_d();
            vector = this.rotate(this.a2, Math.cos(a2) * shape.horizontal, Math.sin(a2) * shape.vertical, 0.0);
            buffer.func_181662_b(diff.x + vector.x, diff.y + vector.y, diff.z + vector.z).func_181675_d();
            vector = this.rotate(this.a3, Math.cos(a1) * shape.horizontal, Math.sin(a1) * shape.vertical, 0.0);
            buffer.func_181662_b(diff.x + vector.x, diff.y + vector.y, diff.z + vector.z).func_181675_d();
            vector = this.rotate(this.a3, Math.cos(a2) * shape.horizontal, Math.sin(a2) * shape.vertical, 0.0);
            buffer.func_181662_b(diff.x + vector.x, diff.y + vector.y, diff.z + vector.z).func_181675_d();
            ++i;
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public boolean isGlobalRenderer(TileRegion te) {
        return true;
    }
}

