/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import mchorse.mappet.api.triggers.Trigger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ScriptedItemProps {
    private HashMap<Trigger, String> initialState = new HashMap();
    public HashMap<String, Trigger> registered = new LinkedHashMap<String, Trigger>();
    public Trigger interactWithAir = new Trigger();
    public Trigger interactWithEntity = new Trigger();
    public Trigger interactWithBlock = new Trigger();
    public Trigger attackEntity = new Trigger();
    public Trigger breakBlock = new Trigger();
    public Trigger placeBlock = new Trigger();
    public Trigger hitBlock = new Trigger();
    public Trigger onHolderTick = new Trigger();
    public Trigger pickup = new Trigger();
    public Trigger toss = new Trigger();
    public Trigger firstPickup = new Trigger();
    public boolean pickedUp = false;
    public Trigger startedHolding = new Trigger();
    public Trigger stoppedHolding = new Trigger();
    public Trigger useStart = new Trigger();
    public Trigger useStop = new Trigger();
    public Trigger onUseTick = new Trigger();
    public Trigger finishedUsing = new Trigger();

    public ScriptedItemProps() {
        this.reset();
    }

    public ScriptedItemProps(NBTTagCompound tag) {
        this.reset();
        this.fromNBT(tag);
    }

    public void reset() {
        this.interactWithAir = this.register("interact_with_air", new Trigger());
        this.interactWithEntity = this.register("interact_with_entity", new Trigger());
        this.interactWithBlock = this.register("interact_with_block", new Trigger());
        this.attackEntity = this.register("attack_entity", new Trigger());
        this.breakBlock = this.register("break_block", new Trigger());
        this.placeBlock = this.register("place_block", new Trigger());
        this.hitBlock = this.register("hit_block", new Trigger());
        this.onHolderTick = this.register("on_holder_tick", new Trigger());
        this.pickup = this.register("pickup", new Trigger());
        this.toss = this.register("toss", new Trigger());
        this.firstPickup = this.register("first_pickup", new Trigger());
        this.pickedUp = false;
        this.startedHolding = this.register("started_holding", new Trigger());
        this.stoppedHolding = this.register("stopped_holding", new Trigger());
        this.useStart = this.register("use_start", new Trigger());
        this.useStop = this.register("use_stop", new Trigger());
        this.onUseTick = this.register("on_use_tick", new Trigger());
        this.finishedUsing = this.register("finished_using", new Trigger());
    }

    public Trigger register(String key, Trigger trigger) {
        this.registered.put(key, trigger);
        return trigger;
    }

    public void fromNBT(NBTTagCompound tag) {
        this.reset();
        if (tag.func_74764_b("InteractWithAir")) {
            this.interactWithAir.deserializeNBT(tag.func_74775_l("InteractWithAir"));
        }
        if (tag.func_74764_b("InteractWithEntity")) {
            this.interactWithEntity.deserializeNBT(tag.func_74775_l("InteractWithEntity"));
        }
        if (tag.func_74764_b("InteractWithBlock")) {
            this.interactWithBlock.deserializeNBT(tag.func_74775_l("InteractWithBlock"));
        }
        if (tag.func_74764_b("AttackEntity")) {
            this.attackEntity.deserializeNBT(tag.func_74775_l("AttackEntity"));
        }
        if (tag.func_74764_b("BreakBlock")) {
            this.breakBlock.deserializeNBT(tag.func_74775_l("BreakBlock"));
        }
        if (tag.func_74764_b("PlaceBlock")) {
            this.placeBlock.deserializeNBT(tag.func_74775_l("PlaceBlock"));
        }
        if (tag.func_74764_b("HitBlock")) {
            this.hitBlock.deserializeNBT(tag.func_74775_l("HitBlock"));
        }
        if (tag.func_74764_b("OnHolderTick")) {
            this.onHolderTick.deserializeNBT(tag.func_74775_l("OnHolderTick"));
        }
        if (tag.func_74764_b("Pickup")) {
            this.pickup.deserializeNBT(tag.func_74775_l("Pickup"));
        }
        if (tag.func_74764_b("Toss")) {
            this.toss.deserializeNBT(tag.func_74775_l("Toss"));
        }
        if (tag.func_74764_b("FirstPickup")) {
            this.firstPickup.deserializeNBT(tag.func_74775_l("FirstPickup"));
        }
        if (tag.func_74764_b("PickedUp")) {
            this.pickedUp = tag.func_74767_n("PickedUp");
        }
        if (tag.func_74764_b("StartedHolding")) {
            this.startedHolding.deserializeNBT(tag.func_74775_l("StartedHolding"));
        }
        if (tag.func_74764_b("StoppedHolding")) {
            this.stoppedHolding.deserializeNBT(tag.func_74775_l("StoppedHolding"));
        }
        if (tag.func_74764_b("UseStart")) {
            this.useStart.deserializeNBT(tag.func_74775_l("UseStart"));
        }
        if (tag.func_74764_b("UseStop")) {
            this.useStop.deserializeNBT(tag.func_74775_l("UseStop"));
        }
        if (tag.func_74764_b("OnUseTick")) {
            this.onUseTick.deserializeNBT(tag.func_74775_l("OnUseTick"));
        }
        if (tag.func_74764_b("FinishedUsing")) {
            this.finishedUsing.deserializeNBT(tag.func_74775_l("FinishedUsing"));
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("InteractWithAir", (NBTBase)this.interactWithAir.serializeNBT());
        tag.func_74782_a("InteractWithEntity", (NBTBase)this.interactWithEntity.serializeNBT());
        tag.func_74782_a("InteractWithBlock", (NBTBase)this.interactWithBlock.serializeNBT());
        tag.func_74782_a("AttackEntity", (NBTBase)this.attackEntity.serializeNBT());
        tag.func_74782_a("BreakBlock", (NBTBase)this.breakBlock.serializeNBT());
        tag.func_74782_a("PlaceBlock", (NBTBase)this.placeBlock.serializeNBT());
        tag.func_74782_a("HitBlock", (NBTBase)this.hitBlock.serializeNBT());
        tag.func_74782_a("OnHolderTick", (NBTBase)this.onHolderTick.serializeNBT());
        tag.func_74782_a("Pickup", (NBTBase)this.pickup.serializeNBT());
        tag.func_74782_a("Toss", (NBTBase)this.toss.serializeNBT());
        tag.func_74782_a("FirstPickup", (NBTBase)this.firstPickup.serializeNBT());
        tag.func_74757_a("PickedUp", this.pickedUp);
        tag.func_74782_a("StartedHolding", (NBTBase)this.startedHolding.serializeNBT());
        tag.func_74782_a("StoppedHolding", (NBTBase)this.stoppedHolding.serializeNBT());
        tag.func_74782_a("UseStart", (NBTBase)this.useStart.serializeNBT());
        tag.func_74782_a("UseStop", (NBTBase)this.useStop.serializeNBT());
        tag.func_74782_a("OnUseTick", (NBTBase)this.onUseTick.serializeNBT());
        tag.func_74782_a("FinishedUsing", (NBTBase)this.finishedUsing.serializeNBT());
        return tag;
    }
}

