/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.entities.utils;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.entities.utils.DiedNpcHolder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class MappetNpcRespawnManager
extends WorldSavedData {
    public static final String DATA_NAME = "mappet_RespawnData";
    public final List<DiedNpcHolder> diedNpcHolders = new ArrayList<DiedNpcHolder>();
    public final List<DiedNpcHolder> deleteCache = new ArrayList<DiedNpcHolder>();
    public World world;
    private BlockPos.MutableBlockPos block = new BlockPos.MutableBlockPos();

    public MappetNpcRespawnManager(String mapName) {
        super(mapName);
    }

    public void onTick() {
        for (DiedNpcHolder diedNpcHolder : this.diedNpcHolders) {
            this.block.func_189532_c(diedNpcHolder.posX, diedNpcHolder.posY, diedNpcHolder.posZ);
            if (diedNpcHolder.respawnTime > this.world.func_82737_E() || !this.world.func_175667_e((BlockPos)this.block)) continue;
            this.respawnNpc(diedNpcHolder);
        }
        this.removeSpawnedNpcs();
        this.func_76185_a();
    }

    public void addDiedNpc(EntityNpc npc) {
        long respawnTime = npc.field_70170_p.func_82737_E() + (long)((Integer)npc.getState().respawnDelay.get()).intValue();
        double posX = (Boolean)npc.getState().respawnOnCoordinates.get() != false ? (Double)npc.getState().respawnPosX.get() : npc.field_70165_t;
        double posY = (Boolean)npc.getState().respawnOnCoordinates.get() != false ? (Double)npc.getState().respawnPosY.get() : npc.field_70163_u;
        double posZ = (Boolean)npc.getState().respawnOnCoordinates.get() != false ? (Double)npc.getState().respawnPosZ.get() : npc.field_70161_v;
        this.diedNpcHolders.add(new DiedNpcHolder(npc, respawnTime, posX, posY, posZ));
        this.func_76185_a();
    }

    public void respawnNpc(DiedNpcHolder diedNpcHolder) {
        diedNpcHolder.spawn(this.world);
        this.deleteCache.add(diedNpcHolder);
    }

    public void removeSpawnedNpcs() {
        for (DiedNpcHolder diedNpcHolder : this.deleteCache) {
            this.diedNpcHolders.remove(diedNpcHolder);
        }
        this.clearDeleteCache();
    }

    public void clearDeleteCache() {
        this.deleteCache.clear();
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = nbtTagCompound.func_150295_c("DiedNPCHolders", 10);
        for (NBTBase tag : tagList) {
            NBTTagCompound compound = (NBTTagCompound)tag;
            NBTTagCompound nbt = compound.func_74775_l("NBT");
            String uuid = compound.func_74779_i("UUID");
            long respawnTime = compound.func_74763_f("RespawnTime");
            int worldID = compound.func_74762_e("WorldID");
            double posX = compound.func_74769_h("PosX");
            double posY = compound.func_74769_h("PosY");
            double posZ = compound.func_74769_h("PosZ");
            this.diedNpcHolders.add(new DiedNpcHolder(nbt, uuid, respawnTime, worldID, posX, posY, posZ));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (DiedNpcHolder diedNpcHolder : this.diedNpcHolders) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("NBT", (NBTBase)diedNpcHolder.nbt);
            tag.func_74778_a("UUID", diedNpcHolder.uuid);
            tag.func_74772_a("RespawnTime", diedNpcHolder.respawnTime);
            tag.func_74768_a("WorldID", diedNpcHolder.worldID);
            tag.func_74780_a("PosX", diedNpcHolder.posX);
            tag.func_74780_a("PosY", diedNpcHolder.posY);
            tag.func_74780_a("PosZ", diedNpcHolder.posZ);
            tagList.func_74742_a((NBTBase)tag);
        }
        nbtTagCompound.func_74782_a("DiedNPCHolders", (NBTBase)tagList);
        return nbtTagCompound;
    }

    public static MappetNpcRespawnManager get(World world) {
        MappetNpcRespawnManager data = (MappetNpcRespawnManager)world.func_175693_T().func_75742_a(MappetNpcRespawnManager.class, DATA_NAME);
        if (data == null) {
            data = new MappetNpcRespawnManager(DATA_NAME);
            world.func_175693_T().func_75745_a(DATA_NAME, (WorldSavedData)data);
        }
        data.world = world;
        return data;
    }
}

