/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.events;

import java.util.List;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.scripts.code.entities.ScriptEntityItem;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.common.ScriptedItemProps;
import mchorse.mappet.utils.NBTUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ScriptedItemEventHandler {
    @SubscribeEvent
    public void onScriptedItemRightClick(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer playerIn = event.getEntityPlayer();
        World worldIn = event.getWorld();
        EnumHand handIn = event.getHand();
        if (!worldIn.field_72995_K) {
            ItemStack item = playerIn.func_184586_b(handIn);
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
            if (props == null) {
                return;
            }
            double reachDistance = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
            RayTraceResult rayTraceResult = this.rayTraceEntityAndBlocks(worldIn, playerIn, reachDistance);
            List<Entity> entityList = this.getEntitiesInPlayerReach(worldIn, playerIn, reachDistance);
            this.triggerInteractWithAir(event, props.interactWithAir, rayTraceResult, entityList, playerIn);
        }
    }

    public RayTraceResult rayTraceEntityAndBlocks(World worldIn, EntityPlayer playerIn, double reachDistance) {
        Vec3d eyePosition = playerIn.func_174824_e(1.0f);
        Vec3d lookVec = playerIn.func_70676_i(1.0f);
        Vec3d reachVec = eyePosition.func_178787_e(new Vec3d(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance));
        RayTraceResult blockResult = worldIn.func_147447_a(eyePosition, reachVec, false, false, true);
        RayTraceResult entityResult = null;
        List entities = worldIn.func_72839_b((Entity)playerIn, playerIn.func_174813_aQ().func_72321_a(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance));
        double closestDistance = reachDistance;
        for (Entity entity : entities) {
            double distanceToEntity;
            if (!entity.func_70067_L()) continue;
            float collisionBorderSize = entity.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72321_a((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
            RayTraceResult traceResult = axisalignedbb.func_72327_a(eyePosition, reachVec);
            if (axisalignedbb.func_72318_a(eyePosition)) {
                if (!(closestDistance >= 0.0)) continue;
                entityResult = new RayTraceResult(entity);
                entityResult.field_72307_f = traceResult == null ? eyePosition : traceResult.field_72307_f;
                closestDistance = 0.0;
                continue;
            }
            if (traceResult == null || !((distanceToEntity = eyePosition.func_72438_d(traceResult.field_72307_f)) < closestDistance) && closestDistance != 0.0) continue;
            if (entity.func_184208_bv() == playerIn.func_184208_bv() && !entity.canRiderInteract()) {
                if (closestDistance != 0.0) continue;
                entityResult = traceResult;
                entityResult.field_72307_f = traceResult.field_72307_f;
                continue;
            }
            entityResult = new RayTraceResult(entity);
            entityResult.field_72307_f = traceResult.field_72307_f;
            closestDistance = distanceToEntity;
        }
        return entityResult == null ? blockResult : entityResult;
    }

    @SubscribeEvent
    public void onPlayerWithScriptedItemInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack item;
        ScriptedItemProps props;
        if (!event.getWorld().field_72995_K && (props = NBTUtils.getScriptedItemProps(item = event.getEntityPlayer().func_184586_b(event.getHand()))) != null && props.interactWithEntity != null && !props.interactWithEntity.blocks.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getEntityPlayer(), event.getTarget());
            context.set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
            CommonProxy.eventHandler.trigger((Event)event, props.interactWithEntity, context);
        }
    }

    @SubscribeEvent
    public void onEntityAttackedWithScriptedItem(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack item;
        ScriptedItemProps props;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer && (props = NBTUtils.getScriptedItemProps(item = (player = (EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND))) != null && props.attackEntity != null && !props.attackEntity.blocks.isEmpty()) {
            DamageSource source = event.getSource();
            DataContext context = new DataContext((Entity)event.getEntityLiving(), source.func_76346_g()).set("damage", event.getAmount());
            CommonProxy.eventHandler.trigger((Event)event, props.attackEntity, context);
        }
    }

    @SubscribeEvent
    public void onPlayerWithScriptedItemRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item;
        ScriptedItemProps props;
        if (!event.getWorld().field_72995_K && (props = NBTUtils.getScriptedItemProps(item = event.getEntityPlayer().func_184586_b(event.getHand()))) != null && props.interactWithBlock != null && !props.interactWithBlock.blocks.isEmpty()) {
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            DataContext context = new DataContext((Entity)event.getEntityPlayer()).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
            CommonProxy.eventHandler.trigger((Event)event, props.interactWithBlock, context);
        }
    }

    @SubscribeEvent
    public void onPlayerHoldingScriptedItemTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            for (EnumHand hand : EnumHand.values()) {
                ItemStack item = event.player.func_184586_b(hand);
                ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
                if (props == null || props.onHolderTick == null || props.onHolderTick.blocks.isEmpty()) continue;
                DataContext context = new DataContext((Entity)event.player);
                context.set("hand", hand == EnumHand.MAIN_HAND ? "main" : "off");
                CommonProxy.eventHandler.trigger((Event)event, props.onHolderTick, context);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWithScriptedItemLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack item;
        ScriptedItemProps props;
        if (!event.getWorld().field_72995_K && (props = NBTUtils.getScriptedItemProps(item = event.getEntityPlayer().func_184586_b(event.getHand()))) != null && props.hitBlock != null && !props.hitBlock.blocks.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getEntityPlayer()).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
            CommonProxy.eventHandler.trigger((Event)event, props.hitBlock, context);
        }
    }

    @SubscribeEvent
    public void onPlayerWithScriptedItemPlaceBlock(BlockEvent.PlaceEvent event) {
        if (!event.getWorld().field_72995_K) {
            ScriptedItemProps props;
            EnumHand handIn;
            EntityPlayer player = event.getPlayer();
            ItemStack item = player.func_184586_b(handIn = EnumHand.MAIN_HAND);
            if (item.func_190926_b()) {
                handIn = EnumHand.OFF_HAND;
                item = player.func_184586_b(handIn);
            }
            if ((props = NBTUtils.getScriptedItemProps(item)) != null && props.placeBlock != null && !props.placeBlock.blocks.isEmpty()) {
                IBlockState state = event.getPlacedBlock();
                DataContext context = new DataContext((Entity)player).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", handIn == EnumHand.MAIN_HAND ? "main" : "off");
                CommonProxy.eventHandler.trigger((Event)event, props.placeBlock, context);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPickUpScriptedItem(EntityItemPickupEvent event) {
        if (!event.getItem().field_70170_p.field_72995_K) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack item = event.getItem().func_92059_d();
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
            if (props != null && props.pickup != null && !props.pickup.blocks.isEmpty()) {
                DataContext context = new DataContext((Entity)player);
                context.getValues().put("item", ScriptItemStack.create(event.getItem().func_92059_d()));
                context.getValues().put("entityItem", ScriptEntityItem.create((Entity)event.getItem()));
                CommonProxy.eventHandler.trigger((Event)event, props.pickup, context);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTossScriptedItem(ItemTossEvent event) {
        if (!event.getEntityItem().field_70170_p.field_72995_K) {
            EntityPlayer player = event.getPlayer();
            ItemStack item = event.getEntityItem().func_92059_d();
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
            if (props != null && props.toss != null && !props.toss.blocks.isEmpty()) {
                DataContext context = new DataContext((Entity)player);
                context.getValues().put("item", ScriptItemStack.create(event.getEntityItem().func_92059_d()));
                context.getValues().put("entityItem", ScriptEntityItem.create((Entity)event.getEntityItem()));
                CommonProxy.eventHandler.trigger((Event)event, props.toss, context);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWithScriptedItemBreakBlock(BlockEvent.BreakEvent event) {
        EntityPlayer player;
        ItemStack item;
        ScriptedItemProps props;
        if (!event.getWorld().field_72995_K && (props = NBTUtils.getScriptedItemProps(item = (player = event.getPlayer()).func_184586_b(EnumHand.MAIN_HAND))) != null && props.breakBlock != null && !props.breakBlock.blocks.isEmpty()) {
            IBlockState state = event.getState();
            DataContext context = new DataContext((Entity)player).set("block", state.func_177230_c().getRegistryName().toString()).set("meta", state.func_177230_c().func_176201_c(state)).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p());
            CommonProxy.eventHandler.trigger((Event)event, props.breakBlock, context);
        }
    }

    @SubscribeEvent
    public void onPlayerWithScriptedItemTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            for (ItemStack item : event.player.func_184214_aD()) {
                ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
                if (props == null || props.onHolderTick == null || props.onHolderTick.blocks.isEmpty()) continue;
                DataContext context = new DataContext((Entity)event.player);
                CommonProxy.eventHandler.trigger((Event)event, props.onHolderTick, context);
            }
        }
    }

    private void triggerInteractWithAir(PlayerInteractEvent.RightClickItem event, Trigger interactWithAirTrigger, RayTraceResult rayTraceResult, List<Entity> entityList, EntityPlayer playerIn) {
        if (interactWithAirTrigger != null && !interactWithAirTrigger.blocks.isEmpty() && (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) && entityList.isEmpty()) {
            DataContext context = new DataContext((Entity)playerIn).set("x", event.getPos().func_177958_n()).set("y", event.getPos().func_177956_o()).set("z", event.getPos().func_177952_p()).set("hand", event.getHand() == EnumHand.MAIN_HAND ? "main" : "off");
            CommonProxy.eventHandler.trigger((Event)event, interactWithAirTrigger, context);
        }
    }

    private List<Entity> getEntitiesInPlayerReach(World worldIn, EntityPlayer playerIn, double reachDistance) {
        Vec3d eyePos = playerIn.func_174824_e(1.0f);
        Vec3d lookVec = playerIn.func_70040_Z();
        Vec3d reachVec = eyePos.func_178787_e(new Vec3d(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance));
        AxisAlignedBB playerReach = new AxisAlignedBB(eyePos.field_72450_a, eyePos.field_72448_b, eyePos.field_72449_c, reachVec.field_72450_a, reachVec.field_72448_b, reachVec.field_72449_c);
        List list = worldIn.func_72839_b((Entity)playerIn, playerReach);
        list.removeIf(entity -> !entity.func_70067_L() || !EntitySelectors.field_180132_d.apply(entity));
        list.removeIf(entity -> entity.func_174813_aQ().func_72327_a(eyePos, reachVec) == null);
        return list;
    }

    @SubscribeEvent
    public void onFirstItemPickup(EntityItemPickupEvent event) {
        if (!event.getItem().field_70170_p.field_72995_K) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack itemStack = event.getItem().func_92059_d();
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(itemStack);
            if (props != null && props.pickedUp) {
                return;
            }
            if (props != null && props.firstPickup != null && !props.firstPickup.blocks.isEmpty()) {
                props.pickedUp = true;
                NBTUtils.setScriptedItemProps(itemStack, props);
                DataContext context = new DataContext((Entity)player);
                context.getValues().put("item", ScriptItemStack.create(itemStack));
                context.getValues().put("entityItem", ScriptEntityItem.create((Entity)event.getItem()));
                CommonProxy.eventHandler.trigger((Event)event, props.firstPickup, context);
            }
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        ScriptedItemProps props;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        ItemStack previousItem = event.getFrom();
        ItemStack newItem = event.getTo();
        int slotIndex = event.getSlot().func_188452_c();
        if (previousItem.func_190926_b() && !newItem.func_190926_b()) {
            ScriptedItemProps props2 = NBTUtils.getScriptedItemProps(newItem);
            if (props2 != null && props2.startedHolding != null && !props2.startedHolding.blocks.isEmpty()) {
                DataContext context = new DataContext((Entity)event.getEntityLiving());
                context.getValues().put("item", ScriptItemStack.create(newItem));
                CommonProxy.eventHandler.trigger((Event)event, props2.startedHolding, context);
            }
        } else if (!previousItem.func_190926_b() && newItem.func_190926_b() && (props = NBTUtils.getScriptedItemProps(previousItem)) != null && props.stoppedHolding != null && !props.stoppedHolding.blocks.isEmpty()) {
            DataContext context = new DataContext((Entity)event.getEntityLiving());
            context.getValues().put("item", ScriptItemStack.create(previousItem));
            CommonProxy.eventHandler.trigger((Event)event, props.stoppedHolding, context);
        }
    }

    @SubscribeEvent
    public void onScriptedItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack item = event.getItem();
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
            if (props != null && props.useStart != null && !props.useStart.blocks.isEmpty()) {
                DataContext context = new DataContext((Entity)player);
                context.getValues().put("item", ScriptItemStack.create(item));
                context.getValues().put("duration", event.getDuration());
                CommonProxy.eventHandler.trigger((Event)event, props.useStart, context);
            }
        }
    }

    @SubscribeEvent
    public void onScriptedItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack item = event.getItem();
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
            if (props != null && props.useStop != null && !props.useStop.blocks.isEmpty()) {
                DataContext context = new DataContext((Entity)player);
                context.getValues().put("item", ScriptItemStack.create(item));
                context.getValues().put("duration", event.getDuration());
                CommonProxy.eventHandler.trigger((Event)event, props.useStop, context);
            }
        }
    }

    @SubscribeEvent
    public void onScriptedItemUseTick(LivingEntityUseItemEvent.Tick event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack item = event.getItem();
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
            if (props != null && props.onUseTick != null && !props.onUseTick.blocks.isEmpty()) {
                DataContext context = new DataContext((Entity)player);
                context.getValues().put("item", ScriptItemStack.create(item));
                context.getValues().put("duration", event.getDuration());
                CommonProxy.eventHandler.trigger((Event)event, props.onUseTick, context);
            }
        }
    }

    @SubscribeEvent
    public void onScriptedItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack item = event.getItem();
            ScriptedItemProps props = NBTUtils.getScriptedItemProps(item);
            if (props != null && props.finishedUsing != null && !props.finishedUsing.blocks.isEmpty()) {
                DataContext context = new DataContext((Entity)player);
                context.getValues().put("item", ScriptItemStack.create(item));
                context.getValues().put("duration", event.getDuration());
                CommonProxy.eventHandler.trigger((Event)event, props.finishedUsing, context);
            }
        }
    }
}

