/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.libs.org.reflections.vfs;

import java.net.URL;
import java.util.Iterator;
import java.util.Stack;
import java.util.jar.JarFile;
import mchorse.mappet.libs.org.reflections.vfs.JbossFile;
import mchorse.mappet.libs.org.reflections.vfs.Vfs;
import mchorse.mappet.libs.org.reflections.vfs.ZipDir;
import org.jboss.vfs.VirtualFile;

public class JbossDir
implements Vfs.Dir {
    private final VirtualFile virtualFile;

    private JbossDir(VirtualFile virtualFile) {
        this.virtualFile = virtualFile;
    }

    public static Vfs.Dir createDir(URL url) throws Exception {
        VirtualFile virtualFile = (VirtualFile)url.openConnection().getContent();
        if (virtualFile.isFile()) {
            return new ZipDir(new JarFile(virtualFile.getPhysicalFile()));
        }
        return new JbossDir(virtualFile);
    }

    @Override
    public String getPath() {
        return this.virtualFile.getPathName();
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return () -> new Iterator<Vfs.File>(){
            Vfs.File entry = null;
            final Stack stack = new Stack();
            {
                this.stack.addAll(JbossDir.this.virtualFile.getChildren());
            }

            @Override
            public boolean hasNext() {
                return this.entry != null || (this.entry = this.computeNext()) != null;
            }

            @Override
            public Vfs.File next() {
                Vfs.File next = this.entry;
                this.entry = null;
                return next;
            }

            private Vfs.File computeNext() {
                while (!this.stack.isEmpty()) {
                    VirtualFile file = (VirtualFile)this.stack.pop();
                    if (file.isDirectory()) {
                        this.stack.addAll(file.getChildren());
                        continue;
                    }
                    return new JbossFile(JbossDir.this, file);
                }
                return null;
            }
        };
    }
}

