/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.network.common.blocks;

import io.netty.buffer.ByteBuf;
import mchorse.mappet.blocks.BlockTrigger;
import mchorse.mappet.tile.TileTrigger;
import mchorse.mclib.utils.NBTUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketEditTrigger
implements IMessage {
    public BlockPos pos;
    public NBTTagCompound left = new NBTTagCompound();
    public NBTTagCompound right = new NBTTagCompound();
    public boolean collidable;
    public Vec3d boundingBoxPos1;
    public Vec3d boundingBoxPos2;

    public PacketEditTrigger() {
    }

    public PacketEditTrigger(TileTrigger tile) {
        this(tile.func_174877_v(), tile.leftClick.serializeNBT(), tile.rightClick.serializeNBT(), (Boolean)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b((IProperty)BlockTrigger.COLLIDABLE), new Vec3d(tile.boundingBoxPos1.field_72450_a, tile.boundingBoxPos1.field_72448_b, tile.boundingBoxPos1.field_72449_c), new Vec3d(tile.boundingBoxPos2.field_72450_a, tile.boundingBoxPos2.field_72448_b, tile.boundingBoxPos2.field_72449_c));
    }

    public PacketEditTrigger(BlockPos pos, NBTTagCompound left, NBTTagCompound right, boolean collidable, Vec3d boundingBoxPos1, Vec3d boundingBoxPos2) {
        this.pos = pos;
        this.left = left;
        this.right = right;
        this.collidable = collidable;
        this.boundingBoxPos1 = boundingBoxPos1;
        this.boundingBoxPos2 = boundingBoxPos2;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.left = NBTUtils.readInfiniteTag((ByteBuf)buf);
        this.right = NBTUtils.readInfiniteTag((ByteBuf)buf);
        this.collidable = buf.readBoolean();
        this.boundingBoxPos1 = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.boundingBoxPos2 = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.left);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.right);
        buf.writeBoolean(this.collidable);
        buf.writeDouble(this.boundingBoxPos1.field_72450_a);
        buf.writeDouble(this.boundingBoxPos1.field_72448_b);
        buf.writeDouble(this.boundingBoxPos1.field_72449_c);
        buf.writeDouble(this.boundingBoxPos2.field_72450_a);
        buf.writeDouble(this.boundingBoxPos2.field_72448_b);
        buf.writeDouble(this.boundingBoxPos2.field_72449_c);
    }
}

