/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.tile;

import java.util.ArrayList;
import java.util.List;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.common.tileentity.TileEntityModelSettings;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.conditions.Checker;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.blocks.PacketEditConditionModel;
import mchorse.mappet.utils.ConditionModel;
import mchorse.mclib.math.Constant;
import mchorse.mclib.math.IValue;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileConditionModel
extends TileEntity
implements ITickable {
    public EntityActor entity;
    public int frequency = 1;
    public boolean isGlobal = true;
    public boolean isShadow = false;
    private TileEntityModelSettings settings;
    public List<ConditionModel> list = new ArrayList<ConditionModel>();
    private int tick;

    public TileConditionModel() {
        this.settings = new TileEntityModelSettings();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        float range = ((Integer)Blockbuster.actorRenderingRange.get()).intValue();
        return range * range;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.updateMorph();
            return;
        }
        int frequency = Math.max(this.frequency, 1);
        Constant constantFalse = new Constant(0.0);
        if (this.tick % frequency == 0) {
            for (EntityPlayer playerEntity : this.field_145850_b.field_73010_i) {
                AbstractMorph morph = null;
                for (ConditionModel conditionModel : this.list) {
                    boolean result = false;
                    DataContext context = new DataContext((Entity)playerEntity);
                    Checker checker = conditionModel.checker;
                    if (checker.mode == Checker.Mode.CONDITION) {
                        result = checker.condition.execute(context);
                    } else {
                        String expression = checker.expression;
                        result = Mappet.expressions.set(context).parse(expression, (IValue)constantFalse).booleanValue();
                    }
                    if (!result || conditionModel.morph.equals(morph)) continue;
                    morph = conditionModel.morph;
                }
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound tagMorph = new NBTTagCompound();
                if (morph != null) {
                    morph.toNBT(tagMorph);
                }
                NBTTagCompound settings = new NBTTagCompound();
                this.settings.toNBT(settings);
                tag.func_74782_a("settings", (NBTBase)settings);
                tag.func_74782_a("morph", (NBTBase)tagMorph);
                tag.func_74757_a("shadow", this.isShadow);
                tag.func_74757_a("global", this.isGlobal);
                Dispatcher.sendTo(new PacketEditConditionModel(this.func_174877_v(), tag).setIsEdit(false), (EntityPlayerMP)playerEntity);
            }
        }
        ++this.tick;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateMorph() {
        if (this.entity == null) {
            this.createEntity(this.field_145850_b);
        }
        if (this.entity.morph.get() != null) {
            this.entity.morph.get().update((EntityLivingBase)this.entity);
        }
        ++this.entity.field_70173_aa;
    }

    public TileEntityModelSettings getSettings() {
        return this.settings;
    }

    public void createEntity(World world) {
        if (world != null) {
            this.entity = new EntityActor(world);
            this.entity.field_70122_E = true;
        }
    }

    public void fill(NBTTagCompound tag) {
        this.list.clear();
        NBTTagList list = tag.func_150295_c("list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound element = list.func_150305_b(i);
            ConditionModel conditionModel = new ConditionModel();
            conditionModel.deserializeNBT(element);
            this.list.add(conditionModel);
        }
        this.frequency = tag.func_74762_e("frequency");
        this.isGlobal = tag.func_74767_n("global");
        this.isShadow = tag.func_74767_n("shadow");
    }

    public NBTTagCompound toNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (ConditionModel element : this.list) {
            list.func_74742_a((NBTBase)element.serializeNBT());
        }
        tag.func_74782_a("list", (NBTBase)list);
        tag.func_74768_a("frequency", this.frequency);
        tag.func_74757_a("global", this.isGlobal);
        tag.func_74757_a("shadow", this.isShadow);
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound settings = new NBTTagCompound();
        this.settings.toNBT(settings);
        tag.func_74782_a("settings", (NBTBase)settings);
        this.toNBT(tag);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.settings = new TileEntityModelSettings();
        this.settings.fromNBT((NBTTagCompound)tag.func_74781_a("settings"));
        this.fill(tag);
    }
}

