/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import java.util.Set;
import mchorse.mappet.common.ScriptedItemProps;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class NBTUtils {
    public static BlockPos blockPosFrom(NBTBase base) {
        if (base instanceof NBTTagList && ((NBTTagList)base).func_74745_c() >= 3) {
            NBTTagList list = (NBTTagList)base;
            NBTBase x = list.func_179238_g(0);
            NBTBase y = list.func_179238_g(1);
            NBTBase z = list.func_179238_g(2);
            if (x instanceof NBTPrimitive && y instanceof NBTPrimitive && z instanceof NBTPrimitive) {
                return new BlockPos(((NBTPrimitive)x).func_150287_d(), ((NBTPrimitive)y).func_150287_d(), ((NBTPrimitive)z).func_150287_d());
            }
        }
        return null;
    }

    public static NBTBase blockPosTo(BlockPos pos) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagInt(pos.func_177958_n()));
        list.func_74742_a((NBTBase)new NBTTagInt(pos.func_177956_o()));
        list.func_74742_a((NBTBase)new NBTTagInt(pos.func_177952_p()));
        return list;
    }

    public static Vec3d vec3dFrom(NBTBase base) {
        if (base instanceof NBTTagList && ((NBTTagList)base).func_74745_c() >= 3) {
            NBTTagList list = (NBTTagList)base;
            NBTBase x = list.func_179238_g(0);
            NBTBase y = list.func_179238_g(1);
            NBTBase z = list.func_179238_g(2);
            if (x instanceof NBTPrimitive && y instanceof NBTPrimitive && z instanceof NBTPrimitive) {
                return new Vec3d(((NBTPrimitive)x).func_150286_g(), ((NBTPrimitive)y).func_150286_g(), ((NBTPrimitive)z).func_150286_g());
            }
        }
        return null;
    }

    public static NBTBase vec3dTo(Vec3d vec) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagDouble(vec.field_72450_a));
        list.func_74742_a((NBTBase)new NBTTagDouble(vec.field_72448_b));
        list.func_74742_a((NBTBase)new NBTTagDouble(vec.field_72449_c));
        return list;
    }

    public static String[] getStringArray(NBTTagList list) {
        String[] array = new String[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            array[i] = list.func_150307_f(i);
        }
        return array;
    }

    public static void writeStringList(NBTTagList list, Set<String> set) {
        set.stream().forEach(string -> list.func_74742_a((NBTBase)new NBTTagString(string)));
    }

    public static boolean saveScriptedItemProps(ItemStack stack, NBTTagCompound tag) {
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return false;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74782_a("ScriptedItem", (NBTBase)tag);
            return true;
        }
        return false;
    }

    public static ScriptedItemProps getScriptedItemProps(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return null;
        }
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("ScriptedItem")) {
            return new ScriptedItemProps(tag.func_74775_l("ScriptedItem"));
        }
        return new ScriptedItemProps();
    }

    public static void setScriptedItemProps(ItemStack itemStack, ScriptedItemProps props) {
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
        }
        compound.func_74782_a("ScriptedItem", (NBTBase)props.toNBT());
    }
}

